package mekanism.common.inventory.container;

import mekanism.common.base.IUpgradeItem;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.inventory.InventoryList;
import mekanism.common.inventory.slot.SlotMachineUpgrade;
import mekanism.common.tile.TileEntityQuantumEntangloporter;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class ContainerUpgradeManagement extends Container
{
	private IUpgradeTile tileEntity;

	public ContainerUpgradeManagement(InventoryPlayer inventory, IUpgradeTile tile)
	{
		tileEntity = tile;

		//Bit of a hack I guess, but we need to give it access to the inventory list, not the Frequency
		IInventory upgradeInv;
		if (tileEntity instanceof TileEntityQuantumEntangloporter)
		{
			upgradeInv = new InventoryList(((TileEntityQuantumEntangloporter) tileEntity).inventory, (TileEntity) tileEntity);
		}
		else
		{
			upgradeInv = (TileEntityContainerBlock)tile;
		}

		func_75146_a(new SlotMachineUpgrade(upgradeInv, tileEntity.getComponent().getUpgradeSlot(), 154, 7));
		
		int slotY;

		for(slotY = 0; slotY < 3; slotY++)
		{
			for(int slotX = 0; slotX < 9; slotX++)
			{
				func_75146_a(new Slot(inventory, slotX + slotY * 9 + 9, 8 + slotX * 18, 84 + slotY * 18));
			}
		}

		for(slotY = 0; slotY < 9; slotY++)
		{
			func_75146_a(new Slot(inventory, slotY, 8 + slotY * 18, 142));
		}

		((TileEntityContainerBlock)tileEntity).open(inventory.field_70458_d);
		((TileEntityContainerBlock)tileEntity).func_174889_b(inventory.field_70458_d);
	}

	@Override
	public void func_75134_a(EntityPlayer entityplayer)
	{
		super.func_75134_a(entityplayer);

		((TileEntityContainerBlock)tileEntity).close(entityplayer);
		((TileEntityContainerBlock)tileEntity).func_174886_c(entityplayer);
	}

	@Override
	public boolean func_75145_c(EntityPlayer entityplayer)
	{
		return ((TileEntityContainerBlock)tileEntity).func_70300_a(entityplayer);
	}

	@Override
	public ItemStack func_82846_b(EntityPlayer player, int slotID)
	{
		ItemStack stack = ItemStack.field_190927_a;
		Slot currentSlot = (Slot)field_75151_b.get(slotID);

		if(currentSlot != null && currentSlot.func_75216_d())
		{
			ItemStack slotStack = currentSlot.func_75211_c();
			stack = slotStack.func_77946_l();

			if(slotStack.func_77973_b() instanceof IUpgradeItem)
			{
				if(slotID != 0)
				{
					if(!func_75135_a(slotStack, 0, 1, false))
					{
						return ItemStack.field_190927_a;
					}
				}
				else {
					if(!func_75135_a(slotStack, 1, field_75151_b.size(), true))
					{
						return ItemStack.field_190927_a;
					}
				}
			}
			else {
				if(slotID >= 1 && slotID <= 27)
				{
					if(!func_75135_a(slotStack, 28, field_75151_b.size(), false))
					{
						return ItemStack.field_190927_a;
					}
				}
				else if(slotID > 27)
				{
					if(!func_75135_a(slotStack, 1, 27, false))
					{
						return ItemStack.field_190927_a;
					}
				}
				else {
					if(!func_75135_a(slotStack, 1, field_75151_b.size(), true))
					{
						return ItemStack.field_190927_a;
					}
				}
			}

			if(slotStack.func_190916_E() == 0)
			{
				currentSlot.func_75215_d(ItemStack.field_190927_a);
			}
			else {
				currentSlot.func_75218_e();
			}

			if(slotStack.func_190916_E() == stack.func_190916_E())
			{
				return ItemStack.field_190927_a;
			}

			currentSlot.func_190901_a(player, slotStack);
		}

		return stack;
	}
}
