package mekanism.common.inventory.container;

import mekanism.common.entity.EntityRobit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotFurnaceOutput;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;

public class ContainerRobitSmelting extends Container
{
	public EntityRobit robit;

	private int lastCookTime = 0;
	private int lastBurnTime = 0;
	private int lastItemBurnTime = 0;

	public ContainerRobitSmelting(InventoryPlayer inventory, EntityRobit entity)
	{
		robit = entity;
		robit.func_174889_b(inventory.field_70458_d);

		func_75146_a(new Slot(entity, 28, 56, 17));
		func_75146_a(new Slot(entity, 29, 56, 53));
		func_75146_a(new SlotFurnaceOutput(inventory.field_70458_d, entity, 30, 116, 35));

		int slotY;

		for(slotY = 0; slotY < 3; slotY++)
		{
			for(int slotX = 0; slotX < 9; slotX++)
			{
				func_75146_a(new Slot(inventory, slotX + slotY * 9 + 9, 8 + slotX * 18, 84 + slotY * 18));
			}
		}

		for(slotY = 0; slotY < 9; slotY++)
		{
			func_75146_a(new Slot(inventory, slotY, 8 + slotY * 18, 142));
		}
	}

	@Override
	public boolean func_75145_c(EntityPlayer entityplayer)
	{
		return !robit.field_70128_L;
	}

	@Override
	public void func_75132_a(IContainerListener icrafting)
	{
		super.func_75132_a(icrafting);
		icrafting.func_71112_a(this, 0, robit.furnaceCookTime);
		icrafting.func_71112_a(this, 1, robit.furnaceBurnTime);
		icrafting.func_71112_a(this, 2, robit.currentItemBurnTime);
	}

	@Override
	public void func_75142_b()
	{
		super.func_75142_b();

		for(int i = 0; i < field_75149_d.size(); ++i)
		{
			IContainerListener icrafting = (IContainerListener)field_75149_d.get(i);

			if(lastCookTime != robit.furnaceCookTime)
			{
				icrafting.func_71112_a(this, 0, robit.furnaceCookTime);
			}

			if(lastBurnTime != robit.furnaceBurnTime)
			{
				icrafting.func_71112_a(this, 1, robit.furnaceBurnTime);
			}

			if(lastItemBurnTime != robit.currentItemBurnTime)
			{
				icrafting.func_71112_a(this, 2, robit.currentItemBurnTime);
			}
		}

		lastCookTime = robit.furnaceCookTime;
		lastBurnTime = robit.furnaceBurnTime;
		lastItemBurnTime = robit.currentItemBurnTime;
	}

	@Override
	public void func_75137_b(int i, int j)
	{
		if(i == 0)
		{
			robit.furnaceCookTime = j;
		}

		if(i == 1)
		{
			robit.furnaceBurnTime = j;
		}

		if(i == 2)
		{
			robit.currentItemBurnTime = j;
		}
	}

	@Override
	public ItemStack func_82846_b(EntityPlayer player, int slotID)
	{
		ItemStack stack = ItemStack.field_190927_a;
		Slot currentSlot = (Slot)field_75151_b.get(slotID);

		if(currentSlot != null && currentSlot.func_75216_d())
		{
			ItemStack slotStack = currentSlot.func_75211_c();
			stack = slotStack.func_77946_l();

			if(slotID == 2)
			{
				if(!func_75135_a(slotStack, 3, 39, true))
				{
					return ItemStack.field_190927_a;
				}
			}
			else if(slotID != 1 && slotID != 0)
			{
				if(!FurnaceRecipes.func_77602_a().func_151395_a(slotStack).func_190926_b())
				{
					if(!func_75135_a(slotStack, 0, 1, false))
					{
						return ItemStack.field_190927_a;
					}
				}
				else if(TileEntityFurnace.func_145954_b(slotStack))
				{
					if(!func_75135_a(slotStack, 1, 2, false))
					{
						return ItemStack.field_190927_a;
					}
				}
				else if(slotID >= 3 && slotID < 30)
				{
					if(!func_75135_a(slotStack, 30, 39, false))
					{
						return ItemStack.field_190927_a;
					}
				}
				else if(slotID >= 30 && slotID < 39 && !func_75135_a(slotStack, 3, 30, false))
				{
					return ItemStack.field_190927_a;
				}
			}
			else if(!func_75135_a(slotStack, 3, 39, false))
			{
				return ItemStack.field_190927_a;
			}

			if(slotStack.func_190916_E() == 0)
			{
				currentSlot.func_75215_d(ItemStack.field_190927_a);
			}
			else {
				currentSlot.func_75218_e();
			}

			if(slotStack.func_190916_E() == stack.func_190916_E())
			{
				return ItemStack.field_190927_a;
			}

			currentSlot.func_190901_a(player, slotStack);
		}

		return stack;
	}

	@Override
	public void func_75134_a(EntityPlayer entityplayer)
	{
		super.func_75134_a(entityplayer);
		robit.func_174886_c(entityplayer);
	}
}
