package mekanism.common.inventory.container;

import mekanism.common.entity.EntityRobit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerRobitInventory extends Container
{
	public EntityRobit robit;

	public ContainerRobitInventory(InventoryPlayer inventory, EntityRobit entity)
	{
		robit = entity;
		robit.func_174889_b(inventory.field_70458_d);

		for(int slotY = 0; slotY < 3; slotY++)
		{
			for(int slotX = 0; slotX < 9; slotX++)
			{
				func_75146_a(new Slot(entity, slotX + slotY * 9, 8 + slotX * 18, 18 + slotY * 18));
			}
		}

		int slotX;

		for(slotX = 0; slotX < 3; ++slotX)
		{
			for(int slotY = 0; slotY < 9; ++slotY)
			{
				func_75146_a(new Slot(inventory, slotY + slotX * 9 + 9, 8 + slotY * 18, 84 + slotX * 18));
			}
		}

		for(slotX = 0; slotX < 9; slotX++)
		{
			func_75146_a(new Slot(inventory, slotX, 8 + slotX * 18, 142));
		}
	}

	@Override
	public boolean func_75145_c(EntityPlayer entityplayer)
	{
		return !robit.field_70128_L;
	}

	@Override
	public ItemStack func_82846_b(EntityPlayer player, int slotID)
	{
		ItemStack stack = ItemStack.field_190927_a;
		Slot currentSlot = (Slot)field_75151_b.get(slotID);

		if(currentSlot != null && currentSlot.func_75216_d())
		{
			ItemStack slotStack = currentSlot.func_75211_c();
			stack = slotStack.func_77946_l();

			if(slotID < 27)
			{
				if(!func_75135_a(slotStack, 27, field_75151_b.size(), true))
				{
					return ItemStack.field_190927_a;
				}
			}
			else if(!func_75135_a(slotStack, 0, 27, false))
			{
				return ItemStack.field_190927_a;
			}

			if(slotStack.func_190916_E() == 0)
			{
				currentSlot.func_75215_d(ItemStack.field_190927_a);
			}
			else {
				currentSlot.func_75218_e();
			}

			if(slotStack.func_190916_E() == stack.func_190916_E())
			{
				return ItemStack.field_190927_a;
			}

			currentSlot.func_190901_a(player, slotStack);
		}

		return stack;
	}

	@Override
	public void func_75134_a(EntityPlayer entityplayer)
	{
		super.func_75134_a(entityplayer);
		robit.func_174886_c(entityplayer);
	}
}
