package mekanism.common.inventory.container;

import invtweaks.api.container.ChestContainer;
import mekanism.common.block.states.BlockStateMachine.MachineType;
import mekanism.common.inventory.slot.SlotPersonalChest;
import mekanism.common.tile.TileEntityPersonalChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

@ChestContainer(isLargeChest=true)
public class ContainerPersonalChest extends Container
{
	private TileEntityPersonalChest tileEntity;
	private IInventory itemInventory;
	private boolean isBlock;

	public ContainerPersonalChest(InventoryPlayer inventory, TileEntityPersonalChest tentity, IInventory inv, boolean b)
	{
		tileEntity = tentity;
		itemInventory = inv;
		isBlock = b;

		if(isBlock)
		{
			tileEntity.open(inventory.field_70458_d);
			tileEntity.func_174889_b(inventory.field_70458_d);
		}
		else {
			itemInventory.func_174889_b(inventory.field_70458_d);
		}

		for(int slotY = 0; slotY < 6; slotY++)
		{
			for(int slotX = 0; slotX < 9; slotX++)
			{
				func_75146_a(new SlotPersonalChest(getInv(), slotX + slotY * 9, 8 + slotX * 18, 26 + slotY * 18));
			}
		}

		int slotX;

		for(slotX = 0; slotX < 3; ++slotX)
		{
			for(int slotY = 0; slotY < 9; ++slotY)
			{
				func_75146_a(new SlotPersonalChest(inventory, slotY + slotX * 9 + 9, 8 + slotY * 18, 148 + slotX * 18));
			}
		}

		for(slotX = 0; slotX < 9; ++slotX)
		{
			func_75146_a(new SlotPersonalChest(inventory, slotX, 8 + slotX * 18, 206));
		}
	}

	public IInventory getInv()
	{
		if(isBlock)
		{
			return tileEntity;
		}
		else {
			return itemInventory;
		}
	}

	@Override
	public void func_75134_a(EntityPlayer entityplayer)
	{
		super.func_75134_a(entityplayer);

		if(isBlock)
		{
			tileEntity.close(entityplayer);
			tileEntity.func_174886_c(entityplayer);
		}
		else {
			itemInventory.func_174886_c(entityplayer);
		}
	}

	@Override
	public boolean func_75145_c(EntityPlayer entityplayer)
	{
		if(isBlock)
		{
			return tileEntity.func_70300_a(entityplayer);
		}

		return true;
	}

	@Override
	public ItemStack func_82846_b(EntityPlayer player, int slotID)
	{
		ItemStack stack = ItemStack.field_190927_a;
		Slot currentSlot = field_75151_b.get(slotID);

		if(currentSlot != null && currentSlot.func_75216_d())
		{
			ItemStack slotStack = currentSlot.func_75211_c();
			stack = slotStack.func_77946_l();

			if(slotID < 54)
			{
				if(!func_75135_a(slotStack, 54, field_75151_b.size(), true))
				{
					return ItemStack.field_190927_a;
				}
			}
			else if(!func_75135_a(slotStack, 0, 54, false))
			{
				return ItemStack.field_190927_a;
			}

			if(slotStack.func_190916_E() == 0)
			{
				currentSlot.func_75215_d(ItemStack.field_190927_a);
			}
			else {
				currentSlot.func_75218_e();
			}

			if(slotStack.func_190916_E() == stack.func_190916_E())
			{
				return ItemStack.field_190927_a;
			}

			currentSlot.func_190901_a(player, slotStack);
		}

		return stack;
	}

	@Override
	public ItemStack func_184996_a(int slotNumber, int destSlot, ClickType clickType, EntityPlayer player)
	{
		if(destSlot >= 0 && destSlot < 9)
		{
			ItemStack itemStack = player.field_71071_by.func_70301_a(destSlot);
			
			if(!itemStack.func_190926_b() && MachineType.get(itemStack) == MachineType.PERSONAL_CHEST)
			{
				return ItemStack.field_190927_a;
			}
		}

		return super.func_184996_a(slotNumber, destSlot, clickType, player);
	}
}
