package mekanism.common.inventory.container;

import mekanism.common.inventory.slot.SlotEnergy.SlotDischarge;
import mekanism.common.inventory.slot.SlotOutput;
import mekanism.common.inventory.slot.SlotSpecific;
import mekanism.common.item.ItemCraftingFormula;
import mekanism.common.tile.TileEntityFormulaicAssemblicator;
import mekanism.common.util.ChargeUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerFormulaicAssemblicator extends Container
{
	private TileEntityFormulaicAssemblicator tileEntity;

	public ContainerFormulaicAssemblicator(InventoryPlayer inventory, TileEntityFormulaicAssemblicator tentity)
	{
		tileEntity = tentity;
		func_75146_a(new SlotDischarge(tentity, 1, 152, 76));
		func_75146_a(new SlotSpecific(tentity, 2, 6, 26, ItemCraftingFormula.class));
		
		int slotY;
		
		for(slotY = 0; slotY < 2; slotY++)
		{
			for(int slotX = 0; slotX < 9; slotX++)
			{
				func_75146_a(new Slot(tentity, slotX + slotY * 9 + 3, 8 + slotX * 18, 98 + slotY * 18));
			}
		}
		
		for(slotY = 0; slotY < 3; slotY++)
		{
			for(int slotX = 0; slotX < 3; slotX++)
			{
				func_75146_a(new Slot(tentity, slotX + slotY * 3 + 27, 26 + slotX * 18, 17 + slotY * 18) {
					@Override
					public boolean func_75214_a(ItemStack stack)
					{
						return !tileEntity.autoMode;
					}
					
					@Override
					public boolean func_82869_a(EntityPlayer player)
					{
						return !tileEntity.autoMode;
					}
					
					@SideOnly(Side.CLIENT)
				    public boolean func_111238_b()
				    {
						return !tileEntity.autoMode;
				    }
				});
			}
		}
		
		for(slotY = 0; slotY < 3; slotY++)
		{
			for(int slotX = 0; slotX < 2; slotX++)
			{
				func_75146_a(new SlotOutput(tentity, slotX + slotY * 2 + 21, 116 + slotX * 18, 17 + slotY * 18));
			}
		}

		for(slotY = 0; slotY < 3; slotY++)
		{
			for(int slotX = 0; slotX < 9; slotX++)
			{
				func_75146_a(new Slot(inventory, slotX + slotY * 9 + 9, 8 + slotX * 18, 148 + slotY * 18));
			}
		}

		for(slotY = 0; slotY < 9; slotY++)
		{
			func_75146_a(new Slot(inventory, slotY, 8 + slotY * 18, 206));
		}

		tileEntity.open(inventory.field_70458_d);
		tileEntity.func_174889_b(inventory.field_70458_d);
	}

	@Override
	public void func_75134_a(EntityPlayer entityplayer)
	{
		super.func_75134_a(entityplayer);

		tileEntity.close(entityplayer);
		tileEntity.func_174886_c(entityplayer);
	}

	@Override
	public boolean func_75145_c(EntityPlayer entityplayer)
	{
		return tileEntity.func_70300_a(entityplayer);
	}

	@Override
	public ItemStack func_82846_b(EntityPlayer player, int slotID)
	{
		ItemStack stack = ItemStack.field_190927_a;
		Slot currentSlot = (Slot)field_75151_b.get(slotID);

		if(currentSlot != null && currentSlot.func_75216_d())
		{
			ItemStack slotStack = currentSlot.func_75211_c();
			stack = slotStack.func_77946_l();

			if(ChargeUtils.canBeDischarged(slotStack))
			{
				if(slotID != 0)
				{
					if(!func_75135_a(slotStack, 0, 1, false))
					{
						return ItemStack.field_190927_a;
					}
				}
				else {
					if(!func_75135_a(slotStack, 34, field_75151_b.size(), true))
					{
						return ItemStack.field_190927_a;
					}
				}
			}
			else if(slotStack.func_77973_b() instanceof ItemCraftingFormula)
			{
				if(slotID != 1)
				{
					if(!func_75135_a(slotStack, 1, 2, false))
					{
						return ItemStack.field_190927_a;
					}
				}
				else {
					if(!func_75135_a(slotStack, 34, field_75151_b.size(), true))
					{
						return ItemStack.field_190927_a;
					}
				}
			}
			else if(slotID >= 2 && slotID <= 19)
			{
				if(!func_75135_a(slotStack, 34, field_75151_b.size(), true))
				{
					return ItemStack.field_190927_a;
				}
			}
			else if(tileEntity.formula == null || tileEntity.formula.isIngredient(tileEntity.func_145831_w(), slotStack))
			{
				if(!func_75135_a(slotStack, 2, 20, false))
				{
					return ItemStack.field_190927_a;
				}
			}
			else {
				if(slotID >= 34 && slotID <= 60)
				{
					if(!func_75135_a(slotStack, 61, field_75151_b.size(), false))
					{
						return ItemStack.field_190927_a;
					}
				}
				else if(slotID > 60)
				{
					if(!func_75135_a(slotStack, 34, 60, false))
					{
						return ItemStack.field_190927_a;
					}
				}
				else {
					if(!func_75135_a(slotStack, 34, field_75151_b.size(), true))
					{
						return ItemStack.field_190927_a;
					}
				}
			}

			if(slotStack.func_190916_E() == 0)
			{
				currentSlot.func_75215_d(ItemStack.field_190927_a);
			}
			else {
				currentSlot.func_75218_e();
			}

			if(slotStack.func_190916_E() == stack.func_190916_E())
			{
				return ItemStack.field_190927_a;
			}

			currentSlot.func_190901_a(player, slotStack);
		}

		return stack;
	}
}
