package mekanism.common.inventory.container;

import mekanism.api.infuse.InfuseRegistry;
import mekanism.common.Tier;
import mekanism.common.Tier.FactoryTier;
import mekanism.common.base.IFactory.RecipeType;
import mekanism.common.inventory.slot.SlotEnergy.SlotDischarge;
import mekanism.common.inventory.slot.SlotOutput;
import mekanism.common.item.ItemBlockMachine;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.util.ChargeUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerFactory extends Container
{
	private TileEntityFactory tileEntity;

	public ContainerFactory(InventoryPlayer inventory, TileEntityFactory tentity)
	{
		tileEntity = tentity;

		func_75146_a(new SlotDischarge(tentity, 1, 7, 13));
		func_75146_a(new Slot(tentity, 2, 180, 75));
		func_75146_a(new Slot(tentity, 3, 180, 112));
		func_75146_a(new Slot(tentity, 4, 7, 57));

		if(tileEntity.tier == FactoryTier.BASIC)
		{
			for(int i = 0; i < tileEntity.tier.processes; i++)
			{
				int xAxis = 55 + (i*38);

				func_75146_a(new Slot(tentity, 5+i, xAxis, 13));
			}

			for(int i = 0; i < tileEntity.tier.processes; i++)
			{
				int xAxis = 55 + (i*38);

				func_75146_a(new SlotOutput(tentity, tileEntity.tier.processes+5+i, xAxis, 57));
			}
		}
		else if(tileEntity.tier == FactoryTier.ADVANCED)
		{
			for(int i = 0; i < tileEntity.tier.processes; i++)
			{
				int xAxis = 35 + (i*26);

				func_75146_a(new Slot(tentity, 5+i, xAxis, 13));
			}

			for(int i = 0; i < tileEntity.tier.processes; i++)
			{
				int xAxis = 35 + (i*26);

				func_75146_a(new SlotOutput(tentity, tileEntity.tier.processes+5+i, xAxis, 57));
			}
		}
		else if(tileEntity.tier == FactoryTier.ELITE)
		{
			for(int i = 0; i < tileEntity.tier.processes; i++)
			{
				int xAxis = 29 + (i*19);

				func_75146_a(new Slot(tentity, 5+i, xAxis, 13));
			}

			for(int i = 0; i < tileEntity.tier.processes; i++)
			{
				int xAxis = 29 + (i*19);

				func_75146_a(new SlotOutput(tentity, tileEntity.tier.processes+5+i, xAxis, 57));
			}
		}

		int slotY;

		for(slotY = 0; slotY < 3; slotY++)
		{
			for(int slotX = 0; slotX < 9; slotX++)
			{
				func_75146_a(new Slot(inventory, slotX + slotY * 9 + 9, 8 + slotX * 18, 95 + slotY * 18));
			}
		}

		for(int slotX = 0; slotX < 9; slotX++)
		{
			func_75146_a(new Slot(inventory, slotX, 8 + slotX * 18, 153));
		}

		tileEntity.open(inventory.field_70458_d);
		tileEntity.func_174889_b(inventory.field_70458_d);
	}

	@Override
	public void func_75134_a(EntityPlayer entityplayer)
	{
		super.func_75134_a(entityplayer);

		tileEntity.close(entityplayer);
		tileEntity.func_174886_c(entityplayer);
	}

	@Override
	public boolean func_75145_c(EntityPlayer entityplayer)
	{
		return tileEntity.func_70300_a(entityplayer);
	}

	@Override
	public ItemStack func_82846_b(EntityPlayer player, int slotID)
	{
		ItemStack stack = ItemStack.field_190927_a;
		Slot currentSlot = (Slot)field_75151_b.get(slotID);
		
		if(currentSlot != null && currentSlot.func_75216_d())
		{
			ItemStack slotStack = currentSlot.func_75211_c();
			stack = slotStack.func_77946_l();

			if(isOutputSlot(slotID))
			{
				if(!func_75135_a(slotStack, tileEntity.inventory.size()-1, field_75151_b.size(), true))
				{
					return ItemStack.field_190927_a;
				}
			}
			else if(slotID != 1 && slotID != 2 && isProperMachine(slotStack) && !slotStack.func_77969_a(tileEntity.getMachineStack()))
			{
				if(!func_75135_a(slotStack, 1, 2, false))
				{
					return ItemStack.field_190927_a;
				}
			}
			else if(slotID == 2)
			{
				if(!func_75135_a(slotStack, tileEntity.inventory.size()-1, field_75151_b.size(), true))
				{
					return ItemStack.field_190927_a;
				}
			}
			else if(tileEntity.recipeType.getAnyRecipe(slotStack, tileEntity.gasTank.getGasType(), tileEntity.infuseStored) != null)
			{
				if(!isInputSlot(slotID))
				{
					if(!func_75135_a(slotStack, 4, 4+tileEntity.tier.processes, false))
					{
						return ItemStack.field_190927_a;
					}
				}
				else {
					if(!func_75135_a(slotStack, tileEntity.inventory.size()-1, field_75151_b.size(), true))
					{
						return ItemStack.field_190927_a;
					}
				}
			}
			else if(ChargeUtils.canBeDischarged(slotStack))
			{
				if(slotID != 0)
				{
					if(!func_75135_a(slotStack, 0, 1, false))
					{
						return ItemStack.field_190927_a;
					}
				}
				else if(slotID == 0)
				{
					if(!func_75135_a(slotStack, tileEntity.inventory.size()-1, field_75151_b.size(), true))
					{
						return ItemStack.field_190927_a;
					}
				}
			}
			else if(tileEntity.recipeType.getItemGas(slotStack) != null)
			{
				if(slotID >= tileEntity.inventory.size()-1)
				{
					if(!func_75135_a(slotStack, 3, 4, false))
					{
						return ItemStack.field_190927_a;
					}
				}
				else {
					if(!func_75135_a(slotStack, tileEntity.inventory.size()-1, field_75151_b.size(), true))
					{
						return ItemStack.field_190927_a;
					}
				}
			}
			else if(tileEntity.recipeType == RecipeType.INFUSING && InfuseRegistry.getObject(slotStack) != null && (tileEntity.infuseStored.type == null || tileEntity.infuseStored.type == InfuseRegistry.getObject(slotStack).type))
			{
				if(slotID >= tileEntity.inventory.size()-1)
				{
					if(!func_75135_a(slotStack, 3, 4, false))
					{
						return ItemStack.field_190927_a;
					}
				}
				else {
					if(!func_75135_a(slotStack, tileEntity.inventory.size()-1, field_75151_b.size(), true))
					{
						return ItemStack.field_190927_a;
					}
				}
			}
			else {
				int slotEnd = tileEntity.inventory.size()-1;

				if(slotID >= slotEnd && slotID <= (slotEnd+26))
				{
					if(!func_75135_a(slotStack, (slotEnd+27), field_75151_b.size(), false))
					{
						return ItemStack.field_190927_a;
					}
				}
				else if(slotID > (slotEnd+26))
				{
					if(!func_75135_a(slotStack, slotEnd, (slotEnd+26), false))
					{
						return ItemStack.field_190927_a;
					}
				}
				else {
					if(!func_75135_a(slotStack, slotEnd, field_75151_b.size(), true))
					{
						return ItemStack.field_190927_a;
					}
				}
			}

			if(slotStack.func_190916_E() == 0)
			{
				currentSlot.func_75215_d(ItemStack.field_190927_a);
			}
			else {
				currentSlot.func_75218_e();
			}

			if(slotStack.func_190916_E() == stack.func_190916_E())
			{
				return ItemStack.field_190927_a;
			}

			currentSlot.func_190901_a(player, slotStack);
		}

		return stack;
	}

	public boolean isProperMachine(ItemStack itemStack)
	{
		if(!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemBlockMachine)
		{
			for(RecipeType type : RecipeType.values())
			{
				return itemStack.func_77969_a(type.getStack());
			}
		}

		return false;
	}

	public boolean isInputSlot(int slot)
	{
		return slot >= 4 && slot < 4+tileEntity.tier.processes;
	}

	public boolean isOutputSlot(int slot)
	{
		return slot >= 4+tileEntity.tier.processes && slot < 4+tileEntity.tier.processes*2;
	}
}
