package mekanism.common.inventory.container;

import ic2.api.item.IElectricItem;
import mekanism.common.inventory.slot.SlotEnergy.SlotCharge;
import mekanism.common.inventory.slot.SlotEnergy.SlotDischarge;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerEnergyCube extends Container
{
	private TileEntityEnergyCube tileEntity;

	public ContainerEnergyCube(InventoryPlayer inventory, TileEntityEnergyCube unit)
	{
		tileEntity = unit;
		
		func_75146_a(new SlotCharge(unit, 0, 143, 35));
		func_75146_a(new SlotDischarge(unit, 1, 17, 35));

		int slotY;

		for(slotY = 0; slotY < 3; slotY++)
		{
			for(int slotX = 0; slotX < 9; slotX++)
			{
				func_75146_a(new Slot(inventory, slotX + slotY * 9 + 9, 8 + slotX * 18, 84 + slotY * 18));
			}
		}

		for(slotY = 0; slotY < 9; slotY++)
		{
			func_75146_a(new Slot(inventory, slotY, 8 + slotY * 18, 142));
		}

		tileEntity.open(inventory.field_70458_d);
		tileEntity.func_174889_b(inventory.field_70458_d);
	}

	@Override
	public void func_75134_a(EntityPlayer entityplayer)
	{
		super.func_75134_a(entityplayer);

		tileEntity.close(entityplayer);
		tileEntity.func_174886_c(entityplayer);
	}

	@Override
	public boolean func_75145_c(EntityPlayer entityplayer)
	{
		return tileEntity.func_70300_a(entityplayer);
	}

	@Override
	public ItemStack func_82846_b(EntityPlayer player, int slotID)
	{
		ItemStack stack = ItemStack.field_190927_a;
		Slot currentSlot = (Slot)field_75151_b.get(slotID);

		if(currentSlot != null && currentSlot.func_75216_d())
		{
			ItemStack slotStack = currentSlot.func_75211_c();
			stack = slotStack.func_77946_l();

			if(ChargeUtils.canBeCharged(slotStack) || ChargeUtils.canBeDischarged(slotStack))
			{
				if(slotStack.func_77973_b() == Items.field_151137_ax)
				{
					if(slotID != 1)
					{
						if(!func_75135_a(slotStack, 1, 2, false))
						{
							return ItemStack.field_190927_a;
						}
					}
					else {
						if(!func_75135_a(slotStack, 2, field_75151_b.size(), true))
						{
							return ItemStack.field_190927_a;
						}
					}
				}
				else {
					if(slotID != 1 && slotID != 0)
					{
						if(ChargeUtils.canBeDischarged(slotStack))
						{
							if(!func_75135_a(slotStack, 1, 2, false))
							{
								if(canTransfer(slotStack))
								{
									if(!func_75135_a(slotStack, 0, 1, false))
									{
										return ItemStack.field_190927_a;
									}
								}
							}
						}
						else if(canTransfer(slotStack))
						{
							if(!func_75135_a(slotStack, 0, 1, false))
							{
								return ItemStack.field_190927_a;
							}
						}
					}
					else if(slotID == 1)
					{
						if(canTransfer(slotStack))
						{
							if(!func_75135_a(slotStack, 0, 1, false))
							{
								if(!func_75135_a(slotStack, 2, field_75151_b.size(), true))
								{
									return ItemStack.field_190927_a;
								}
							}
						}
						else {
							if(!func_75135_a(slotStack, 2, field_75151_b.size(), true))
							{
								return ItemStack.field_190927_a;
							}
						}
					}
					else if(slotID == 0)
					{
						if(!func_75135_a(slotStack, 2, field_75151_b.size(), true))
						{
							return ItemStack.field_190927_a;
						}
					}
				}
			}
			else {
				if(slotID >= 2 && slotID <= 28)
				{
					if(!func_75135_a(slotStack, 29, field_75151_b.size(), false))
					{
						return ItemStack.field_190927_a;
					}
				}
				else if(slotID > 28)
				{
					if(!func_75135_a(slotStack, 2, 28, false))
					{
						return ItemStack.field_190927_a;
					}
				}
				else {
					if(!func_75135_a(slotStack, 2, field_75151_b.size(), true))
					{
						return ItemStack.field_190927_a;
					}
				}
			}

			if(slotStack.func_190916_E() == 0)
			{
				currentSlot.func_75215_d(ItemStack.field_190927_a);
			}
			else {
				currentSlot.func_75218_e();
			}

			if(slotStack.func_190916_E() == stack.func_190916_E())
			{
				return ItemStack.field_190927_a;
			}

			currentSlot.func_190901_a(player, slotStack);
		}

		return stack;
	}

	private boolean canTransfer(ItemStack slotStack)
	{
		return MekanismUtils.useIC2() && slotStack.func_77973_b() instanceof IElectricItem;
	}
}
