package mekanism.common.inventory.container;

import mekanism.common.inventory.slot.SlotEnergy.SlotDischarge;
import mekanism.common.inventory.slot.SlotOutput;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.tile.prefab.TileEntityElectricMachine;
import mekanism.common.util.ChargeUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerElectricMachine extends Container
{
	private TileEntityElectricMachine tileEntity;

	public ContainerElectricMachine(InventoryPlayer inventory, TileEntityElectricMachine tentity)
	{
		tileEntity = tentity;
		func_75146_a(new Slot(tentity, 0, 56, 17));
		func_75146_a(new SlotDischarge(tentity, 1, 56, 53));
		func_75146_a(new SlotOutput(tentity, 2, 116, 35));
		
		int slotY;

		for(slotY = 0; slotY < 3; slotY++)
		{
			for(int slotX = 0; slotX < 9; slotX++)
			{
				func_75146_a(new Slot(inventory, slotX + slotY * 9 + 9, 8 + slotX * 18, 84 + slotY * 18));
			}
		}

		for(slotY = 0; slotY < 9; slotY++)
		{
			func_75146_a(new Slot(inventory, slotY, 8 + slotY * 18, 142));
		}

		tileEntity.open(inventory.field_70458_d);
		tileEntity.func_174889_b(inventory.field_70458_d);
	}

	@Override
	public void func_75134_a(EntityPlayer entityplayer)
	{
		super.func_75134_a(entityplayer);

		tileEntity.close(entityplayer);
		tileEntity.func_174886_c(entityplayer);
	}

	@Override
	public boolean func_75145_c(EntityPlayer entityplayer)
	{
		return tileEntity.func_70300_a(entityplayer);
	}

	@Override
	public ItemStack func_82846_b(EntityPlayer player, int slotID)
	{
		ItemStack stack = ItemStack.field_190927_a;
		Slot currentSlot = (Slot)field_75151_b.get(slotID);

		if(currentSlot != null && currentSlot.func_75216_d())
		{
			ItemStack slotStack = currentSlot.func_75211_c();
			stack = slotStack.func_77946_l();

			if(slotID == 2)
			{
				if(!func_75135_a(slotStack, 3, field_75151_b.size(), true))
				{
					return ItemStack.field_190927_a;
				}
			}
			else if(RecipeHandler.getRecipe(new ItemStackInput(slotStack), tileEntity.getRecipes()) != null)
			{
				if(slotID != 0 && slotID != 1 && slotID != 2)
				{
					if(!func_75135_a(slotStack, 0, 1, false))
					{
						return ItemStack.field_190927_a;
					}
				}
				else {
					if(!func_75135_a(slotStack, 3, field_75151_b.size(), true))
					{
						return ItemStack.field_190927_a;
					}
				}
			}
			else if(ChargeUtils.canBeDischarged(slotStack))
			{
				if(slotID != 1)
				{
					if(!func_75135_a(slotStack, 1, 2, false))
					{
						return ItemStack.field_190927_a;
					}
				}
				else if(slotID == 1)
				{
					if(!func_75135_a(slotStack, 3, field_75151_b.size(), true))
					{
						return ItemStack.field_190927_a;
					}
				}
			}
			else {
				if(slotID >= 3 && slotID <= 29)
				{
					if(!func_75135_a(slotStack, 30, field_75151_b.size(), false))
					{
						return ItemStack.field_190927_a;
					}
				}
				else if(slotID > 29)
				{
					if(!func_75135_a(slotStack, 3, 29, false))
					{
						return ItemStack.field_190927_a;
					}
				}
				else {
					if(!func_75135_a(slotStack, 3, field_75151_b.size(), true))
					{
						return ItemStack.field_190927_a;
					}
				}
			}

			if(slotStack.func_190916_E() == 0)
			{
				currentSlot.func_75215_d(ItemStack.field_190927_a);
			}
			else {
				currentSlot.func_75218_e();
			}

			if(slotStack.func_190916_E() == stack.func_190916_E())
			{
				return ItemStack.field_190927_a;
			}

			currentSlot.func_190901_a(player, slotStack);
		}

		return stack;
	}
}
