package mekanism.common.inventory;

import mekanism.common.base.ISustainedInventory;
import mekanism.common.util.InventoryUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;

public class InventoryPersonalChest extends InventoryBasic
{
	public EntityPlayer entityPlayer;
	public ItemStack itemStack = ItemStack.field_190927_a;

	public boolean reading;
	
	public EnumHand currentHand = EnumHand.MAIN_HAND;

	public InventoryPersonalChest(EntityPlayer player, EnumHand hand)
	{
		super("PersonalChest", false, 55);
		entityPlayer = player;
		currentHand = hand;

		read();
	}

	public InventoryPersonalChest(ItemStack stack)
	{
		super("PersonalChest", false, 55);
		itemStack = stack;

		read();
	}

	@Override
	public void func_70296_d()
	{
		super.func_70296_d();

		if(!reading)
		{
			write();
		}
	}

	@Override
	public void func_174889_b(EntityPlayer player)
	{
		read();
	}

	@Override
	public void func_174886_c(EntityPlayer player)
	{
		write();
	}

	public void write()
	{
		NBTTagList tagList = new NBTTagList();

		for(int slotCount = 0; slotCount < func_70302_i_(); slotCount++)
		{
			if(!func_70301_a(slotCount).func_190926_b())
			{
				NBTTagCompound tagCompound = new NBTTagCompound();
				tagCompound.func_74774_a("Slot", (byte)slotCount);
				func_70301_a(slotCount).func_77955_b(tagCompound);
				tagList.func_74742_a(tagCompound);
			}
		}

		if(!getStack().func_190926_b())
		{
			((ISustainedInventory)getStack().func_77973_b()).setInventory(tagList, getStack());
		}
	}

	public void read()
	{
		if(reading)
		{
			return;
		}

		reading = true;

		NBTTagList tagList = ((ISustainedInventory)getStack().func_77973_b()).getInventory(getStack());

		if(tagList != null)
		{
			for(int tagCount = 0; tagCount < tagList.func_74745_c(); tagCount++)
			{
				NBTTagCompound tagCompound = (NBTTagCompound)tagList.func_150305_b(tagCount);
				byte slotID = tagCompound.func_74771_c("Slot");

				if(slotID >= 0 && slotID < func_70302_i_())
				{
					func_70299_a(slotID, InventoryUtils.loadFromNBT(tagCompound));
				}
			}
		}

		reading = false;
	}

	public ItemStack getStack()
	{
		return !itemStack.func_190926_b() ? itemStack : entityPlayer.func_184586_b(currentHand);
	}
}
