package mekanism.common.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

/*Copied & modified from net.minecraft.inventory.InventoryBasic */
public class InventoryList implements IInventory
{
    private String inventoryTitle;
    private final int slotsCount;
    private final NonNullList<ItemStack> inventoryContents;
    private final TileEntity te;

    public InventoryList(NonNullList<ItemStack> list, TileEntity parent)
    {
        this.inventoryTitle = "Proxy";
        this.slotsCount = list.size();
        this.inventoryContents = list;
        this.te = parent;
    }

    /**
     * Returns the stack in the given slot.
     */
    public ItemStack func_70301_a(int index)
    {
        return index >= 0 && index < this.inventoryContents.size() ? (ItemStack)this.inventoryContents.get(index) : ItemStack.field_190927_a;
    }

    /**
     * Removes up to a specified number of items from an inventory slot and returns them in a new stack.
     */
    public ItemStack func_70298_a(int index, int count)
    {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventoryContents, index, count);

        if (!itemstack.func_190926_b())
        {
            this.func_70296_d();
        }

        return itemstack;
    }

    /**
     * Removes a stack from the given slot and returns it.
     */
    public ItemStack func_70304_b(int index)
    {
        ItemStack itemstack = (ItemStack)this.inventoryContents.get(index);

        if (itemstack.func_190926_b())
        {
            return ItemStack.field_190927_a;
        }
        else
        {
            this.inventoryContents.set(index, ItemStack.field_190927_a);
            return itemstack;
        }
    }

    /**
     * Sets the given item stack to the specified slot in the inventory (can be crafting or armor sections).
     */
    public void func_70299_a(int index, ItemStack stack)
    {
        this.inventoryContents.set(index, stack);

        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_())
        {
            stack.func_190920_e(this.func_70297_j_());
        }

        this.func_70296_d();
    }

    /**
     * Returns the number of slots in the inventory.
     */
    public int func_70302_i_()
    {
        return this.slotsCount;
    }

    public boolean func_191420_l()
    {
        for (ItemStack itemstack : this.inventoryContents)
        {
            if (!itemstack.func_190926_b())
            {
                return false;
            }
        }

        return true;
    }

    /**
     * Get the name of this object. For players this returns their username
     */
    public String func_70005_c_()
    {
        return this.inventoryTitle;
    }

    /**
     * Returns true if this thing is named
     */
    public boolean func_145818_k_()
    {
        return false;
    }

    /**
     * Sets the name of this inventory. This is displayed to the client on opening.
     */
    public void setCustomName(String inventoryTitleIn)
    {

    }

    /**
     * Get the formatted ChatComponent that will be used for the sender's username in chat
     */
    public ITextComponent func_145748_c_()
    {
        return (ITextComponent)(this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]));
    }

    /**
     * Returns the maximum stack size for a inventory slot. Seems to always be 64, possibly will be extended.
     */
    public int func_70297_j_()
    {
        return 64;
    }

    /**
     * For tile entities, ensures the chunk containing the tile entity is saved to disk later - the game won't think it
     * hasn't changed and skip it.
     */
    public void func_70296_d()
    {
        this.te.func_70296_d();
    }

    /**
     * Don't rename this method to canInteractWith due to conflicts with Container
     */
    public boolean func_70300_a(EntityPlayer player)
    {
        return true;
    }

    public void func_174889_b(EntityPlayer player)
    {
    }

    public void func_174886_c(EntityPlayer player)
    {
    }

    /**
     * Returns true if automation is allowed to insert the given stack (ignoring stack size) into the given slot. For
     * guis use Slot.isItemValid
     */
    public boolean func_94041_b(int index, ItemStack stack)
    {
        return true;
    }

    public int func_174887_a_(int id)
    {
        return 0;
    }

    public void func_174885_b(int id, int value)
    {
    }

    public int func_174890_g()
    {
        return 0;
    }

    public void func_174888_l()
    {
        this.inventoryContents.clear();
    }
}
