package mekanism.common.inventory;

import mekanism.common.Tier.BinTier;
import mekanism.common.base.ITierItem;
import mekanism.common.block.states.BlockStateBasic.BasicBlockType;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class InventoryBin
{
	public ItemStack bin;

	public InventoryBin(ItemStack stack)
	{
		bin = stack;
	}

	public ItemStack getStack()
	{
		if(getItemCount() > 0 && !getItemType().func_190926_b())
		{
			ItemStack ret = getItemType().func_77946_l();
			ret.func_190920_e(Math.min(getItemType().func_77976_d(), getItemCount()));

			return ret;
		}

		return ItemStack.field_190927_a;
	}

	public ItemStack removeStack()
	{
		ItemStack stack = getStack();

		if(stack.func_190926_b())
		{
			return ItemStack.field_190927_a;
		}

		if(getTier() != BinTier.CREATIVE)
		{
			setItemCount(getItemCount() - stack.func_190916_E());
		}
		
		return stack.func_77946_l();
	}

	public ItemStack add(ItemStack stack)
	{
		if(isValid(stack) && (getTier() == BinTier.CREATIVE || getItemCount() != getMaxStorage()))
		{
			if(getItemType().func_190926_b())
			{
				setItemType(stack);
			}

			if(getTier() != BinTier.CREATIVE)
			{
				if(getItemCount() + stack.func_190916_E() <= getMaxStorage())
				{
					setItemCount(getItemCount() + stack.func_190916_E());
					return ItemStack.field_190927_a;
				}
				else {
					ItemStack rejects = getItemType().func_77946_l();
					rejects.func_190920_e((getItemCount()+stack.func_190916_E()) - getMaxStorage());
	
					setItemCount(getMaxStorage());
	
					return rejects;
				}
			}
			else {
				setItemCount(Integer.MAX_VALUE);
			}
		}

		return stack;
	}

	public boolean isValid(ItemStack stack)
	{
		if(stack.func_190926_b() || stack.func_190916_E() <= 0)
		{
			return false;
		}

		if(BasicBlockType.get(stack) == BasicBlockType.BIN)
		{
			return false;
		}

		if(getItemType().func_190926_b())
		{
			return true;
		}

		if(!stack.func_77969_a(getItemType()) || !ItemStack.func_77970_a(stack, getItemType()))
		{
			return false;
		}

		return true;
	}
	
	public int getMaxStorage()
	{
		return getTier().storage;
	}
	
	public BinTier getTier()
	{
		return BinTier.values()[((ITierItem)bin.func_77973_b()).getBaseTier(bin).ordinal()];
	}

	public int getItemCount()
	{
		return ItemDataUtils.getInt(bin, "itemCount");
	}

	public void setItemCount(int count)
	{
		ItemDataUtils.setInt(bin, "itemCount", Math.max(0, count));

		if(getItemCount() == 0)
		{
			setItemType(ItemStack.field_190927_a);
		}
	}

	public ItemStack getItemType()
	{
		if(getItemCount() == 0)
		{
			return ItemStack.field_190927_a;
		}

		return InventoryUtils.loadFromNBT(ItemDataUtils.getCompound(bin, "storedItem"));
	}

	public void setItemType(ItemStack stack)
	{
		if(stack.func_190926_b())
		{
			ItemDataUtils.removeData(bin, "storedItem");
			return;
		}

		ItemDataUtils.setCompound(bin, "storedItem", StackUtils.size(stack, 1).func_77955_b(new NBTTagCompound()));
	}
}
