package mekanism.common.frequency;

import io.netty.buffer.ByteBuf;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

import mekanism.api.Coord4D;
import mekanism.common.PacketHandler;
import mekanism.common.util.MekanismUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.UsernameCache;

import javax.annotation.Nullable;

public class Frequency
{
	public static final String TELEPORTER = "Teleporter";
	
	public String name;
	public UUID ownerUUID;
	public String clientOwner;
	
	public boolean valid = true;
	
	public boolean publicFreq;
	
	public Set<Coord4D> activeCoords = new HashSet<Coord4D>();
	
	public Frequency(String n, UUID uuid)
	{
		name = n;
		ownerUUID = uuid;
	}
	
	public Frequency(NBTTagCompound nbtTags)
	{
		read(nbtTags);
	}
	
	public Frequency(ByteBuf dataStream)
	{
		read(dataStream);
	}
	
	public Frequency setPublic(boolean isPublic)
	{
		publicFreq = isPublic;
		
		return this;
	}
	
	public boolean isPublic()
	{
		return publicFreq;
	}
	
	public boolean isPrivate()
	{
		return !publicFreq;
	}
	
	public Coord4D getClosestCoords(Coord4D coord)
	{
		Coord4D closest = null;
		
		for(Coord4D iterCoord : activeCoords)
		{
			if(iterCoord.equals(coord))
			{
				continue;
			}
			
			if(closest == null)
			{
				closest = iterCoord;
				continue;
			}
			
			if(coord.dimensionId != closest.dimensionId && coord.dimensionId == iterCoord.dimensionId)
			{
				closest = iterCoord;
				continue;
			}
			else if(coord.dimensionId == closest.dimensionId && coord.dimensionId != iterCoord.dimensionId)
			{
				continue;
			}
			else {
				if(coord.distanceTo(closest) > coord.distanceTo(iterCoord))
				{
					closest = iterCoord;
					continue;
				}
				else {
					continue;
				}
			}
		}
		
		return closest;
	}
	
	public void write(NBTTagCompound nbtTags)
	{
		nbtTags.func_74778_a("name", name);
		nbtTags.func_74778_a("ownerUUID", ownerUUID.toString());
		nbtTags.func_74757_a("publicFreq", publicFreq);
	}

	protected void read(NBTTagCompound nbtTags)
	{
		name = nbtTags.func_74779_i("name");
		ownerUUID = UUID.fromString(nbtTags.func_74779_i("ownerUUID"));
		publicFreq = nbtTags.func_74767_n("publicFreq");
	}

	public void write(ArrayList<Object> data)
	{
		data.add(name);
		data.add(ownerUUID.toString());
		data.add(MekanismUtils.getLastKnownUsername(ownerUUID));
		data.add(publicFreq);
	}

	protected void read(ByteBuf dataStream)
	{
		name = PacketHandler.readString(dataStream);
		ownerUUID = UUID.fromString(PacketHandler.readString(dataStream));
		clientOwner = PacketHandler.readString(dataStream);
		publicFreq = dataStream.readBoolean();
	}
	
	@Override
	public int hashCode()
	{
		int code = 1;
		code = 31 * code + name.hashCode();
		code = 31 * code + ownerUUID.hashCode();
		code = 31 * code + (publicFreq ? 1 : 0);
		return code;
	}

	@Override
	public boolean equals(Object obj)
	{
		return obj instanceof Frequency && ((Frequency)obj).name.equals(name) 
				&& ((Frequency)obj).ownerUUID.equals(ownerUUID) && ((Frequency)obj).publicFreq == publicFreq;
	}

	public Identity getIdentity(){
		return new Identity(this.name, this.publicFreq);
	}

	public static class Identity {
		public String name;
		public boolean publicFreq;

		private Identity(String name, boolean publicFreq)
		{
			this.name = name;
			this.publicFreq = publicFreq;
		}

		@Nullable
		public static Identity load(NBTTagCompound data)
		{
			if (!data.func_74779_i("name").isEmpty()){
				return new Identity(data.func_74779_i("name"), data.func_74767_n("publicFreq"));
			}
			return null;
		}

		public NBTTagCompound serialise()
		{
			NBTTagCompound tag = new NBTTagCompound();
			tag.func_74778_a("name", this.name);
			tag.func_74757_a("publicFreq", this.publicFreq);
			return tag;
		}
	}
}
