package mekanism.common.entity.ai;

import java.util.Iterator;
import java.util.List;

import mekanism.common.entity.EntityRobit;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

/*
 * 	Written by pixlepix (I'm in mekanism! Yay!)
 *	Boilerplate copied from RobitAIFollow
 */
public class RobitAIPickup extends EntityAIBase
{
	/** The robit entity. */
	private EntityRobit theRobit;

	/** The world the robit is located in. */
	private World world;

	/** How fast the robit can travel. */
	private float moveSpeed;

	/** The robit's pathfinder. */
	private PathNavigate thePathfinder;

	/** The ticker for updates. */
	private int ticker;

	private float oldWaterCost;
	
	private EntityItem closest;

	public RobitAIPickup(EntityRobit entityRobit, float speed)
	{
		theRobit = entityRobit;
		world = entityRobit.field_70170_p;
		moveSpeed = speed;
		thePathfinder = entityRobit.func_70661_as();
	}

	@Override
	public boolean func_75250_a()
	{
		if(!theRobit.getDropPickup())
		{
			return false;
		}
		
		if(closest != null && closest.func_70068_e(closest) > 100 && thePathfinder.func_75488_a(closest.field_70165_t, closest.field_70163_u, closest.field_70161_v) != null)
		{
			return true;
		}

		List items = theRobit.field_70170_p.func_72872_a(EntityItem.class, new AxisAlignedBB(theRobit.field_70165_t-10, theRobit.field_70163_u-10, theRobit.field_70161_v-10, theRobit.field_70165_t+10, theRobit.field_70163_u+10, theRobit.field_70161_v+10));
		Iterator iter = items.iterator();
		//Cached for slight performance
		double closestDistance = -1;

		while(iter.hasNext())
		{
			EntityItem entity = (EntityItem)iter.next();

			double distance = theRobit.func_70032_d(entity);

			if(distance <= 10)
			{
				if(closestDistance == -1 || distance < closestDistance)
				{
					if(thePathfinder.func_75488_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v) != null)
					{
						closest = entity;
						closestDistance = distance;
					}
				}
			}
		}

		if(closest == null || closest.field_70128_L)
		{
			//No valid items
			return false;
		}

		return true;

	}

	@Override
	public boolean func_75253_b()
	{
		return !closest.field_70128_L && !thePathfinder.func_75500_f() && theRobit.func_70068_e(closest) > 100 && theRobit.getDropPickup() && theRobit.getEnergy() > 0 && closest.field_70170_p.field_73011_w.getDimension() == theRobit.field_70170_p.field_73011_w.getDimension();
	}

	@Override
	public void func_75249_e()
	{
		ticker = 0;
		oldWaterCost = theRobit.func_184643_a(PathNodeType.WATER);
        theRobit.func_184644_a(PathNodeType.WATER, 0.0F);
	}

	@Override
	public void func_75251_c()
	{
		thePathfinder.func_75499_g();
        theRobit.func_184644_a(PathNodeType.WATER, oldWaterCost);
	}

	@Override
	public void func_75246_d()
	{
		if(!theRobit.getDropPickup())
		{
			return;
		}
		
		theRobit.func_70671_ap().func_75651_a(closest, 6.0F, theRobit.func_70646_bf()/10);

		if(--ticker <= 0)
		{
			ticker = 10;

			if(!thePathfinder.func_75497_a(closest, moveSpeed))
			{
				if(theRobit.func_70068_e(closest) >= 144.0D)
				{
					int x = MathHelper.func_76128_c(closest.field_70165_t) - 2;
					int y = MathHelper.func_76128_c(closest.func_174813_aQ().field_72338_b);
					int z = MathHelper.func_76128_c(closest.field_70161_v) - 2;

					for(int l = 0; l <= 4; ++l)
					{
						for(int i1 = 0; i1 <= 4; ++i1)
						{
							BlockPos pos = new BlockPos(x+l, y, z+i1);
							BlockPos under = new BlockPos(x + l, y - 1, z + i1);
							
							if((l < 1 || i1 < 1 || l > 3 || i1 > 3) && world.func_180495_p(under).isSideSolid(world, under, EnumFacing.UP) && isEmptyBlock(pos) && isEmptyBlock(new BlockPos(x + l, y + 1, z + i1)))
							{
								theRobit.func_70012_b((x + l) + 0.5F, y, (z + i1) + 0.5F, theRobit.field_70177_z, theRobit.field_70125_A);
								thePathfinder.func_75499_g();
								
								return;
							}
						}
					}
				}
			}
		}
	}
	
	private boolean isEmptyBlock(BlockPos pos)
    {
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        
        return block == Blocks.field_150350_a ? true : !iblockstate.func_185917_h();
    }
}
