package mekanism.common.entity.ai;

import mekanism.common.entity.EntityRobit;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class RobitAIFollow extends EntityAIBase
{
	/** The robit entity. */
	private EntityRobit theRobit;

	/** The robit's owner. */
	private EntityPlayer theOwner;

	/** The world the robit is located in. */
	private World world;

	/** How fast the robit can travel. */
	private float moveSpeed;

	/** The robit's pathfinder. */
	private PathNavigateGround thePathfinder;

	/** The ticker for updates. */
	private int ticker;

	/** The distance between the owner the robit must be at in order for the protocol to begin. */
	private float maxDist;

	/** The distance between the owner the robit must reach before it stops the protocol. */
	private float minDist;

	private float oldWaterCost;

	public RobitAIFollow(EntityRobit entityRobit, float speed, float min, float max)
	{
		theRobit = entityRobit;
		world = entityRobit.field_70170_p;
		moveSpeed = speed;
		thePathfinder = entityRobit.func_70661_as();
		minDist = min;
		maxDist = max;
	}

	@Override
	public boolean func_75250_a()
	{
		EntityPlayer player = theRobit.getOwner();

		if(player == null)
		{
			return false;
		}
		else if(theRobit.field_70170_p.field_73011_w.getDimension() != player.field_70170_p.field_73011_w.getDimension())
		{
			return false;
		}
		else if(!theRobit.getFollowing())
		{
			//Still looks up at the player if on chargepad or not following

			theRobit.func_70671_ap().func_75651_a(player, 6.0F, theRobit.func_70646_bf()/10);
			return false;
		}
		else if(theRobit.func_70068_e(player) < (minDist * minDist))
		{
			return false;
		}
		else if(theRobit.getEnergy() == 0)
		{
			return false;
		}
		else {
			theOwner = player;
			return true;
		}
	}

	@Override
	public boolean func_75253_b()
	{
		return !thePathfinder.func_75500_f() && theRobit.func_70068_e(theOwner) > (maxDist * maxDist) && theRobit.getFollowing() && theRobit.getEnergy() > 0 && theOwner.field_70170_p.field_73011_w.getDimension() == theRobit.field_70170_p.field_73011_w.getDimension();
	}

	@Override
	public void func_75249_e()
	{
		ticker = 0;
		oldWaterCost = theRobit.func_184643_a(PathNodeType.WATER);
        theRobit.func_184644_a(PathNodeType.WATER, 0.0F);
	}

	@Override
	public void func_75251_c()
	{
		theOwner = null;
		thePathfinder.func_75499_g();
        theRobit.func_184644_a(PathNodeType.WATER, oldWaterCost);
	}

	@Override
	public void func_75246_d()
	{
		theRobit.func_70671_ap().func_75651_a(theOwner, 6.0F, theRobit.func_70646_bf()/10);

		if(theRobit.getFollowing())
		{
			if(--ticker <= 0)
			{
				ticker = 10;

				if(!thePathfinder.func_75497_a(theOwner, moveSpeed))
				{
					if(theRobit.func_70068_e(theOwner) >= 144.0D)
					{
						int x = MathHelper.func_76128_c(theOwner.field_70165_t) - 2;
						int y = MathHelper.func_76128_c(theOwner.func_174813_aQ().field_72338_b);
						int z = MathHelper.func_76128_c(theOwner.field_70161_v) - 2;

						for(int l = 0; l <= 4; ++l)
						{
							for(int i1 = 0; i1 <= 4; ++i1)
							{
								BlockPos pos = new BlockPos(x+l, y, z+i1);
								BlockPos under = new BlockPos(x + l, y - 1, z + i1);
								
								if((l < 1 || i1 < 1 || l > 3 || i1 > 3) && world.func_180495_p(under).isSideSolid(world, under, EnumFacing.UP) && isEmptyBlock(pos) && isEmptyBlock(new BlockPos(x + l, y + 1, z + i1)))
								{
									theRobit.func_70012_b((x + l) + 0.5F, y, (z + i1) + 0.5F, theRobit.field_70177_z, theRobit.field_70125_A);
									thePathfinder.func_75499_g();
									return;
								}
							}
						}
					}
				}
			}
		}
	}
	
	private boolean isEmptyBlock(BlockPos pos)
    {
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        
        return block == Blocks.field_150350_a ? true : !iblockstate.func_185917_h();
    }
}
