package mekanism.common.entity;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.UUID;

import mekanism.api.Coord4D;
import mekanism.api.energy.EnergizedItemManager;
import mekanism.api.energy.IEnergizedItem;
import mekanism.common.Mekanism;
import mekanism.common.MekanismItems;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig.general;
import mekanism.common.entity.ai.RobitAIFollow;
import mekanism.common.entity.ai.RobitAIPickup;
import mekanism.common.integration.MekanismHooks;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.item.ItemRobit;
import mekanism.common.tile.TileEntityChargepad;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.util.Constants;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional.Interface;
import cofh.api.energy.IEnergyContainerItem;

@Interface(iface = "micdoodle8.mods.galacticraft.api.entity.IEntityBreathable", modid = MekanismHooks.GALACTICRAFT_MOD_ID)
public class EntityRobit extends EntityCreature implements IInventory, ISustainedInventory, IEntityBreathable
{
	public double MAX_ELECTRICITY = 100000;

	public Coord4D homeLocation;

	public NonNullList<ItemStack> inventory = NonNullList.func_191197_a(31, ItemStack.field_190927_a);

	public int furnaceBurnTime = 0;
	public int currentItemBurnTime = 0;
	public int furnaceCookTime = 0;

	public boolean texTick;
	
    private static final DataParameter<Float> ELECTRICITY = EntityDataManager.<Float>func_187226_a(EntityRobit.class, DataSerializers.field_187193_c);
    private static final DataParameter<String> OWNER_UUID = EntityDataManager.<String>func_187226_a(EntityRobit.class, DataSerializers.field_187194_d);
    private static final DataParameter<String> OWNER_NAME = EntityDataManager.<String>func_187226_a(EntityRobit.class, DataSerializers.field_187194_d);
    private static final DataParameter<Boolean> FOLLOW = EntityDataManager.<Boolean>func_187226_a(EntityRobit.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DROP_PICKUP = EntityDataManager.<Boolean>func_187226_a(EntityRobit.class, DataSerializers.field_187198_h);

	public EntityRobit(World world)
	{
		super(world);

		func_70105_a(0.5F, 0.5F);
		
		func_70661_as().func_179693_d(false);

		field_70714_bg.func_75776_a(1, new RobitAIPickup(this, 1.0F));
		field_70714_bg.func_75776_a(2, new RobitAIFollow(this, 1.0F, 4.0F, 2.0F));
		field_70714_bg.func_75776_a(3, new EntityAIWatchClosest(this, EntityPlayer.class, 8.0F));
		field_70714_bg.func_75776_a(3, new EntityAILookIdle(this));
		field_70714_bg.func_75776_a(4, new EntityAISwimming(this));

		func_174805_g(true);
	}

	public EntityRobit(World world, double x, double y, double z)
	{
		this(world);

		func_70107_b(x, y, z);

		field_70169_q = x;
		field_70167_r = y;
		field_70166_s = z;
	}

	@Override
	public PathNavigateGround func_70661_as()
	{
		return (PathNavigateGround)field_70699_by;
	}

	@Override
	protected void func_110147_ax()
	{
		super.func_110147_ax();

		func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
		func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1);
	}

	@Override
	protected boolean func_70692_ba()
	{
		return false;
	}

	@Override
	protected void func_70088_a()
	{
		super.func_70088_a();

		field_70180_af.func_187214_a(ELECTRICITY, 0F);
		field_70180_af.func_187214_a(OWNER_UUID, "");
		field_70180_af.func_187214_a(OWNER_NAME, "");
		field_70180_af.func_187214_a(FOLLOW, false);
		field_70180_af.func_187214_a(DROP_PICKUP, false);
	}

	public double getRoundedTravelEnergy()
	{
		return new BigDecimal(func_70011_f(field_70169_q, field_70167_r, field_70166_s)*1.5).setScale(2, RoundingMode.HALF_EVEN).doubleValue();
	}

	@Override
	public void func_70030_z()
	{
		if(!field_70170_p.field_72995_K)
		{
			if(getFollowing() && getOwner() != null && func_70068_e(getOwner()) > 4 && !func_70661_as().func_75500_f() && getEnergy() > 0)
			{
				setEnergy(getEnergy() - getRoundedTravelEnergy());
			}
		}

		super.func_70030_z();

		if(!field_70170_p.field_72995_K)
		{
			if(getDropPickup())
			{
				collectItems();
			}

			if(homeLocation == null)
			{
				func_70106_y();

				return;
			}

			if(field_70173_aa % 20 == 0)
			{
				World serverWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(homeLocation.dimensionId);
				
				if(homeLocation.exists(serverWorld))
				{
					if(!(homeLocation.getTileEntity(serverWorld) instanceof TileEntityChargepad))
					{
						drop();
						func_70106_y();
					}
				}
			}

			if(getEnergy() == 0 && !isOnChargepad())
			{
				goHome();
			}
			
			ItemStack stack = inventory.get(27);

			if(!stack.func_190926_b() && getEnergy() < MAX_ELECTRICITY)
			{
				if(stack.func_77973_b() instanceof IEnergizedItem)
				{
					setEnergy(getEnergy() + EnergizedItemManager.discharge(stack, MAX_ELECTRICITY - getEnergy()));
				}
				else if(MekanismUtils.useTesla() && stack.hasCapability(Capabilities.TESLA_PRODUCER_CAPABILITY, null))
				{
					ITeslaProducer producer = stack.getCapability(Capabilities.TESLA_PRODUCER_CAPABILITY, null);
					
					long needed = (long)Math.round((MAX_ELECTRICITY-getEnergy())*general.TO_TESLA);
					setEnergy(getEnergy() + producer.takePower(needed, false)*general.FROM_TESLA);
				}
				else if(MekanismUtils.useForge() && stack.hasCapability(CapabilityEnergy.ENERGY, null))
				{
					IEnergyStorage storage = stack.getCapability(CapabilityEnergy.ENERGY, null);
					
					if(storage.canExtract())
					{
						int needed = (int)Math.round(Math.min(Integer.MAX_VALUE, (MAX_ELECTRICITY-getEnergy())*general.TO_FORGE));
						setEnergy(getEnergy() + storage.extractEnergy(needed, false)*general.FROM_FORGE);
					}
				}
				else if(MekanismUtils.useRF() && stack.func_77973_b() instanceof IEnergyContainerItem)
				{
					IEnergyContainerItem item = (IEnergyContainerItem)stack.func_77973_b();

					int needed = (int)Math.round(Math.min(Integer.MAX_VALUE, (MAX_ELECTRICITY - getEnergy())*general.TO_RF));
					setEnergy(getEnergy() + (item.extractEnergy(stack, needed, false)*general.FROM_RF));
				}
				else if(MekanismUtils.useIC2() && stack.func_77973_b() instanceof IElectricItem)
				{
					IElectricItem item = (IElectricItem)stack.func_77973_b();

					if(item.canProvideEnergy(stack))
					{
						double gain = ElectricItem.manager.discharge(stack, (MAX_ELECTRICITY - getEnergy())*general.TO_IC2, 4, true, true, false)*general.FROM_IC2;
						setEnergy(getEnergy() + gain);
					}
				}
				else if(stack.func_77973_b() == Items.field_151137_ax && getEnergy()+general.ENERGY_PER_REDSTONE <= MAX_ELECTRICITY)
				{
					setEnergy(getEnergy() + general.ENERGY_PER_REDSTONE);
					stack.func_190918_g(1);
				}
			}

			if(furnaceBurnTime > 0)
			{
				furnaceBurnTime--;
			}

			if(!field_70170_p.field_72995_K)
			{
				if(furnaceBurnTime == 0 && canSmelt())
				{
					currentItemBurnTime = furnaceBurnTime = TileEntityFurnace.func_145952_a(inventory.get(29));

					if(furnaceBurnTime > 0)
					{
						if(!inventory.get(29).func_190926_b())
						{
							inventory.get(29).func_190918_g(1);

							if(inventory.get(29).func_190916_E() == 0)
							{
								inventory.set(29, inventory.get(29).func_77973_b().getContainerItem(inventory.get(29)));
							}
						}
					}
				}

				if(furnaceBurnTime > 0 && canSmelt())
				{
					furnaceCookTime++;

					if(furnaceCookTime == 200)
					{
						furnaceCookTime = 0;
						smeltItem();
					}
				}
				else {
					furnaceCookTime = 0;
				}
			}
		}
	}

	private void collectItems()
	{
		List<EntityItem> items = field_70170_p.func_72872_a(EntityItem.class, func_174813_aQ().func_72314_b(1.5, 1.5, 1.5));

		if(items != null && !items.isEmpty())
		{
			for(EntityItem item : items)
			{
				if(item.func_174874_s() || item.func_92059_d().func_77973_b() instanceof ItemRobit)
				{
					continue;
				}

				for(int i = 0; i < 27; i++)
				{
					ItemStack itemStack = inventory.get(i);

					if(itemStack.func_190926_b())
					{
						inventory.set(i, item.func_92059_d());
						func_71001_a(item, item.func_92059_d().func_190916_E());
						item.func_70106_y();

						func_184185_a(SoundEvents.field_187638_cR, 1.0F, ((field_70146_Z.nextFloat() - field_70146_Z.nextFloat()) * 0.7F + 1.0F) * 2.0F);

						break;
					}
					else if(itemStack.func_77969_a(item.func_92059_d()) && itemStack.func_190916_E() < itemStack.func_77976_d())
					{
						int needed = itemStack.func_77976_d() - itemStack.func_190916_E();
						int toAdd = Math.min(needed, item.func_92059_d().func_190916_E());

						itemStack.func_190917_f(toAdd);
						item.func_92059_d().func_190918_g(toAdd);

						func_71001_a(item, toAdd);

						if(item.func_92059_d().func_190916_E() == 0)
						{
							item.func_70106_y();
						}

						func_184185_a(SoundEvents.field_187638_cR, 1.0F, ((field_70146_Z.nextFloat() - field_70146_Z.nextFloat()) * 0.7F + 1.0F) * 2.0F);

						break;
					}
				}
			}
		}
	}

	public void goHome()
	{
		setFollowing(false);

		if(field_70170_p.field_73011_w.getDimension() != homeLocation.dimensionId)
		{
			func_184204_a(homeLocation.dimensionId);
		}

		func_70634_a(homeLocation.xCoord+0.5, homeLocation.yCoord+0.3, homeLocation.zCoord+0.5);

		field_70159_w = 0;
		field_70181_x = 0;
		field_70179_y = 0;
	}

	private boolean canSmelt()
	{
		if(inventory.get(28).func_190926_b())
		{
			return false;
		}
		else {
			ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(inventory.get(28));
			if(itemstack.func_190926_b()) return false;
			if(inventory.get(30).func_190926_b()) return true;
			if(!inventory.get(30).func_77969_a(itemstack)) return false;
			int result = inventory.get(30).func_190916_E() + itemstack.func_190916_E();
			return (result <= func_70297_j_() && result <= itemstack.func_77976_d());
		}
	}

	public void smeltItem()
	{
		if(canSmelt())
		{
			ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(inventory.get(28));

			if(inventory.get(30).func_190926_b())
			{
				inventory.set(30, itemstack.func_77946_l());
			}
			else if(inventory.get(30).func_77969_a(itemstack))
			{
				inventory.get(30).func_190917_f(itemstack.func_190916_E());
			}

			inventory.get(28).func_190918_g(1);
		}
	}

	public boolean isOnChargepad()
	{
		BlockPos pos = new BlockPos(this);

		if(field_70170_p.func_175625_s(pos) instanceof TileEntityChargepad)
		{
			return true;
		}

		return false;
	}

	@Override
	public EnumActionResult func_184199_a(EntityPlayer entityplayer, Vec3d vec, EnumHand hand)
	{
		ItemStack stack = entityplayer.func_184586_b(hand);
		
		if(entityplayer.func_70093_af())
		{
			if(!stack.func_190926_b() && stack.func_77973_b() instanceof ItemConfigurator)
			{
				if(!field_70170_p.field_72995_K)
				{
					drop();
				}

				func_70106_y();

				entityplayer.func_184609_a(hand);
				return EnumActionResult.SUCCESS;
			}
		}
		else {
			entityplayer.openGui(Mekanism.instance, 21, field_70170_p, func_145782_y(), 0, 0);
			return EnumActionResult.SUCCESS;
		}

		return EnumActionResult.PASS;
	}

	public void drop()
	{
		EntityItem entityItem = new EntityItem(field_70170_p, field_70165_t, field_70163_u+0.3, field_70161_v, new ItemStack(MekanismItems.Robit));

		ItemRobit item = (ItemRobit)entityItem.func_92059_d().func_77973_b();
		item.setEnergy(entityItem.func_92059_d(), getEnergy());
		item.setInventory(((ISustainedInventory)this).getInventory(), entityItem.func_92059_d());
		item.setName(entityItem.func_92059_d(), func_70005_c_());

		float k = 0.05F;
		entityItem.field_70159_w = 0;
		entityItem.field_70181_x = field_70146_Z.nextGaussian() * k + 0.2F;
		entityItem.field_70179_y = 0;

		field_70170_p.func_72838_d(entityItem);
	}

	@Override
	public void func_70014_b(NBTTagCompound nbtTags)
	{
		super.func_70014_b(nbtTags);

		nbtTags.func_74780_a("electricityStored", getEnergy());

		nbtTags.func_74778_a("name", func_70005_c_());

		if(getOwnerUUID() != null)
		{
			nbtTags.func_74778_a("ownerUUID", getOwnerUUID().toString());
		}

		nbtTags.func_74757_a("follow", getFollowing());

		nbtTags.func_74757_a("dropPickup", getDropPickup());

		if(homeLocation != null)
		{
			homeLocation.write(nbtTags);
		}

		NBTTagList tagList = new NBTTagList();

		for(int slotCount = 0; slotCount < inventory.size(); slotCount++)
		{
			if(!inventory.get(slotCount).func_190926_b())
			{
				NBTTagCompound tagCompound = new NBTTagCompound();
				tagCompound.func_74774_a("Slot", (byte)slotCount);
				inventory.get(slotCount).func_77955_b(tagCompound);
				tagList.func_74742_a(tagCompound);
			}
		}

		nbtTags.func_74782_a("Items", tagList);
	}

	@Override
	public void func_70037_a(NBTTagCompound nbtTags)
	{
		super.func_70037_a(nbtTags);

		setEnergy(nbtTags.func_74769_h("electricityStored"));

		func_96094_a(nbtTags.func_74779_i("name"));

		if(nbtTags.func_74764_b("ownerUUID"))
		{
			setOwnerUUID(UUID.fromString(nbtTags.func_74779_i("ownerUUID")));
		}

		setFollowing(nbtTags.func_74767_n("follow"));

		setDropPickup(nbtTags.func_74767_n("dropPickup"));

		homeLocation = Coord4D.read(nbtTags);

		NBTTagList tagList = nbtTags.func_150295_c("Items", Constants.NBT.TAG_COMPOUND);
		inventory = NonNullList.func_191197_a(func_70302_i_(), ItemStack.field_190927_a);

		for(int tagCount = 0; tagCount < tagList.func_74745_c(); tagCount++)
		{
			NBTTagCompound tagCompound = tagList.func_150305_b(tagCount);
			byte slotID = tagCompound.func_74771_c("Slot");

			if(slotID >= 0 && slotID < inventory.size())
			{
				inventory.set(slotID, InventoryUtils.loadFromNBT(tagCompound));
			}
		}
	}

	@Override
	protected void func_70665_d(DamageSource damageSource, float amount)
	{
		amount = ForgeHooks.onLivingHurt(this, damageSource, amount);

		if(amount <= 0)
		{
			return;
		}

		amount = func_70655_b(damageSource, amount);
		amount = func_70672_c(damageSource, amount);
		float j = func_110143_aJ();

		setEnergy(Math.max(0, getEnergy() - (amount*1000)));
		func_110142_aN().func_94547_a(damageSource, j, amount);
	}

	@Override
	protected void func_70609_aI() {}

	public void setHome(Coord4D home)
	{
		homeLocation = home;
	}

	@Override
	public boolean func_70104_M()
	{
		return getEnergy() > 0;
	}

	public double getEnergy()
	{
		return (float)field_70180_af.func_187225_a(ELECTRICITY);
	}

	public void setEnergy(double energy)
	{
		field_70180_af.func_187227_b(ELECTRICITY, (float)Math.max(Math.min(energy, MAX_ELECTRICITY), 0));
	}

	public EntityPlayer getOwner()
	{
		return field_70170_p.func_152378_a(getOwnerUUID());
	}

	public String getOwnerName()
	{
		return field_70180_af.func_187225_a(OWNER_NAME);
	}

	public UUID getOwnerUUID()
	{
		return UUID.fromString(field_70180_af.func_187225_a(OWNER_UUID));
	}

	public void setOwnerUUID(UUID uuid)
	{
		field_70180_af.func_187227_b(OWNER_UUID, uuid.toString());
		field_70180_af.func_187227_b(OWNER_NAME, MekanismUtils.getLastKnownUsername(uuid));
	}

	public boolean getFollowing()
	{
		return field_70180_af.func_187225_a(FOLLOW);
	}

	public void setFollowing(boolean follow)
	{
		field_70180_af.func_187227_b(FOLLOW, follow);
	}

	public boolean getDropPickup()
	{
		return field_70180_af.func_187225_a(DROP_PICKUP);
	}

	public void setDropPickup(boolean pickup)
	{
		field_70180_af.func_187227_b(DROP_PICKUP, pickup);
	}

	@Override
	public int func_70302_i_()
	{
		return inventory.size();
	}

	@Override
	public ItemStack func_70301_a(int slotID)
	{
		return inventory.get(slotID);
	}

	@Override
	public ItemStack func_70298_a(int slotID, int amount)
	{
		return ItemStackHelper.func_188382_a(inventory, slotID, amount);
	}

	@Override
	public ItemStack func_70304_b(int slotID)
	{
		return ItemStackHelper.func_188383_a(inventory, slotID);
	}

	@Override
	public void func_70299_a(int slotID, ItemStack itemstack)
	{
		inventory.set(slotID, itemstack);

		if(!itemstack.func_190926_b() && itemstack.func_190916_E() > func_70297_j_())
		{
			itemstack.func_190920_e(func_70297_j_());
		}
	}

	@Override
	public int func_70297_j_()
	{
		return 64;
	}

	@Override
	public void func_70296_d() {}

	@Override
	public boolean func_70300_a(EntityPlayer entityplayer)
	{
		return true;
	}

	@Override
	public void func_174889_b(EntityPlayer player) {}

	@Override
	public void func_174886_c(EntityPlayer player) {}

	@Override
	public boolean func_94041_b(int i, ItemStack itemstack)
	{
		return true;
	}

	@Override
	public int func_174887_a_(int id)
	{
		return 0;
	}

	@Override
	public void func_174885_b(int id, int value) {}

	@Override
	public int func_174890_g()
	{
		return 0;
	}

	@Override
	public void func_174888_l() {}

	@Override
	public void setInventory(NBTTagList nbtTags, Object... data)
	{
		if(nbtTags == null || nbtTags.func_74745_c() == 0)
		{
			return;
		}

		inventory = NonNullList.func_191197_a(func_70302_i_(), ItemStack.field_190927_a);

		for(int slots = 0; slots < nbtTags.func_74745_c(); slots++)
		{
			NBTTagCompound tagCompound = (NBTTagCompound)nbtTags.func_150305_b(slots);
			byte slotID = tagCompound.func_74771_c("Slot");

			if(slotID >= 0 && slotID < inventory.size())
			{
				inventory.set(slotID, InventoryUtils.loadFromNBT(tagCompound));
			}
		}
	}

	@Override
	public NBTTagList getInventory(Object... data)
	{
		NBTTagList tagList = new NBTTagList();

		for(int slots = 0; slots < inventory.size(); slots++)
		{
			if(!inventory.get(slots).func_190926_b())
			{
				NBTTagCompound tagCompound = new NBTTagCompound();
				tagCompound.func_74774_a("Slot", (byte)slots);
				inventory.get(slots).func_77955_b(tagCompound);
				tagList.func_74742_a(tagCompound);
			}
		}

		return tagList;
	}
	
	@Override
	public boolean func_191420_l()
	{
		for(ItemStack stack : inventory)
		{
			if(!stack.func_190926_b())
			{
				return false;
			}
		}
		
		return true;
	}

	@Override
	public boolean canBreath()
	{
		return true;
	}
}
