package mekanism.common.entity;

import mekanism.common.config.MekanismConfig.general;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public class EntityObsidianTNT extends Entity
{
	/** How long the fuse is */
	public int fuse;

	/** Whether or not the TNT has exploded */
	private boolean hasExploded = false;

	public EntityObsidianTNT(World world)
	{
		super(world);
		fuse = 0;
		field_70156_m = true;
		func_70105_a(0.98F, 0.98F);
	}

	public EntityObsidianTNT(World world, double x, double y, double z)
	{
		this(world);

		func_70107_b(x, y, z);

		float randPi = (float)(Math.random()*Math.PI*2);

		field_70159_w = -(Math.sin(randPi))*0.02F;
		field_70181_x = 0.2;
		field_70179_y = -(Math.cos(randPi))*0.02F;

		fuse = general.obsidianTNTDelay;

		field_70169_q = x;
		field_70167_r = y;
		field_70166_s = z;
	}

	@Override
	protected void func_70088_a() {}

	@Override
	protected boolean func_70041_e_()
	{
		return false;
	}

	@Override
	public boolean func_70067_L()
	{
		return !field_70128_L;
	}

	@Override
	public boolean func_70104_M()
	{
		return true;
	}

	@Override
	public void func_70071_h_()
	{
		field_70169_q = field_70165_t;
		field_70167_r = field_70163_u;
		field_70166_s = field_70161_v;

		field_70181_x -= 0.04;

		func_70091_d(MoverType.SELF, field_70159_w, field_70181_x, field_70179_y);

		field_70159_w *= 0.98;
		field_70181_x *= 0.98;
		field_70179_y *= 0.98;

		if(field_70122_E)
		{
			field_70159_w *= 0.7;
			field_70179_y *= 0.7;
			field_70181_x *= -0.5;
		}

		if(fuse-- <= 0)
		{
			if(!field_70170_p.field_72995_K)
			{
				func_70106_y();
				explode();
			}
			else {
				if(hasExploded)
				{
					func_70106_y();
				}
				else {
					field_70170_p.func_175688_a(EnumParticleTypes.LAVA, field_70165_t, field_70163_u + 0.5, field_70161_v, 0, 0, 0);
				}
			}
		}
		else {
			field_70170_p.func_175688_a(EnumParticleTypes.LAVA, field_70165_t, field_70163_u + 0.5, field_70161_v, 0, 0, 0);
		}
	}

	private void explode()
	{
		field_70170_p.func_72876_a(null, field_70165_t, field_70163_u, field_70161_v, general.obsidianTNTBlastRadius, true);
		hasExploded = true;
	}

	@Override
	protected void func_70014_b(NBTTagCompound nbtTags)
	{
		nbtTags.func_74774_a("Fuse", (byte)fuse);
	}

	@Override
	protected void func_70037_a(NBTTagCompound nbtTags)
	{
		fuse = nbtTags.func_74771_c("Fuse");
	}
}
