package mekanism.common.entity;

import io.netty.buffer.ByteBuf;

import java.util.List;

import mekanism.api.Coord4D;
import mekanism.api.Pos3D;
import mekanism.common.config.MekanismConfig.general;
import mekanism.common.item.ItemFlamethrower;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.RayTraceResult.Type;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityFlame extends Entity implements IEntityAdditionalSpawnData
{
	public static final int LIFESPAN = 80;
	public static final int DAMAGE = 10;
	
	public Entity owner = null;
    public ItemFlamethrower.FlamethrowerMode mode = ItemFlamethrower.FlamethrowerMode.COMBAT;
	
	public EntityFlame(World world)
	{
		super(world);
		
		func_70105_a(0.5F, 0.5F);
	}
	
	public EntityFlame(EntityPlayer player)
	{
		this(player.field_70170_p);
		
		Pos3D playerPos = new Pos3D(player).translate(0, 1.6, 0);
		Pos3D flameVec = new Pos3D(1, 1, 1);
		
		flameVec = flameVec.multiply(new Pos3D(player.func_70040_Z())).func_178785_b(6);
		
		Pos3D mergedVec = playerPos.translate(flameVec);
		func_70107_b(mergedVec.field_72450_a, mergedVec.field_72448_b, mergedVec.field_72449_c);
		
		Pos3D motion = new Pos3D(0.4, 0.4, 0.4).multiply(new Pos3D(player.func_70040_Z()));
		
		setHeading(motion);
		
		field_70159_w = motion.field_72450_a;
		field_70181_x = motion.field_72448_b;
		field_70179_y = motion.field_72449_c;
		
		owner = player;
        mode = ((ItemFlamethrower)player.field_71071_by.func_70448_g().func_77973_b()).getMode(player.field_71071_by.func_70448_g());
	}
	
    public void setHeading(Pos3D motion)
    {
        float d = MathHelper.func_76133_a((motion.field_72450_a * motion.field_72450_a) + (motion.field_72449_c * motion.field_72449_c));
        
        field_70126_B = field_70177_z = (float)(Math.atan2(motion.field_72450_a, motion.field_72449_c) * 180.0D / Math.PI);
        field_70127_C = field_70125_A = (float)(Math.atan2(motion.field_72448_b, d) * 180.0D / Math.PI);
    }
	
	@Override
	public void func_70071_h_()
	{
		if(field_70128_L)
		{
			return;
		}
		
		field_70173_aa++;
		
        field_70169_q = field_70165_t;
        field_70167_r = field_70163_u;
        field_70166_s = field_70161_v;
        
        field_70127_C = field_70125_A;
        field_70126_B = field_70177_z;
        
        field_70165_t += field_70159_w;
        field_70163_u += field_70181_x;
        field_70161_v += field_70179_y;
        
        func_70107_b(field_70165_t, field_70163_u, field_70161_v);
        
    	calculateVector();
        
		if(field_70173_aa > LIFESPAN)
		{
			func_70106_y();
			return;
		}
	}
	
	private void calculateVector()
	{
		Vec3d localVec = new Vec3d(field_70165_t, field_70163_u, field_70161_v);
        Vec3d motionVec = new Vec3d(field_70165_t + field_70159_w*2, field_70163_u + field_70181_x*2, field_70161_v + field_70179_y*2);
        RayTraceResult mop = field_70170_p.func_147447_a(localVec, motionVec, true, false, false);
        localVec = new Vec3d(field_70165_t, field_70163_u, field_70161_v);
        motionVec = new Vec3d(field_70165_t + field_70159_w, field_70163_u + field_70181_x, field_70161_v + field_70179_y);

        if(mop != null)
        {
            motionVec = new Vec3d(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c);
        }

        Entity entity = null;
        List<Entity> list = field_70170_p.func_72839_b(this, func_174813_aQ().func_72321_a(field_70159_w, field_70181_x, field_70179_y).func_72314_b(1.0D, 1.0D, 1.0D));
        double entityDist = 0.0D;
        int i;

        for(Entity entity1 : list)
        {
            if((entity1 instanceof EntityItem || entity1.func_70067_L()) && entity1 != owner)
            {
                float boundsScale = 0.3F;
                AxisAlignedBB newBounds = entity1.func_174813_aQ().func_72314_b((double)boundsScale, (double)boundsScale, (double)boundsScale);
                RayTraceResult RayTraceResult1 = newBounds.func_72327_a(localVec, motionVec);

                if(RayTraceResult1 != null)
                {
                    double dist = localVec.func_72438_d(RayTraceResult1.field_72307_f);

                    if(dist < entityDist || entityDist == 0)
                    {
                        entity = entity1;
                        entityDist = dist;
                    }
                }
            }
        }

        if(entity != null)
        {
            mop = new RayTraceResult(entity);
        }

        if(mop != null && mop.field_72308_g instanceof EntityPlayer)
        {
            EntityPlayer entityplayer = (EntityPlayer)mop.field_72308_g;

            if(entityplayer.field_71075_bZ.field_75102_a || owner instanceof EntityPlayer && !((EntityPlayer)owner).func_96122_a(entityplayer))
            {
                mop = null;
            }
        }

        if(mop != null)
        {
            if(mop.field_72313_a == Type.ENTITY && mop.field_72308_g != null && !mop.field_72308_g.func_70045_F())
            {
            	if(mop.field_72308_g instanceof EntityItem && mode != ItemFlamethrower.FlamethrowerMode.COMBAT)
            	{
            		if(mop.field_72308_g.field_70173_aa > 100)
            		{
            			if(!smeltItem((EntityItem)mop.field_72308_g))
            			{
            				burn(mop.field_72308_g);
            			}
            		}
            	}
            	else {
            		burn(mop.field_72308_g);
            	}
            }
            else if(mop.field_72313_a == Type.BLOCK)
            {
                IBlockState state = field_70170_p.func_180495_p(mop.func_178782_a());
				Block block = state.func_177230_c();
                boolean fluid = MekanismUtils.isFluid(field_70170_p, new Coord4D(mop, field_70170_p)) || MekanismUtils.isDeadFluid(field_70170_p, new Coord4D(mop, field_70170_p));
                
                Coord4D sideCoord = new Coord4D(mop.func_178782_a().func_177972_a(mop.field_178784_b), field_70170_p);
                
                if(general.aestheticWorldDamage && !fluid && (sideCoord.isAirBlock(field_70170_p) || sideCoord.isReplaceable(field_70170_p)))
                {
                	if(mode != ItemFlamethrower.FlamethrowerMode.COMBAT && !smeltBlock(new Coord4D(mop, field_70170_p)))
                	{
                		if(mode == ItemFlamethrower.FlamethrowerMode.INFERNO && !field_70170_p.field_72995_K)
                		{
                			field_70170_p.func_175656_a(sideCoord.getPos(), Blocks.field_150480_ab.func_176223_P());
                		}
                	}
                }
                
                if(fluid)
                {
                	spawnParticlesAt(new Pos3D(this));
                	func_184185_a(SoundEvents.field_187646_bt, 1.0F, 1.0F);
                }
            }
            
            func_70106_y();
        }
	}
	
	private boolean smeltItem(EntityItem item)
	{
		ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(item.func_92059_d());
		
		if(!result.func_190926_b())
		{
			item.func_92058_a(StackUtils.size(result, item.func_92059_d().func_190916_E()));
			item.field_70173_aa = 0;
			
			spawnParticlesAt(new Pos3D(item));
			func_184185_a(SoundEvents.field_187646_bt, 1.0F, 1.0F);
			
			return true;
		}
		
		return false;
	}
	
	private boolean smeltBlock(Coord4D block)
	{
		ItemStack stack = block.getStack(field_70170_p);
		
		if(stack.func_190926_b())
		{
			return false;
		}
		
		ItemStack result = ItemStack.field_190927_a;
		
		try {
			result = FurnaceRecipes.func_77602_a().func_151395_a(block.getStack(field_70170_p));
		} catch(Exception e) {
			return false;
		}
		
		if(!result.func_190926_b() && result.func_77973_b() != null)
		{
			if(!field_70170_p.field_72995_K)
			{
				IBlockState state = block.getBlockState(field_70170_p);
				Block b = state.func_177230_c();
				Block newBlock = Block.func_149634_a(result.func_77973_b());

				if(newBlock != null && newBlock != Blocks.field_150350_a)
				{
					field_70170_p.func_180501_a(block.getPos(), Block.func_149634_a(result.func_77973_b()).func_176203_a(result.func_77952_i()), 3);
				}
				else {
					field_70170_p.func_175698_g(block.getPos());
					
					EntityItem item = new EntityItem(field_70170_p, block.xCoord + 0.5, block.yCoord + 0.5, block.zCoord + 0.5, result.func_77946_l());
					item.field_70159_w = 0;
					item.field_70181_x = 0;
					item.field_70179_y = 0;
					field_70170_p.func_72838_d(item);
				}
				
				field_70170_p.func_180498_a(null, 2001, block.getPos(), Block.func_176210_f(state));
			}
			
			spawnParticlesAt(new Pos3D(block).translate(0.5, 0.5, 0.5));
			
			return true;
		}
		
		return false;
	}
	
	private void burn(Entity entity)
	{
    	entity.func_70015_d(20);
        entity.func_70097_a(getFlamethrowerDamage(), DAMAGE);
	}
	
	private DamageSource getFlamethrowerDamage()
	{
		if(owner == null)
		{
			return DamageSource.func_76356_a(this, this);
		}
		else {
			return DamageSource.func_76356_a(this, owner);
		}
	}
	
	private void spawnParticlesAt(Pos3D pos)
	{
		for(int i = 0; i < 10; i++)
		{
			field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, pos.field_72450_a + (field_70146_Z.nextFloat()-0.5), pos.field_72448_b + (field_70146_Z.nextFloat()-0.5), pos.field_72449_c + (field_70146_Z.nextFloat()-0.5), 0, 0, 0);
		}
	}

	@Override
	protected void func_70088_a() {}

	@Override
	protected void func_70037_a(NBTTagCompound nbtTags)
    {
        mode = ItemFlamethrower.FlamethrowerMode.values()[nbtTags.func_74762_e("mode")];
    }

	@Override
	protected void func_70014_b(NBTTagCompound nbtTags)
    {
        nbtTags.func_74768_a("mode", mode.ordinal());
    }

	@Override
	public void writeSpawnData(ByteBuf dataStream)
    {
        dataStream.writeInt(mode.ordinal());
    }

	@Override
	public void readSpawnData(ByteBuf dataStream)
    {
        mode = ItemFlamethrower.FlamethrowerMode.values()[dataStream.readInt()];
    }
}
