package mekanism.common.entity;

import io.netty.buffer.ByteBuf;

import java.util.UUID;

import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Pos3D;
import mekanism.common.MekanismSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRedstone;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBalloon extends Entity implements IEntityAdditionalSpawnData
{
	public EnumColor color = EnumColor.DARK_BLUE;

	public Coord4D latched;
	public EntityLivingBase latchedEntity;

	/* server-only */
	public boolean hasCachedEntity;

	public UUID cachedEntityUUID;
	
    private static final DataParameter<Byte> IS_LATCHED = EntityDataManager.<Byte>func_187226_a(EntityBalloon.class, DataSerializers.field_187191_a);
    private static final DataParameter<Integer> LATCHED_X = EntityDataManager.<Integer>func_187226_a(EntityBalloon.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LATCHED_Y = EntityDataManager.<Integer>func_187226_a(EntityBalloon.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LATCHED_Z = EntityDataManager.<Integer>func_187226_a(EntityBalloon.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LATCHED_ID = EntityDataManager.<Integer>func_187226_a(EntityBalloon.class, DataSerializers.field_187192_b);

	public EntityBalloon(World world)
	{
		super(world);

		field_70158_ak = true;
		field_70156_m = true;
		func_70107_b(field_70165_t + 0.5F, field_70163_u + 3F, field_70161_v + 0.5F);
		func_70105_a(0.25F, 0.25F);
		field_70181_x = 0.04;

		field_70180_af.func_187214_a(IS_LATCHED, (byte)0);
		field_70180_af.func_187214_a(LATCHED_X, 0);
		field_70180_af.func_187214_a(LATCHED_Y, 0);
		field_70180_af.func_187214_a(LATCHED_Z, 0);
		field_70180_af.func_187214_a(LATCHED_ID, -1);
	}

	public EntityBalloon(World world, double x, double y, double z, EnumColor c)
	{
		this(world);

		func_70107_b(x + 0.5F, y + 3F, z + 0.5F);

		field_70169_q = field_70165_t;
		field_70167_r = field_70163_u;
		field_70166_s = field_70161_v;

		color = c;
	}

	public EntityBalloon(EntityLivingBase entity, EnumColor c)
	{
		this(entity.field_70170_p);

		latchedEntity = entity;
		func_70107_b(latchedEntity.field_70165_t, latchedEntity.field_70163_u + latchedEntity.field_70131_O + 1.7F, latchedEntity.field_70161_v);

		field_70169_q = field_70165_t;
		field_70167_r = field_70163_u;
		field_70166_s = field_70161_v;

		color = c;

		field_70180_af.func_187227_b(IS_LATCHED, (byte)2);
		field_70180_af.func_187227_b(LATCHED_ID, entity.func_145782_y());
	}

	public EntityBalloon(World world, Coord4D obj, EnumColor c)
	{
		this(world);

		latched = obj;
		func_70107_b(latched.xCoord + 0.5F, latched.yCoord + 1.9F, latched.zCoord + 0.5F);

		field_70169_q = field_70165_t;
		field_70167_r = field_70163_u;
		field_70166_s = field_70161_v;

		color = c;

		field_70180_af.func_187227_b(IS_LATCHED, (byte)1);
		field_70180_af.func_187227_b(LATCHED_X, latched != null ? latched.xCoord : 0); /* Latched X */
		field_70180_af.func_187227_b(LATCHED_Y, latched != null ? latched.yCoord : 0); /* Latched Y */
		field_70180_af.func_187227_b(LATCHED_Z, latched != null ? latched.zCoord : 0); /* Latched Z */
	}

	@Override
	public void func_70071_h_()
	{
		field_70169_q = field_70165_t;
		field_70167_r = field_70163_u;
		field_70166_s = field_70161_v;

		if(field_70163_u > 255)
		{
			pop();
			return;
		}

		if(field_70170_p.field_72995_K)
		{
			if(field_70180_af.func_187225_a(IS_LATCHED) == 1)
			{
				latched = new Coord4D((int)field_70180_af.func_187225_a(LATCHED_X), (int)field_70180_af.func_187225_a(LATCHED_Y), (int)field_70180_af.func_187225_a(LATCHED_Z), field_70170_p.field_73011_w.getDimension());
			}
			else {
				latched = null;
			}

			if(field_70180_af.func_187225_a(IS_LATCHED) == 2)
			{
				latchedEntity = (EntityLivingBase)field_70170_p.func_73045_a(field_70180_af.func_187225_a(LATCHED_ID));
			}
			else {
				latchedEntity = null;
			}
		}
		else {
			if(hasCachedEntity)
			{
				findCachedEntity();
				cachedEntityUUID = null;
				hasCachedEntity = false;
			}

			if(field_70173_aa == 1)
			{
				field_70180_af.func_187227_b(IS_LATCHED, new Byte(latched != null ? (byte)1 : (latchedEntity != null ? (byte)2 : (byte)0)));
				field_70180_af.func_187227_b(LATCHED_X, new Integer(latched != null ? latched.xCoord : 0));
				field_70180_af.func_187227_b(LATCHED_Y, new Integer(latched != null ? latched.yCoord : 0));
				field_70180_af.func_187227_b(LATCHED_Z, new Integer(latched != null ? latched.zCoord : 0));
				field_70180_af.func_187227_b(LATCHED_ID, new Integer(latchedEntity != null ? latchedEntity.func_145782_y() : -1));
			}
		}

		if(!field_70170_p.field_72995_K)
		{
			if(latched != null && (latched.exists(field_70170_p) && latched.isAirBlock(field_70170_p)))
			{
				latched = null;

				field_70180_af.func_187227_b(IS_LATCHED, (byte)0);
			}

			if(latchedEntity != null && (latchedEntity.func_110143_aJ() <= 0 || latchedEntity.field_70128_L || !field_70170_p.field_72996_f.contains(latchedEntity)))
			{
				latchedEntity = null;

				field_70180_af.func_187227_b(IS_LATCHED, (byte)0);
			}
		}

		if(!isLatched())
		{
			field_70181_x = Math.min(field_70181_x*1.02F, 0.2F);

			func_70091_d(MoverType.SELF, field_70159_w, field_70181_x, field_70179_y);

			field_70159_w *= 0.98;
			field_70179_y *= 0.98;

			if(field_70122_E)
			{
				field_70159_w *= 0.7;
				field_70179_y *= 0.7;
			}

			if(field_70181_x == 0)
			{
				field_70181_x = 0.04;
			}
		}
		else if(latched != null)
		{
			field_70159_w = 0;
			field_70181_x = 0;
			field_70179_y = 0;
		}
		else if(latchedEntity != null && latchedEntity.func_110143_aJ() > 0)
		{
			int floor = getFloor(latchedEntity);

			if(latchedEntity.field_70163_u-(floor+1) < -0.1)
			{
				latchedEntity.field_70181_x = Math.max(0.04, latchedEntity.field_70181_x*1.015);
			}
			else if(latchedEntity.field_70163_u-(floor+1) > 0.1)
			{
				latchedEntity.field_70181_x = Math.min(-0.04, latchedEntity.field_70181_x*1.015);
			}
			else {
				latchedEntity.field_70181_x = 0;
			}

			func_70107_b(latchedEntity.field_70165_t, latchedEntity.field_70163_u + getAddedHeight(), latchedEntity.field_70161_v);
		}
	}
	
	public double getAddedHeight()
	{
		return latchedEntity.field_70131_O + 0.8;
	}

	private int getFloor(EntityLivingBase entity)
	{
		BlockPos pos = new BlockPos(entity);

		for(BlockPos posi = pos; posi.func_177956_o() > 0; posi = posi.func_177977_b())
		{
			if(posi.func_177956_o() < 256 && !field_70170_p.func_175623_d(posi))
			{
				return posi.func_177956_o()+1+(entity instanceof EntityPlayer ? 1 : 0);
			}
		}

		return -1;
	}

	private void findCachedEntity()
	{
		for(Object obj : field_70170_p.field_72996_f)
		{
			if(obj instanceof EntityLivingBase)
			{
				EntityLivingBase entity = (EntityLivingBase)obj;

				if(entity.func_110124_au().equals(cachedEntityUUID))
				{
					latchedEntity = entity;
				}
			}
		}
	}

	private void pop()
	{
		func_184185_a(MekanismSounds.POP, 1, 1);

		if(field_70170_p.field_72995_K)
		{
			for(int i = 0; i < 10; i++)
			{
				try {
					doParticle();
				} catch(Throwable t) {}
			}
		}

		func_70106_y();
	}

	@SideOnly(Side.CLIENT)
	private void doParticle()
	{
		Pos3D pos = new Pos3D(field_70165_t + (field_70146_Z.nextFloat()*.6 - 0.3), field_70163_u + (field_70146_Z.nextFloat()*.6 - 0.3), field_70161_v + (field_70146_Z.nextFloat()*.6 - 0.3));

		Particle fx = new ParticleRedstone.Factory().func_178902_a(0, field_70170_p, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0, 0, 0);
		fx.func_70538_b(color.getColor(0), color.getColor(1), color.getColor(2));

		Minecraft.func_71410_x().field_71452_i.func_78873_a(fx);
	}

	@Override
	public boolean func_70104_M()
	{
		return latched == null;
	}

	@Override
	public boolean func_70067_L()
	{
		return !field_70128_L;
	}

	@Override
	protected boolean func_70041_e_()
	{
		return false;
	}

	@Override
	protected void func_70088_a() {}

	@Override
	protected void func_70037_a(NBTTagCompound nbtTags)
	{
		color = EnumColor.values()[nbtTags.func_74762_e("color")];

		if(nbtTags.func_74764_b("latched"))
		{
			latched = Coord4D.read(nbtTags.func_74775_l("latched"));
		}

		if(nbtTags.func_74764_b("idMost"))
		{
			hasCachedEntity = true;
			cachedEntityUUID = new UUID(nbtTags.func_74763_f("idMost"), nbtTags.func_74763_f("idLeast"));
		}
	}

	@Override
	protected void func_70014_b(NBTTagCompound nbtTags)
	{
		nbtTags.func_74768_a("color", color.ordinal());

		if(latched != null)
		{
			nbtTags.func_74782_a("latched", latched.write(new NBTTagCompound()));
		}

		if(latchedEntity != null)
		{
			nbtTags.func_74772_a("idMost", latchedEntity.func_110124_au().getMostSignificantBits());
			nbtTags.func_74772_a("idLeast", latchedEntity.func_110124_au().getLeastSignificantBits());
		}
	}

	@Override
	public boolean func_85031_j(Entity entity)
	{
		pop();
		return true;
	}

	@Override
	public void writeSpawnData(ByteBuf data)
	{
		data.writeDouble(field_70165_t);
		data.writeDouble(field_70163_u);
		data.writeDouble(field_70161_v);

		data.writeInt(color.ordinal());

		if(latched != null)
		{
			data.writeByte((byte)1);

			latched.write(data);
		}
		else if(latchedEntity != null)
		{
			data.writeByte((byte)2);
			data.writeInt(latchedEntity.func_145782_y());
		}
		else {
			data.writeByte((byte)0);
		}
	}

	@Override
	public void readSpawnData(ByteBuf data)
	{
		func_70107_b(data.readDouble(), data.readDouble(), data.readDouble());

		color = EnumColor.values()[data.readInt()];

		byte type = data.readByte();

		if(type == 1)
		{
			latched = Coord4D.read(data);
		}
		else if(type == 2)
		{
			latchedEntity = (EntityLivingBase)field_70170_p.func_73045_a(data.readInt());
		}
		else {
			latched = null;
		}
	}

	@Override
	public void func_70106_y()
	{
		super.func_70106_y();

		if(latchedEntity != null)
		{
			latchedEntity.field_70160_al = false;
		}
	}

	@Override
	public boolean func_70112_a(double dist)
	{
		return dist <= 64;
	}

	@Override
	public boolean func_145770_h(double p_145770_1_, double p_145770_3_, double p_145770_5_)
	{
		return true;
	}

	@Override
	public boolean func_70097_a(DamageSource dmgSource, float damage)
	{
		if(func_180431_b(dmgSource))
		{
			return false;
		}
		else {
			func_70018_K();

			if(dmgSource != DamageSource.field_76376_m && dmgSource != DamageSource.field_76369_e && dmgSource != DamageSource.field_76379_h)
			{
				pop();
				return true;
			}

			return false;
		}
	}

	public boolean isLatched()
	{
		if(!field_70170_p.field_72995_K)
		{
			return latched != null || latchedEntity != null;
		}
		else {
			return field_70180_af.func_187225_a(IS_LATCHED) > 0;
		}
	}

	public boolean isLatchedToEntity()
	{
		return field_70180_af.func_187225_a(IS_LATCHED) == 2 && latchedEntity != null;
	}
}
