package mekanism.common.entity;

import java.util.UUID;

import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.world.World;

public class EntityBabySkeleton extends EntitySkeleton
{
    private static final UUID babySpeedBoostUUID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier babySpeedBoostModifier = new AttributeModifier(babySpeedBoostUUID, "Baby speed boost", 0.5D, 1);
    
    private static final DataParameter<Boolean> IS_CHILD = EntityDataManager.<Boolean>func_187226_a(EntityBabySkeleton.class, DataSerializers.field_187198_h);
    
	public EntityBabySkeleton(World world) 
	{
		super(world);
		
		field_70180_af.func_187214_a(IS_CHILD, false);
		setChild(true);
	}
	
    public void setChild(boolean child)
    {
        field_70180_af.func_187227_b(IS_CHILD, child);

        if(field_70170_p != null && !field_70170_p.field_72995_K)
        {
            IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            iattributeinstance.func_111124_b(babySpeedBoostModifier);

            if(child)
            {
                iattributeinstance.func_111121_a(babySpeedBoostModifier);
            }
        }

        updateChildSize(child);
    }
    
    @Override
    public boolean func_70631_g_()
    {
    	return field_70180_af.func_187225_a(IS_CHILD);
    }
    
    @Override
    protected int func_70693_a(EntityPlayer p_70693_1_)
    {
        if(func_70631_g_())
        {
            field_70728_aV = (int)((float)field_70728_aV * 2.5F);
        }

        return super.func_70693_a(p_70693_1_);
    }
    
    public void updateChildSize(boolean child)
    {
        updateSize(child ? 0.5F : 1.0F);
    }

    protected final void updateSize(float size)
    {
        super.func_70105_a(size, size+0.4F);
    }
}
