package mekanism.common.content.transporter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.content.transporter.TransitRequest.TransitResponse;
import mekanism.common.content.transporter.TransporterStack.Path;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.items.IItemHandler;

public class TransporterManager
{
	public static Map<Coord4D, Set<TransporterStack>> flowingStacks = new HashMap<Coord4D, Set<TransporterStack>>();
	
	public static void reset()
	{
		flowingStacks.clear();
	}

	public static void add(TransporterStack stack)
	{
		Set<TransporterStack> set = new HashSet<TransporterStack>();
		set.add(stack);
		
		if(flowingStacks.get(stack.getDest()) == null)
		{
			flowingStacks.put(stack.getDest(), set);
		}
		else {
			flowingStacks.get(stack.getDest()).addAll(set);
		}
	}

	public static void remove(TransporterStack stack)
	{
		if(stack.hasPath() && stack.pathType != Path.NONE)
		{
			flowingStacks.get(stack.getDest()).remove(stack);
		}
	}

	public static List<TransporterStack> getStacksToDest(Coord4D dest)
	{
		List<TransporterStack> ret = new ArrayList<TransporterStack>();

		if(flowingStacks.containsKey(dest))
		{
			for(TransporterStack stack : flowingStacks.get(dest))
			{
				if(stack != null && stack.pathType != Path.NONE && stack.hasPath())
				{
					if(stack.getDest().equals(dest))
					{
						ret.add(stack);
					}
				}
			}
		}

		return ret;
	}
	
	public static InventoryCopy copyInv(IItemHandler handler)
	{
		NonNullList<ItemStack> ret = NonNullList.func_191197_a(handler.getSlots(), ItemStack.field_190927_a);
		
		for(int i = 0; i < handler.getSlots(); i++)
		{
			ret.set(i, handler.getStackInSlot(i));
		}
		
		return new InventoryCopy(ret);
	}

	public static InventoryCopy copyInvFromSide(IInventory inv, EnumFacing side)
	{
		NonNullList<ItemStack> ret = NonNullList.func_191197_a(inv.func_70302_i_(), ItemStack.field_190927_a);

		if(!(inv instanceof ISidedInventory))
		{
			for(int i = 0; i <= inv.func_70302_i_() - 1; i++)
			{
				ret.set(i, !inv.func_70301_a(i).func_190926_b() ? inv.func_70301_a(i).func_77946_l() : ItemStack.field_190927_a);
			}
		}
		else {
			ISidedInventory sidedInventory = (ISidedInventory)inv;
			int[] slots = sidedInventory.func_180463_a(side.func_176734_d());

			if(slots == null || slots.length == 0)
			{
				return null;
			}

			for(int get = 0; get <= slots.length - 1; get++)
			{
				int slotID = slots[get];

				if (slotID >= ret.size()){
					Mekanism.logger.error("Inventory {} gave slot number >= the number of slots it reported! {} >= {} ", inv.getClass().getName(), slotID, ret.size());
					continue;
				}

				ret.set(slotID, !sidedInventory.func_70301_a(slotID).func_190926_b() ? sidedInventory.func_70301_a(slotID).func_77946_l() : ItemStack.field_190927_a);
			}
			
			if(inv instanceof TileEntityBin)
			{
				return new InventoryCopy(ret, ((TileEntityBin)inv).getItemCount());
			}
			else {
				return new InventoryCopy(ret);
			}
		}

		return new InventoryCopy(ret);
	}

	public static void testInsert(TileEntity tile, InventoryCopy copy, EnumFacing side, TransporterStack stack)
	{
		ItemStack toInsert = stack.itemStack.func_77946_l();

		if(stack.pathType != Path.HOME && tile instanceof ISideConfiguration)
		{
			ISideConfiguration config = (ISideConfiguration)tile;
			EnumFacing tileSide = config.getOrientation();
			EnumColor configColor = config.getEjector().getInputColor(MekanismUtils.getBaseOrientation(side, tileSide).func_176734_d());

			if(config.getEjector().hasStrictInput() && configColor != null && configColor != stack.color)
			{
				return;
			}
		}
		
//		if(Loader.isModLoaded("MinefactoryReloaded") && tile instanceof IDeepStorageUnit && !(tile instanceof TileEntityBin))
//		{
//			return;
//		}

		if(tile instanceof ISidedInventory)
		{
			ISidedInventory sidedInventory = (ISidedInventory)tile;
			int[] slots = sidedInventory.func_180463_a(side.func_176734_d());

			if(slots != null && slots.length != 0)
			{
				if(stack.pathType != Path.HOME && sidedInventory instanceof TileEntityBin && side.func_176734_d() == EnumFacing.DOWN)
				{
					slots = sidedInventory.func_180463_a(EnumFacing.UP);
				}

				if(tile instanceof TileEntityBin)
				{
					int slot = slots[0];
					
					if(!sidedInventory.func_94041_b(slot, toInsert) || !sidedInventory.func_180462_a(slot, toInsert, side.func_176734_d()))
					{
						return;
					}
					
					int amountRemaining = ((TileEntityBin)sidedInventory).getMaxStoredCount()-copy.binAmount;
					copy.binAmount += Math.min(amountRemaining, toInsert.func_190916_E());
					
					return;
				}
				else {
					for(int get = 0; get <= slots.length - 1; get++)
					{
						int slotID = slots[get];
	
						if(stack.pathType != Path.HOME)
						{
							if(!sidedInventory.func_94041_b(slotID, toInsert) || !sidedInventory.func_180462_a(slotID, toInsert, side.func_176734_d()))
							{
								continue;
							}
						}
	
						ItemStack inSlot = copy.inventory.get(slotID);
	
						if(inSlot.func_190926_b())
						{
							if(toInsert.func_190916_E() <= sidedInventory.func_70297_j_())
							{
								copy.inventory.set(slotID, toInsert);
								return;
							}
							else {
								int rejects = toInsert.func_190916_E() - sidedInventory.func_70297_j_();
								
								ItemStack toSet = toInsert.func_77946_l();
								toSet.func_190920_e(sidedInventory.func_70297_j_());

								ItemStack remains = toInsert.func_77946_l();
								remains.func_190920_e(rejects);

								copy.inventory.set(slotID, toSet);

								toInsert = remains;
							}
						}
						else if(InventoryUtils.areItemsStackable(toInsert, inSlot) && inSlot.func_190916_E() < Math.min(inSlot.func_77976_d(), sidedInventory.func_70297_j_()))
						{
							int max = Math.min(inSlot.func_77976_d(), sidedInventory.func_70297_j_());
							
							if(inSlot.func_190916_E() + toInsert.func_190916_E() <= max)
							{
								ItemStack toSet = toInsert.func_77946_l();
								toSet.func_190917_f(inSlot.func_190916_E());
	
								copy.inventory.set(slotID, toSet);
								return;
							}
							else {
								int rejects = (inSlot.func_190916_E() + toInsert.func_190916_E()) - max;
	
								ItemStack toSet = toInsert.func_77946_l();
								toSet.func_190920_e(max);
	
								ItemStack remains = toInsert.func_77946_l();
								remains.func_190920_e(rejects);
	
								copy.inventory.set(slotID, toSet);
	
								toInsert = remains;
							}
						}
					}
				}
			}
		}
		else if(tile instanceof IInventory)
		{
			IInventory inv = InventoryUtils.checkChestInv((IInventory)tile);
			
			for(int i = 0; i <= inv.func_70302_i_() - 1; i++)
			{
				if(stack.pathType != Path.HOME)
				{
					if(!inv.func_94041_b(i, toInsert))
					{
						continue;
					}
				}

				ItemStack inSlot = copy.inventory.get(i);

				if(inSlot.func_190926_b())
				{
					if(toInsert.func_190916_E() <= inv.func_70297_j_())
					{
						copy.inventory.set(i, toInsert);
						return;
					}
					else {
						int rejects = toInsert.func_190916_E() - inv.func_70297_j_();
						
						ItemStack toSet = toInsert.func_77946_l();
						toSet.func_190920_e(inv.func_70297_j_());

						ItemStack remains = toInsert.func_77946_l();
						remains.func_190920_e(rejects);

						copy.inventory.set(i, toSet);

						toInsert = remains;
					}
				}
				else if(InventoryUtils.areItemsStackable(toInsert, inSlot) && inSlot.func_190916_E() < Math.min(inSlot.func_77976_d(), inv.func_70297_j_()))
				{
					int max = Math.min(inSlot.func_77976_d(), inv.func_70297_j_());
					
					if(inSlot.func_190916_E() + toInsert.func_190916_E() <= max)
					{
						ItemStack toSet = toInsert.func_77946_l();
						toSet.func_190917_f(inSlot.func_190916_E());

						copy.inventory.set(i, toSet);
						return;
					}
					else {
						int rejects = (inSlot.func_190916_E() + toInsert.func_190916_E()) - max;

						ItemStack toSet = toInsert.func_77946_l();
						toSet.func_190920_e(max);

						ItemStack remains = toInsert.func_77946_l();
						remains.func_190920_e(rejects);

						copy.inventory.set(i, toSet);

						toInsert = remains;
					}
				}
			}
		}
		else if(InventoryUtils.isItemHandler(tile, side.func_176734_d()))
		{
			IItemHandler inv = InventoryUtils.getItemHandler(tile, side.func_176734_d());
			
			for(int i = 0; i <= inv.getSlots() - 1; i++)
			{
				if(stack.pathType != Path.HOME)
				{
					ItemStack rejectStack = inv.insertItem(i, toInsert, true);
					
					if(!TransporterManager.didEmit(toInsert, rejectStack))
					{
						continue;
					}
				}

				ItemStack inSlot = copy.inventory.get(i);

				if(inSlot.func_190926_b())
				{
					if(toInsert.func_190916_E() <= inv.getSlotLimit(i))
					{
						copy.inventory.set(i, toInsert);
						return;
					}
					else {
						int rejects = toInsert.func_190916_E() - inv.getSlotLimit(i);
						
						ItemStack toSet = toInsert.func_77946_l();
						toSet.func_190920_e(inv.getSlotLimit(i));

						ItemStack remains = toInsert.func_77946_l();
						remains.func_190920_e(rejects);

						copy.inventory.set(i, toSet);

						toInsert = remains;
					}
				}
				else if(InventoryUtils.areItemsStackable(toInsert, inSlot) && inSlot.func_190916_E() < Math.min(inSlot.func_77976_d(), inv.getSlotLimit(i)))
				{
					int max = Math.min(inSlot.func_77976_d(), inv.getSlotLimit(i));
					
					if(inSlot.func_190916_E() + toInsert.func_190916_E() <= max)
					{
						ItemStack toSet = toInsert.func_77946_l();
						toSet.func_190917_f(inSlot.func_190916_E());

						copy.inventory.set(i, toSet);
						return;
					}
					else {
						int rejects = (inSlot.func_190916_E() + toInsert.func_190916_E()) - max;

						ItemStack toSet = toInsert.func_77946_l();
						toSet.func_190920_e(max);

						ItemStack remains = toInsert.func_77946_l();
						remains.func_190920_e(rejects);

						copy.inventory.set(i, toSet);

						toInsert = remains;
					}
				}
			}
		}
	}

	public static boolean didEmit(ItemStack stack, ItemStack returned)
	{
		return returned.func_190926_b() || returned.func_190916_E() < stack.func_190916_E();
	}

	public static ItemStack getToUse(ItemStack stack, ItemStack returned)
	{
		if(returned.func_190926_b() || returned.func_190916_E() == 0)
		{
			return stack;
		}

		return MekanismUtils.size(stack, stack.func_190916_E()-returned.func_190916_E());
	}
	
	public static ItemStack getToUse(ItemStack stack, int rejected)
	{
		return MekanismUtils.size(stack, stack.func_190916_E()-rejected);
	}

	/**
	 * @return TransitResponse of expected items to use
	 */
	public static TransitResponse getPredictedInsert(TileEntity tileEntity, EnumColor color, TransitRequest request, EnumFacing side)
	{
		if(tileEntity instanceof ISideConfiguration)
		{
			ISideConfiguration config = (ISideConfiguration)tileEntity;
			EnumFacing tileSide = config.getOrientation();
			EnumColor configColor = config.getEjector().getInputColor(MekanismUtils.getBaseOrientation(side, tileSide).func_176734_d());

			if(config.getEjector().hasStrictInput() && configColor != null && configColor != color)
			{
				return TransitResponse.EMPTY;
			}
		}

		InventoryCopy copy = null;
		
		if(tileEntity instanceof IInventory)
		{
			copy = copyInvFromSide(InventoryUtils.checkChestInv((IInventory)tileEntity), side);
		}
		else if(InventoryUtils.isItemHandler(tileEntity, side.func_176734_d()))
		{
			copy = copyInv(InventoryUtils.getItemHandler(tileEntity, side.func_176734_d()));
		}

		if(copy == null)
		{
			return TransitResponse.EMPTY;
		}

		List<TransporterStack> insertQueue = getStacksToDest(Coord4D.get(tileEntity));

		for(TransporterStack tStack : insertQueue)
		{
			testInsert(tileEntity, copy, side, tStack);
		}

		for(Map.Entry<ItemStack, Integer> requestEntry : request.itemMap.entrySet())
		{
			ItemStack toInsert = requestEntry.getKey().func_77946_l();
	
			if(tileEntity instanceof ISidedInventory)
			{
				ISidedInventory sidedInventory = (ISidedInventory)tileEntity;
				int[] slots = sidedInventory.func_180463_a(side.func_176734_d());
	
				if(slots != null && slots.length != 0)
				{
					if(tileEntity instanceof TileEntityBin)
					{
						int slot = slots[0];
						
						if(!sidedInventory.func_94041_b(slot, toInsert) || !sidedInventory.func_180462_a(slot, toInsert, side.func_176734_d()))
						{
							continue;
						}
						
						int amountRemaining = ((TileEntityBin)tileEntity).getMaxStoredCount()-copy.binAmount;
						ItemStack ret = null;
						
						if(toInsert.func_190916_E() <= amountRemaining)
						{
							ret = toInsert;
						}
						else {
							ret = StackUtils.size(toInsert, amountRemaining);
						}
						
						return new TransitResponse(requestEntry.getValue(), ret);
					}
					else {
						for(int get = 0; get <= slots.length - 1; get++)
						{
							int slotID = slots[get];
		
							if(!sidedInventory.func_94041_b(slotID, toInsert) || !sidedInventory.func_180462_a(slotID, toInsert, side.func_176734_d()))
							{
								continue;
							}
		
							ItemStack inSlot = copy.inventory.get(slotID);
							
							if(toInsert.func_190926_b())
							{
								return new TransitResponse(requestEntry.getValue(), requestEntry.getKey());
							}
							else if(inSlot.func_190926_b())
							{
								if(toInsert.func_190916_E() <= sidedInventory.func_70297_j_())
								{
									return new TransitResponse(requestEntry.getValue(), requestEntry.getKey());
								}
								else {
									int rejects = toInsert.func_190916_E() - sidedInventory.func_70297_j_();
									
									if(rejects < toInsert.func_190916_E())
									{
										toInsert = StackUtils.size(toInsert, rejects);
									}
								}
							}
							else if(InventoryUtils.areItemsStackable(toInsert, inSlot) && inSlot.func_190916_E() < Math.min(inSlot.func_77976_d(), sidedInventory.func_70297_j_()))
							{
								int max = Math.min(inSlot.func_77976_d(), sidedInventory.func_70297_j_());
								
								if(inSlot.func_190916_E() + toInsert.func_190916_E() <= max)
								{
									return new TransitResponse(requestEntry.getValue(), requestEntry.getKey());
								}
								else {
									int rejects = (inSlot.func_190916_E() + toInsert.func_190916_E()) - max;
		
									if(rejects < toInsert.func_190916_E())
									{
										toInsert = StackUtils.size(toInsert, rejects);
									}
								}
							}
						}
						
						if(TransporterManager.didEmit(requestEntry.getKey(), toInsert))
						{
							return new TransitResponse(requestEntry.getValue(), getToUse(requestEntry.getKey(), toInsert));
						}
					}
				}
			}
			else if(tileEntity instanceof IInventory)
			{
				IInventory inventory = InventoryUtils.checkChestInv((IInventory)tileEntity);
				
				for(int i = 0; i <= inventory.func_70302_i_() - 1; i++)
				{
					if(!inventory.func_94041_b(i, toInsert))
					{
						continue;
					}
	
					ItemStack inSlot = copy.inventory.get(i);
	
					if(toInsert.func_190926_b())
					{
						return new TransitResponse(requestEntry.getValue(), requestEntry.getKey());
					}
					else if(inSlot.func_190926_b())
					{
						if(toInsert.func_190916_E() <= inventory.func_70297_j_())
						{
							return new TransitResponse(requestEntry.getValue(), requestEntry.getKey());
						}
						else {
							int rejects = toInsert.func_190916_E() - inventory.func_70297_j_();
							
							if(rejects < toInsert.func_190916_E())
							{
								toInsert = StackUtils.size(toInsert, rejects);
							}
						}
					}
					else if(InventoryUtils.areItemsStackable(toInsert, inSlot) && inSlot.func_190916_E() < Math.min(inSlot.func_77976_d(), inventory.func_70297_j_()))
					{
						int max = Math.min(inSlot.func_77976_d(), inventory.func_70297_j_());
						
						if(inSlot.func_190916_E() + toInsert.func_190916_E() <= max)
						{
							return new TransitResponse(requestEntry.getValue(), requestEntry.getKey());
						}
						else {
							int rejects = (inSlot.func_190916_E() + toInsert.func_190916_E()) - max;
	
							if(rejects < toInsert.func_190916_E())
							{
								toInsert = StackUtils.size(toInsert, rejects);
							}
						}
					}
				}
				
				if(TransporterManager.didEmit(requestEntry.getKey(), toInsert))
				{
					return new TransitResponse(requestEntry.getValue(), getToUse(requestEntry.getKey(), toInsert));
				}
			}
			else if(InventoryUtils.isItemHandler(tileEntity, side.func_176734_d()))
			{
				IItemHandler inventory = InventoryUtils.getItemHandler(tileEntity, side.func_176734_d());
				
				for(int i = 0; i <= inventory.getSlots() - 1; i++)
				{
					ItemStack rejectStack = inventory.insertItem(i, toInsert, true);
					
					if(!TransporterManager.didEmit(toInsert, rejectStack))
					{
						continue;
					}
	
					ItemStack inSlot = copy.inventory.get(i);
	
					if(toInsert.func_190926_b())
					{
						return new TransitResponse(requestEntry.getValue(), requestEntry.getKey());
					}
					else if(inSlot.func_190926_b())
					{
						if(toInsert.func_190916_E() <= inventory.getSlotLimit(i))
						{
							return new TransitResponse(requestEntry.getValue(), requestEntry.getKey());
						}
						else {
							int rejects = toInsert.func_190916_E() - inventory.getSlotLimit(i);
							
							if(rejects < toInsert.func_190916_E())
							{
								toInsert = StackUtils.size(toInsert, rejects);
							}
						}
					}
					else if(InventoryUtils.areItemsStackable(toInsert, inSlot) && inSlot.func_190916_E() < Math.min(inSlot.func_77976_d(), inventory.getSlotLimit(i)))
					{
						int max = Math.min(inSlot.func_77976_d(), inventory.getSlotLimit(i));
						
						if(inSlot.func_190916_E() + toInsert.func_190916_E() <= max)
						{
							return new TransitResponse(requestEntry.getValue(), requestEntry.getKey());
						}
						else {
							int rejects = (inSlot.func_190916_E() + toInsert.func_190916_E()) - max;
	
							if(rejects < toInsert.func_190916_E())
							{
								toInsert = StackUtils.size(toInsert, rejects);
							}
						}
					}
				}
				
				if(TransporterManager.didEmit(requestEntry.getKey(), toInsert))
				{
					return new TransitResponse(requestEntry.getValue(), getToUse(requestEntry.getKey(), toInsert));
				}
			}
		}

		return TransitResponse.EMPTY;
	}
	
	public static class InventoryCopy
	{
		public NonNullList<ItemStack> inventory;
		
		public int binAmount;
		
		public InventoryCopy(NonNullList<ItemStack> inv)
		{
			inventory = inv;
		}
		
		public InventoryCopy(NonNullList<ItemStack> inv, int amount)
		{
			this(inv);
			binAmount = amount;
		}
	}
}
