package mekanism.common.content.transporter;

import java.util.HashMap;
import java.util.Map;

import mekanism.common.content.transporter.Finder.FirstFinder;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;

public class TransitRequest
{
	public Map<ItemStack, Integer> itemMap = new HashMap<>();
	
	public boolean isEmpty()
	{
		return itemMap.isEmpty();
	}
	
	public void setItem(ItemStack stack, int slot)
	{
		itemMap.put(stack, slot);
	}
	
	public ItemStack getSingleStack()
	{
		return itemMap.keySet().iterator().next();
	}
	
	public boolean hasType(ItemStack stack)
	{
		for(ItemStack s : itemMap.keySet())
		{
			if(InventoryUtils.areItemsStackable(stack, s))
			{
				return true;
			}
		}
		
		return false;
	}
	
	public static TransitRequest getFromTransport(TransporterStack stack)
	{
		return getFromStack(stack.itemStack);
	}
	
	public static TransitRequest getFromStack(ItemStack stack)
	{
		TransitRequest ret = new TransitRequest();
		ret.setItem(stack, -1);
		return ret;
	}
	
	public static TransitRequest getTopStacks(TileEntity tile, EnumFacing side, int amount)
	{
		return getTopStacks(tile, side, amount, new FirstFinder());
	}
	
	public static TransitRequest getTopStacks(TileEntity tile, EnumFacing side, int amount, Finder finder)
	{
		TransitRequest ret = new TransitRequest();
		
  		if(tile instanceof ISidedInventory)
		{
			ISidedInventory sidedInventory = (ISidedInventory)tile;
			int[] slots = sidedInventory.func_180463_a(side.func_176734_d());

			if(slots != null)
			{
				for(int get = slots.length - 1; get >= 0; get--)
				{
					int slotID = slots[get];

					if(!sidedInventory.func_70301_a(slotID).func_190926_b() && sidedInventory.func_70301_a(slotID).func_190916_E() > 0)
					{
						ItemStack toSend = sidedInventory.func_70301_a(slotID).func_77946_l();
						toSend.func_190920_e(Math.min(amount, toSend.func_190916_E()));

						if(!ret.hasType(toSend) && sidedInventory.func_180461_b(slotID, toSend, side.func_176734_d()) && finder.modifies(toSend))
						{
							ret.setItem(toSend, slotID);
						}
					}
				}
			}
		}
		else if(tile instanceof IInventory)
		{
			IInventory inventory = InventoryUtils.checkChestInv((IInventory)tile);
			
			for(int i = inventory.func_70302_i_() - 1; i >= 0; i--)
			{
				if(!inventory.func_70301_a(i).func_190926_b() && inventory.func_70301_a(i).func_190916_E() > 0)
				{
					ItemStack toSend = inventory.func_70301_a(i).func_77946_l();
					toSend.func_190920_e(Math.min(amount, toSend.func_190916_E()));

					if(!ret.hasType(toSend) && finder.modifies(toSend))
					{
						ret.setItem(toSend, i);
					}
				}
			}
		}
		else if(InventoryUtils.isItemHandler(tile, side.func_176734_d()))
  		{
  			IItemHandler inventory = InventoryUtils.getItemHandler(tile, side.func_176734_d());
  			
  			for(int i = inventory.getSlots() - 1; i >= 0; i--)
			{
				ItemStack stack = inventory.extractItem(i, amount, true);
				
				if(!stack.func_190926_b() && !ret.hasType(stack) && finder.modifies(stack))
				{
					ret.setItem(stack, i);
				}
			}
  		}

		return ret;
	}
	
	public static class TransitResponse
	{
		public static final TransitResponse EMPTY = new TransitResponse(-1, ItemStack.field_190927_a);
		
		public int slotID;
		public ItemStack stack = ItemStack.field_190927_a;
		
		public TransitResponse(int s, ItemStack i)
		{
			slotID = s;
			stack = i;
		}
		
		public boolean isEmpty()
		{
			return stack.func_190926_b();
		}
		
		public ItemStack getRejected(ItemStack orig)
		{
			return StackUtils.size(orig, orig.func_190916_E() - stack.func_190916_E());
		}
		
		public InvStack getInvStack(TileEntity tile, EnumFacing side)
		{
			return new InvStack(tile, slotID, stack, side);
		}
	}
}
