package mekanism.common.content.transporter;

import io.netty.buffer.ByteBuf;

import java.util.ArrayList;

import mekanism.common.PacketHandler;
import mekanism.common.content.transporter.Finder.OreDictFinder;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TOreDictFilter extends TransporterFilter
{
	public String oreDictName;

	@Override
	public boolean canFilter(ItemStack itemStack, boolean strict)
	{
		if(itemStack.func_190926_b())
		{
			return false;
		}

		return new OreDictFinder(oreDictName).modifies(itemStack);
	}

	@Override
	public Finder getFinder()
	{
		return new OreDictFinder(oreDictName);
	}

	@Override
	public void write(NBTTagCompound nbtTags)
	{
		super.write(nbtTags);

		nbtTags.func_74768_a("type", 1);
		nbtTags.func_74778_a("oreDictName", oreDictName);
	}

	@Override
	protected void read(NBTTagCompound nbtTags)
	{
		super.read(nbtTags);

		oreDictName = nbtTags.func_74779_i("oreDictName");
	}

	@Override
	public void write(ArrayList<Object> data)
	{
		data.add(1);

		super.write(data);

		data.add(oreDictName);
	}

	@Override
	protected void read(ByteBuf dataStream)
	{
		super.read(dataStream);

		oreDictName = PacketHandler.readString(dataStream);
	}

	@Override
	public int hashCode()
	{
		int code = 1;
		code = 31 * code + super.hashCode();
		code = 31 * code + oreDictName.hashCode();
		return code;
	}

	@Override
	public boolean equals(Object filter)
	{
		return super.equals(filter) && filter instanceof TOreDictFilter && ((TOreDictFilter)filter).oreDictName.equals(oreDictName);
	}

	@Override
	public TOreDictFilter clone()
	{
		TOreDictFilter filter = new TOreDictFilter();
		filter.allowDefault = allowDefault;
		filter.color = color;
		filter.oreDictName = oreDictName;

		return filter;
	}
}
