package mekanism.common.content.transporter;

import io.netty.buffer.ByteBuf;

import java.util.ArrayList;

import mekanism.common.content.transporter.Finder.MaterialFinder;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TMaterialFilter extends TransporterFilter
{
	public ItemStack materialItem = ItemStack.field_190927_a;
	
	public Material getMaterial()
	{
		return Block.func_149634_a(materialItem.func_77973_b()).func_176203_a(materialItem.func_77952_i()).func_185904_a();
	}

	@Override
	public boolean canFilter(ItemStack itemStack, boolean strict)
	{
		if(itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof ItemBlock))
		{
			return false;
		}

		return new MaterialFinder(getMaterial()).modifies(itemStack);
	}
	
	@Override
	public Finder getFinder()
	{
		return new MaterialFinder(getMaterial());
	}

	@Override
	public void write(NBTTagCompound nbtTags)
	{
		super.write(nbtTags);
		
		nbtTags.func_74768_a("type", 2);
		materialItem.func_77955_b(nbtTags);
	}

	@Override
	protected void read(NBTTagCompound nbtTags)
	{
		super.read(nbtTags);
		
		materialItem = InventoryUtils.loadFromNBT(nbtTags);
	}

	@Override
	public void write(ArrayList<Object> data)
	{
		data.add(2);
		
		super.write(data);

		data.add(MekanismUtils.getID(materialItem));
		data.add(materialItem.func_190916_E());
		data.add(materialItem.func_77952_i());
	}

	@Override
	protected void read(ByteBuf dataStream)
	{
		super.read(dataStream);
		
		materialItem = new ItemStack(Item.func_150899_d(dataStream.readInt()), dataStream.readInt(), dataStream.readInt());
	}

	@Override
	public int hashCode()
	{
		int code = 1;
		code = 31 * code + MekanismUtils.getID(materialItem);
		code = 31 * code + materialItem.func_190916_E();
		code = 31 * code + materialItem.func_77952_i();
		return code;
	}

	@Override
	public boolean equals(Object filter)
	{
		return super.equals(filter) && filter instanceof TMaterialFilter && ((TMaterialFilter)filter).materialItem.func_77969_a(materialItem);
	}

	@Override
	public TMaterialFilter clone()
	{
		TMaterialFilter filter = new TMaterialFilter();
		filter.allowDefault = allowDefault;
		filter.color = color;
		filter.materialItem = materialItem;

		return filter;
	}
}
