package mekanism.common.content.transporter;

import io.netty.buffer.ByteBuf;

import java.util.ArrayList;

import mekanism.common.content.transporter.Finder.ItemStackFinder;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TItemStackFilter extends TransporterFilter
{
	public boolean sizeMode;

	public int min;
	public int max;

	public ItemStack itemType = ItemStack.field_190927_a;

	@Override
	public boolean canFilter(ItemStack itemStack, boolean strict)
	{
		if(itemStack.func_190926_b())
		{
			return false;
		}

		if(strict && sizeMode)
		{
			if(max == 0 || itemStack.func_190916_E() < min)
			{
				return false;
			}
		}

		return (itemType.func_77981_g() ? itemType.func_77969_a(itemStack) : itemType.func_77973_b() == itemStack.func_77973_b());
	}

	@Override
	public InvStack getStackFromInventory(StackSearcher searcher)
	{
		if(sizeMode)
		{
			return searcher.takeDefinedItem(itemType, min, max);
		}
		else {
			return super.getStackFromInventory(searcher);
		}
	}

	public Finder getFinder()
	{
		return new ItemStackFinder(itemType);
	}

	@Override
	public void write(NBTTagCompound nbtTags)
	{
		super.write(nbtTags);

		nbtTags.func_74768_a("type", 0);
		nbtTags.func_74757_a("sizeMode", sizeMode);
		nbtTags.func_74768_a("min", min);
		nbtTags.func_74768_a("max", max);
		itemType.func_77955_b(nbtTags);
	}

	@Override
	protected void read(NBTTagCompound nbtTags)
	{
		super.read(nbtTags);

		sizeMode = nbtTags.func_74767_n("sizeMode");
		min = nbtTags.func_74762_e("min");
		max = nbtTags.func_74762_e("max");

		itemType = InventoryUtils.loadFromNBT(nbtTags);
	}

	@Override
	public void write(ArrayList<Object> data)
	{
		data.add(0);

		super.write(data);

		data.add(sizeMode);
		data.add(min);
		data.add(max);

		data.add(MekanismUtils.getID(itemType));
		data.add(itemType.func_190916_E());
		data.add(itemType.func_77952_i());
	}

	@Override
	protected void read(ByteBuf dataStream)
	{
		super.read(dataStream);

		sizeMode = dataStream.readBoolean();
		min = dataStream.readInt();
		max = dataStream.readInt();

		itemType = new ItemStack(Item.func_150899_d(dataStream.readInt()), dataStream.readInt(), dataStream.readInt());
	}

	@Override
	public int hashCode()
	{
		int code = 1;
		code = 31 * code + super.hashCode();
		code = 31 * code + MekanismUtils.getID(itemType);
		code = 31 * code + itemType.func_190916_E();
		code = 31 * code + itemType.func_77952_i();
		code = 31 * code + (sizeMode ? 1 : 0);
		code = 31 * code + min;
		code = 31 * code + max;
		return code;
	}

	@Override
	public boolean equals(Object filter)
	{
		return super.equals(filter) && filter instanceof TItemStackFilter && ((TItemStackFilter)filter).itemType.func_77969_a(itemType)
				&& ((TItemStackFilter)filter).sizeMode == sizeMode && ((TItemStackFilter)filter).min == min && ((TItemStackFilter)filter).max == max;
	}

	@Override
	public TItemStackFilter clone()
	{
		TItemStackFilter filter = new TItemStackFilter();
		filter.allowDefault = allowDefault;
		filter.color = color;
		filter.itemType = itemType.func_77946_l();
		filter.sizeMode = sizeMode;
		filter.min = min;
		filter.max = max;

		return filter;
	}
}
