package mekanism.common.content.transporter;

import mekanism.common.util.InventoryUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;

public class StackSearcher
{
	public int i = -1;
	public int[] slots;
	public TileEntity tileEntity;
	public EnumFacing side;

	public StackSearcher(TileEntity tile, EnumFacing direction)
	{
		tileEntity = tile;
		side = direction;
		
		if(tile instanceof ISidedInventory)
		{
			slots = ((ISidedInventory)tile).func_180463_a(side.func_176734_d());
			
			if(slots != null)
			{
				i = slots.length;
			}
		} 
		else if(tile instanceof IInventory)
		{
			i = ((IInventory)tile).func_70302_i_();
		}
		else if(InventoryUtils.isItemHandler(tile, direction.func_176734_d()))
		{
			i = InventoryUtils.getItemHandler(tile, direction.func_176734_d()).getSlots();
		}
	}

	public InvStack takeTopStack(Finder id)
	{
		if(tileEntity instanceof ISidedInventory)
		{
			ISidedInventory inventory = (ISidedInventory)tileEntity;
			
			if(slots != null && slots.length != 0)
			{
				for(i = i - 1; i >= 0; i--)
				{
					int slotID = slots[i];

					if(!inventory.func_70301_a(slotID).func_190926_b() && id.modifies(inventory.func_70301_a(slotID)))
					{
						ItemStack toSend = inventory.func_70301_a(slotID);

						if(((ISidedInventory)inventory).func_180461_b(slotID, toSend, side.func_176734_d()))
						{
							return new InvStack(tileEntity, slotID, toSend, side.func_176734_d());
						}
					}
				}
			}
		}
		else if(tileEntity instanceof IInventory)
		{
			IInventory inventory = InventoryUtils.checkChestInv((IInventory)tileEntity);
			
			for(i = i - 1; i >= 0; i--)
			{
				if(!inventory.func_70301_a(i).func_190926_b() && id.modifies(inventory.func_70301_a(i)))
				{
					ItemStack toSend = inventory.func_70301_a(i).func_77946_l();
					return new InvStack(tileEntity, i, toSend, side.func_176734_d());
				}
			}
		}
		else if(InventoryUtils.isItemHandler(tileEntity, side.func_176734_d()))
		{
			IItemHandler inventory = InventoryUtils.getItemHandler(tileEntity, side.func_176734_d());
			
			for(i = i - 1; i >= 0; i--)
			{
				ItemStack stack = inventory.extractItem(i, 64, true);
				
				if(!stack.func_190926_b() && id.modifies(stack))
				{
					return new InvStack(tileEntity, i, stack, side.func_176734_d());
				}
			}
		}

		return null;
	}

	public InvStack takeDefinedItem(ItemStack type, int min, int max)
	{
		InvStack ret = new InvStack(tileEntity, side.func_176734_d());

		if(tileEntity instanceof ISidedInventory)
		{
			ISidedInventory sidedInventory = (ISidedInventory)tileEntity;
			int[] slots = sidedInventory.func_180463_a(side.func_176734_d());

			if(slots != null && slots.length != 0)
			{
				for(i = i - 1; i >= 0; i--)
				{
					int slotID = slots[i];

					if(!sidedInventory.func_70301_a(slotID).func_190926_b() && StackUtils.equalsWildcard(sidedInventory.func_70301_a(slotID), type))
					{
						ItemStack stack = sidedInventory.func_70301_a(slotID);
						int current = !ret.getStack().func_190926_b() ? ret.getStack().func_190916_E() : 0;

						if(current+stack.func_190916_E() <= max)
						{
							ItemStack copy = stack.func_77946_l();

							if(sidedInventory.func_180461_b(slotID, copy, side.func_176734_d()))
							{
								ret.appendStack(slotID, copy);
							}
						}
						else {
							ItemStack copy = stack.func_77946_l();

							if(sidedInventory.func_180461_b(slotID, copy, side.func_176734_d()))
							{
								copy.func_190920_e(max-current);
								ret.appendStack(slotID, copy);
							}
						}

						if(!ret.getStack().func_190926_b() && ret.getStack().func_190916_E() == max)
						{
							return ret;
						}
					}
				}
			}
		}
		else if(tileEntity instanceof IInventory)
		{
			IInventory inventory = InventoryUtils.checkChestInv((IInventory)tileEntity);
			
			for(i = i - 1; i >= 0; i--)
			{
				if(!inventory.func_70301_a(i).func_190926_b() && StackUtils.equalsWildcard(inventory.func_70301_a(i), type))
				{
					ItemStack stack = inventory.func_70301_a(i);
					int current = !ret.getStack().func_190926_b() ? ret.getStack().func_190916_E() : 0;

					if(current+stack.func_190916_E() <= max)
					{
						ret.appendStack(i, stack.func_77946_l());
					}
					else {
						ItemStack copy = stack.func_77946_l();
						copy.func_190920_e(max-current);
						ret.appendStack(i, copy);
					}

					if(!ret.getStack().func_190926_b() && ret.getStack().func_190916_E() == max)
					{
						return ret;
					}
				}
			}
		}
		else if(InventoryUtils.isItemHandler(tileEntity, side.func_176734_d()))
		{
			IItemHandler inventory = InventoryUtils.getItemHandler(tileEntity, side.func_176734_d());
			
			for(i = i - 1; i >= 0; i--)
			{
				ItemStack stack = inventory.extractItem(i, max, true);
				
				if(!stack.func_190926_b() && StackUtils.equalsWildcard(stack, type))
				{
					int current = !ret.getStack().func_190926_b() ? ret.getStack().func_190916_E() : 0;

					if(current+stack.func_190916_E() <= max)
					{
						ret.appendStack(i, stack.func_77946_l());
					}
					else {
						ItemStack copy = stack.func_77946_l();
						copy.func_190920_e(max-current);
						ret.appendStack(i, copy);
					}

					if(!ret.getStack().func_190926_b() && ret.getStack().func_190916_E() == max)
					{
						return ret;
					}
				}
			}
		}

		if(ret != null && !ret.getStack().func_190926_b() && ret.getStack().func_190916_E() >= min)
		{
			return ret;
		}

		return null;
	}
}
