package mekanism.common.content.transporter;

import java.util.ArrayList;

import mekanism.common.util.InventoryUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;

public final class InvStack
{
	public TileEntity tileEntity;
	public ArrayList<ItemStack> itemStacks;
	public ArrayList<Integer> slotIDs;
	public EnumFacing side;

	public InvStack(TileEntity inv, EnumFacing facing)
	{
		tileEntity = inv;
		itemStacks = new ArrayList<ItemStack>();
		slotIDs = new ArrayList<Integer>();
		side = facing;
	}

	public InvStack(TileEntity inv, int id, ItemStack stack, EnumFacing facing)
	{
		tileEntity = inv;
		itemStacks = new ArrayList<ItemStack>();
		slotIDs = new ArrayList<Integer>();
		side = facing;

		appendStack(id, stack);
	}

	public ItemStack getStack()
	{
		int size = 0;

		for(ItemStack stack : itemStacks)
		{
			size += stack.func_190916_E();
		}

		if(!itemStacks.isEmpty())
		{
			ItemStack ret = itemStacks.get(0).func_77946_l();
			ret.func_190920_e(size);

			return ret;
		}

		return ItemStack.field_190927_a;
	}

	public void appendStack(int id, ItemStack stack)
	{
		slotIDs.add(id);
		itemStacks.add(stack);
	}

	public void use(int amount)
	{
		if(tileEntity instanceof IInventory)
		{
			IInventory inventory = InventoryUtils.checkChestInv((IInventory)tileEntity);
			
			for(int i = 0; i < slotIDs.size(); i++)
			{
				ItemStack stack = itemStacks.get(i);
				
				if(inventory.func_70301_a(slotIDs.get(i)).func_190916_E() == stack.func_190916_E() && stack.func_190916_E() <= amount)
				{
					inventory.func_70299_a(slotIDs.get(i), ItemStack.field_190927_a);
					amount -= stack.func_190916_E();
				}
				else {
					ItemStack ret = stack.func_77946_l();
					ret.func_190920_e(inventory.func_70301_a(slotIDs.get(i)).func_190916_E() - amount);
					inventory.func_70299_a(slotIDs.get(i), ret);
					amount -= stack.func_190916_E();
				}
				
				if(amount == 0)
				{
					return;
				}
			}
		}
		else if(InventoryUtils.isItemHandler(tileEntity, side))
		{
			IItemHandler handler = InventoryUtils.getItemHandler(tileEntity, side);
			
			for(int i = 0; i < slotIDs.size(); i++)
			{
				ItemStack stack = itemStacks.get(i);
				int toUse = Math.min(amount, stack.func_190916_E());
				handler.extractItem(slotIDs.get(i), toUse, false);
				amount -= toUse;
				
				if(amount == 0)
				{
					return;
				}
			}
		}
	}

	public void use()
	{
		use(getStack().func_190916_E());
	}
}
