package mekanism.common.content.tank;

import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.util.FluidContainerUtils.ContainerEditMode;
import mekanism.common.util.InventoryUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.util.Constants.NBT;
import net.minecraftforge.fluids.FluidStack;

public class TankCache extends MultiblockCache<SynchronizedTankData>
{	
	public NonNullList<ItemStack> inventory = NonNullList.func_191197_a(2, ItemStack.field_190927_a);
	
	public FluidStack fluid;
	
	public ContainerEditMode editMode = ContainerEditMode.BOTH;
	
	@Override
	public void apply(SynchronizedTankData data)
	{
		data.inventory = inventory;
		data.fluidStored = fluid;
		data.editMode = editMode;
	}
	
	@Override
	public void sync(SynchronizedTankData data)
	{
		inventory = data.inventory;
		fluid = data.fluidStored;
		editMode = data.editMode;
	}
	
	@Override
	public void load(NBTTagCompound nbtTags)
	{
		editMode = ContainerEditMode.values()[nbtTags.func_74762_e("editMode")];
		
		NBTTagList tagList = nbtTags.func_150295_c("Items", NBT.TAG_COMPOUND);
		inventory = NonNullList.func_191197_a(2, ItemStack.field_190927_a);

		for(int tagCount = 0; tagCount < tagList.func_74745_c(); tagCount++)
		{
			NBTTagCompound tagCompound = (NBTTagCompound)tagList.func_150305_b(tagCount);
			byte slotID = tagCompound.func_74771_c("Slot");

			if(slotID >= 0 && slotID < 2)
			{
				inventory.set(slotID, InventoryUtils.loadFromNBT(tagCompound));
			}
		}
		
		if(nbtTags.func_74764_b("cachedFluid"))
		{
			fluid = FluidStack.loadFluidStackFromNBT(nbtTags.func_74775_l("cachedFluid"));
		}
	}
	
	@Override
	public void save(NBTTagCompound nbtTags)
	{
		nbtTags.func_74768_a("editMode", editMode.ordinal());
		
		NBTTagList tagList = new NBTTagList();

		for(int slotCount = 0; slotCount < 2; slotCount++)
		{
			if(!inventory.get(slotCount).func_190926_b())
			{
				NBTTagCompound tagCompound = new NBTTagCompound();
				tagCompound.func_74774_a("Slot", (byte)slotCount);
				inventory.get(slotCount).func_77955_b(tagCompound);
				tagList.func_74742_a(tagCompound);
			}
		}

		nbtTags.func_74782_a("Items", tagList);
		
		if(fluid != null)
		{
			nbtTags.func_74782_a("cachedFluid", fluid.writeToNBT(new NBTTagCompound()));
		}
	}
}
