package mekanism.common.content.miner;

import io.netty.buffer.ByteBuf;

import java.util.ArrayList;

import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MItemStackFilter extends MinerFilter
{
	public ItemStack itemType = ItemStack.field_190927_a;
	public boolean fuzzy;

	public MItemStackFilter(ItemStack item)
	{
		itemType = item;
	}

	public MItemStackFilter() {}

	@Override
	public boolean canFilter(ItemStack itemStack)
	{
		if(itemStack.func_190926_b())
		{
			return false;
		}

		if(itemStack.func_77973_b() == itemType.func_77973_b() && fuzzy)
		{
			return true;
		}

		return itemType.func_77969_a(itemStack);
	}

	@Override
	public NBTTagCompound write(NBTTagCompound nbtTags)
	{
		super.write(nbtTags);
		
		nbtTags.func_74768_a("type", 0);
		
		nbtTags.func_74757_a("fuzzy", fuzzy);
		itemType.func_77955_b(nbtTags);

		return nbtTags;
	}

	@Override
	protected void read(NBTTagCompound nbtTags)
	{
		super.read(nbtTags);
		
		fuzzy = nbtTags.func_74767_n("fuzzy");
		itemType = InventoryUtils.loadFromNBT(nbtTags);
	}

	@Override
	public void write(ArrayList<Object> data)
	{
		data.add(0);
		
		super.write(data);

		data.add(fuzzy);
		
		data.add(MekanismUtils.getID(itemType));
		data.add(itemType.func_190916_E());
		data.add(itemType.func_77952_i());
	}

	@Override
	protected void read(ByteBuf dataStream)
	{
		super.read(dataStream);
		
		fuzzy = dataStream.readBoolean();
		
		itemType = new ItemStack(Item.func_150899_d(dataStream.readInt()), dataStream.readInt(), dataStream.readInt());
	}

	@Override
	public int hashCode()
	{
		int code = 1;
		code = 31 * code + MekanismUtils.getID(itemType);
		code = 31 * code + itemType.func_190916_E();
		code = 31 * code + itemType.func_77952_i();
		return code;
	}

	@Override
	public boolean equals(Object filter)
	{
		return super.equals(filter) && filter instanceof MItemStackFilter && ((MItemStackFilter)filter).itemType.func_77969_a(itemType);
	}

	@Override
	public MItemStackFilter clone()
	{
		MItemStackFilter filter = new MItemStackFilter();
		filter.replaceStack = replaceStack;
		filter.requireStack = requireStack;
		filter.fuzzy = fuzzy;
		filter.itemType = itemType.func_77946_l();

		return filter;
	}
}
