package mekanism.common.content.matrix;

import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.util.InventoryUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.util.Constants.NBT;

public class MatrixCache extends MultiblockCache<SynchronizedMatrixData>
{
	public NonNullList<ItemStack> inventory = NonNullList.func_191197_a(2, ItemStack.field_190927_a);
	
	@Override
	public void apply(SynchronizedMatrixData data) 
	{
		data.inventory = inventory;
	}

	@Override
	public void sync(SynchronizedMatrixData data) 
	{
		inventory = data.inventory;
	}

	@Override
	public void load(NBTTagCompound nbtTags) 
	{
		NBTTagList tagList = nbtTags.func_150295_c("Items", NBT.TAG_COMPOUND);
		inventory = NonNullList.func_191197_a(2, ItemStack.field_190927_a);

		for(int tagCount = 0; tagCount < tagList.func_74745_c(); tagCount++)
		{
			NBTTagCompound tagCompound = (NBTTagCompound)tagList.func_150305_b(tagCount);
			byte slotID = tagCompound.func_74771_c("Slot");

			if(slotID >= 0 && slotID < 2)
			{
				inventory.set(slotID, InventoryUtils.loadFromNBT(tagCompound));
			}
		}
	}

	@Override
	public void save(NBTTagCompound nbtTags) 
	{
		NBTTagList tagList = new NBTTagList();

		for(int slotCount = 0; slotCount < 2; slotCount++)
		{
			if(!inventory.get(slotCount).func_190926_b())
			{
				NBTTagCompound tagCompound = new NBTTagCompound();
				tagCompound.func_74774_a("Slot", (byte)slotCount);
				inventory.get(slotCount).func_77955_b(tagCompound);
				tagList.func_74742_a(tagCompound);
			}
		}

		nbtTags.func_74782_a("Items", tagList);
	}
}
