package mekanism.common.content.entangloporter;

import io.netty.buffer.ByteBuf;

import java.util.ArrayList;
import java.util.UUID;

import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.common.PacketHandler;
import mekanism.common.Tier;
import mekanism.common.config.MekanismConfig.general;
import mekanism.common.frequency.Frequency;
import mekanism.common.util.InventoryUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.util.Constants.NBT;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class InventoryFrequency extends Frequency
{
	public static final String ENTANGLOPORTER = "Entangloporter";
	
	public static final double MAX_ENERGY = general.quantumEntangloporterEnergyTransfer;
	public static final int FLUID_TANK_SIZE = Tier.FluidTankTier.ULTIMATE.output;
	public static final int GAS_TANK_SIZE = Tier.GasTankTier.ULTIMATE.output;

	public double storedEnergy;
	public FluidTank storedFluid;
	public GasTank storedGas;
	public NonNullList<ItemStack> inventory = NonNullList.func_191197_a(1, ItemStack.field_190927_a);
	public double temperature;
	
	public InventoryFrequency(String n, UUID uuid)
	{
		super(n, uuid);
		
		storedFluid = new FluidTank(FLUID_TANK_SIZE);
		storedGas = new GasTank(GAS_TANK_SIZE);
	}
	
	public InventoryFrequency(NBTTagCompound nbtTags)
	{
		super(nbtTags);
	}
	
	public InventoryFrequency(ByteBuf dataStream)
	{
		super(dataStream);
	}
	
	@Override
	public void write(NBTTagCompound nbtTags)
	{
		super.write(nbtTags);
		
		nbtTags.func_74780_a("storedEnergy", storedEnergy);
		
		if(storedFluid.getFluid() != null)
		{
			nbtTags.func_74782_a("storedFluid", storedFluid.writeToNBT(new NBTTagCompound()));
		}
		
		if(storedGas.getGas() != null)
		{
			nbtTags.func_74782_a("storedGas", storedGas.write(new NBTTagCompound()));
		}
		
		NBTTagList tagList = new NBTTagList();

		for(int slotCount = 0; slotCount < 1; slotCount++)
		{
			if(!inventory.get(slotCount).func_190926_b())
			{
				NBTTagCompound tagCompound = new NBTTagCompound();
				tagCompound.func_74774_a("Slot", (byte)slotCount);
				inventory.get(slotCount).func_77955_b(tagCompound);
				tagList.func_74742_a(tagCompound);
			}
		}

		nbtTags.func_74782_a("Items", tagList);
		
		nbtTags.func_74780_a("temperature", temperature);
	}

	@Override
	protected void read(NBTTagCompound nbtTags)
	{
		super.read(nbtTags);
		
		storedFluid = new FluidTank(FLUID_TANK_SIZE);
		storedGas = new GasTank(GAS_TANK_SIZE);
		
		storedEnergy = nbtTags.func_74769_h("storedEnergy");
		
		if(nbtTags.func_74764_b("storedFluid"))
		{
			storedFluid.readFromNBT(nbtTags.func_74775_l("storedFluid"));
		}
		
		if(nbtTags.func_74764_b("storedGas"))
		{
			storedGas.read(nbtTags.func_74775_l("storedGas"));
		}
		
		NBTTagList tagList = nbtTags.func_150295_c("Items", NBT.TAG_COMPOUND);
		inventory = NonNullList.func_191197_a(2, ItemStack.field_190927_a);

		for(int tagCount = 0; tagCount < tagList.func_74745_c(); tagCount++)
		{
			NBTTagCompound tagCompound = (NBTTagCompound)tagList.func_150305_b(tagCount);
			byte slotID = tagCompound.func_74771_c("Slot");

			if(slotID >= 0 && slotID < 1)
			{
				inventory.set(slotID, InventoryUtils.loadFromNBT(tagCompound));
			}
		}
		
		temperature = nbtTags.func_74769_h("temperature");
	}

	@Override
	public void write(ArrayList data)
	{
		super.write(data);
		
		data.add(storedEnergy);
		
		if(storedFluid.getFluid() != null)
		{
			data.add(true);
			data.add(FluidRegistry.getFluidName(storedFluid.getFluid()));
			data.add(storedFluid.getFluidAmount());
		}
		else {
			data.add(false);
		}
		
		if(storedGas.getGas() != null)
		{
			data.add(true);
			data.add(storedGas.getGasType().getID());
			data.add(storedGas.getStored());
		}
		else {
			data.add(false);
		}
		
		data.add(temperature);
	}

	@Override
	protected void read(ByteBuf dataStream)
	{
		super.read(dataStream);
		
		storedFluid = new FluidTank(FLUID_TANK_SIZE);
		storedGas = new GasTank(GAS_TANK_SIZE);
		
		storedEnergy = dataStream.readDouble();
		
		if(dataStream.readBoolean())
		{
			storedFluid.setFluid(new FluidStack(FluidRegistry.getFluid(PacketHandler.readString(dataStream)), dataStream.readInt()));
		}
		else {
			storedFluid.setFluid(null);
		}
		
		if(dataStream.readBoolean())
		{
			storedGas.setGas(new GasStack(dataStream.readInt(), dataStream.readInt()));
		}
		else {
			storedGas.setGas(null);
		}
		
		temperature = dataStream.readDouble();
	}
}
