package mekanism.common.content.boiler;

import mekanism.common.multiblock.MultiblockCache;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class BoilerCache extends MultiblockCache<SynchronizedBoilerData>
{
	public FluidStack water;
	public FluidStack steam;
	
	public double temperature;

	@Override
	public void apply(SynchronizedBoilerData data)
	{
		data.waterStored = water;
		data.steamStored = steam;
		data.temperature = temperature;
	}

	@Override
	public void sync(SynchronizedBoilerData data)
	{
		water = data.waterStored;
		steam = data.steamStored;
		temperature = data.temperature;
	}

	@Override
	public void load(NBTTagCompound nbtTags)
	{
		if(nbtTags.func_74764_b("cachedWater"))
		{
			water = FluidStack.loadFluidStackFromNBT(nbtTags.func_74775_l("cachedWater"));
		}
		
		if(nbtTags.func_74764_b("cachedSteam"))
		{
			steam = FluidStack.loadFluidStackFromNBT(nbtTags.func_74775_l("cachedSteam"));
		}
		
		temperature = nbtTags.func_74769_h("temperature");
	}

	@Override
	public void save(NBTTagCompound nbtTags)
	{
		if(water != null)
		{
			nbtTags.func_74782_a("cachedWater", water.writeToNBT(new NBTTagCompound()));
		}
		
		if(steam != null)
		{
			nbtTags.func_74782_a("cachedSteam", steam.writeToNBT(new NBTTagCompound()));
		}
		
		nbtTags.func_74780_a("temperature", temperature);
	}
}
