package mekanism.common.content.assemblicator;

import java.util.ArrayList;
import java.util.List;

import mekanism.common.util.MekanismUtils;
import mekanism.common.util.RecipeUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class RecipeFormula 
{
	private InventoryCrafting dummy = MekanismUtils.getDummyCraftingInv();
	
	public NonNullList<ItemStack> input = NonNullList.func_191197_a(9, ItemStack.field_190927_a);
	
	public IRecipe recipe = null;
	
	public RecipeFormula(World world, NonNullList<ItemStack> inv)
	{
		this(world, inv, 0);
	}
	
	public RecipeFormula(World world, NonNullList<ItemStack> inv, int start)
	{
		for(int i = 0; i < 9; i++)
		{
			input.set(i, StackUtils.size(inv.get(start+i), 1));
		}
		
		resetToRecipe();
		
		recipe = RecipeUtils.getRecipeFromGrid(dummy, world);
	}
	
	private void resetToRecipe()
	{
		for(int i = 0; i < 9; i++)
		{
			dummy.func_70299_a(i, input.get(i));
		}
	}
	
	public boolean matches(World world, NonNullList<ItemStack> newInput, int start)
	{
		for(int i = 0; i < 9; i++)
		{
			dummy.func_70299_a(i, newInput.get(start+i));
		}
		
		return recipe.func_77569_a(dummy, world);
	}
	
	public boolean isIngredientInPos(World world, ItemStack stack, int i)
	{
		resetToRecipe();
		dummy.func_70299_a(i, stack);
		
		return recipe.func_77569_a(dummy, world);
	}
	
	public boolean isIngredient(World world, ItemStack stack)
	{
		for(int i = 0; i < 9; i++)
		{
			dummy.func_70299_a(i, stack);
			
			if(recipe.func_77569_a(dummy, world))
			{
				return true;
			}
			
			dummy.func_70299_a(i, input.get(i));
		}
		
		return false;
	}
	
	public List<Integer> getIngredientIndices(World world, ItemStack stack)
	{
		List<Integer> ret = new ArrayList<>();
		
		for(int i = 0; i < 9; i++)
		{
			dummy.func_70299_a(i, stack);
			
			if(recipe.func_77569_a(dummy, world))
			{
				ret.add(i);
			}
			
			dummy.func_70299_a(i, input.get(i));
		}
		
		return ret;
	}
	
	public boolean isValidFormula(World world)
	{
		return getRecipe(world) != null;
	}
	
	public IRecipe getRecipe(World world)
	{
		return recipe;
	}
	
	public boolean isFormulaEqual(World world, RecipeFormula formula)
	{
		return formula.getRecipe(world) == getRecipe(world);
	}
}
