package mekanism.common.block;

import static mekanism.common.block.states.BlockStatePlastic.colorProperty;
import mekanism.api.EnumColor;
import mekanism.common.Mekanism;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPlasticFence extends BlockFence
{
	public BlockPlasticFence()
	{
		super(Material.field_151571_B, Material.field_151571_B.func_151565_r());
		func_149647_a(Mekanism.tabMekanism);
	}
	
	@Override
	protected BlockStateContainer func_180661_e()
	{
		return new BlockStateContainer(this, new IProperty[] {field_176526_a, field_176525_b, field_176528_N, field_176527_M, colorProperty});
	}

	@Override
	public IBlockState func_176203_a(int meta)
	{
		return this.func_176223_P().func_177226_a(colorProperty, EnumDyeColor.func_176766_a(meta));
	}

	@Override
	public int func_176201_c(IBlockState state)
	{
		return state.func_177229_b(colorProperty).func_176767_b();
	}

    @Override
    @SideOnly(Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativetabs, NonNullList<ItemStack> list)
    {
        for(int i = 0; i < EnumColor.DYES.length; i++)
        {
            list.add(new ItemStack(item, 1, i));
        }
    }

	@Override
	public int func_180651_a(IBlockState state)
	{
		return func_176201_c(state);
	}
	
	public static class PlasticFenceStateMapper extends StateMapperBase
	{
		@Override
		protected ModelResourceLocation func_178132_a(IBlockState state)
		{
			String properties = "east=" + state.func_177229_b(field_176525_b) + ",";
			properties += "north=" + state.func_177229_b(field_176526_a) + ",";
			properties += "south=" + state.func_177229_b(field_176527_M) + ",";
			properties += "west=" + state.func_177229_b(field_176528_N);
			ResourceLocation baseLocation = new ResourceLocation("mekanism", "PlasticFence");
			return new ModelResourceLocation(baseLocation, properties);
		}
	}
}
