package mekanism.common.block;

import mekanism.api.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.block.states.BlockStatePlastic;
import mekanism.common.block.states.BlockStatePlastic.PlasticBlockType;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPlastic extends Block
{
	public PlasticBlockType type;
	
	public BlockPlastic(PlasticBlockType blockType)
	{
		super(Material.field_151575_d);
		type = blockType;
		func_149711_c(type == PlasticBlockType.REINFORCED ? 50F : 5F);
		func_149752_b(type == PlasticBlockType.REINFORCED ? 2000F : 10F);
		func_149647_a(Mekanism.tabMekanism);
		
		if(type == PlasticBlockType.SLICK)
		{
			field_149765_K = 0.98F;
		}
	}

	@Override
	protected BlockStateContainer func_180661_e()
	{
		return new BlockStatePlastic(this);
	}

	@Override
	public IBlockState func_176203_a(int meta)
	{
		return func_176223_P().func_177226_a(BlockStatePlastic.colorProperty, EnumDyeColor.func_176766_a(meta));
	}

	@Override
	public int func_176201_c(IBlockState state)
	{
		return state.func_177229_b(BlockStatePlastic.colorProperty).func_176767_b();
	}
	
	@Override
	public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn)
    {
		if(type == PlasticBlockType.ROAD)
		{
			double boost = 1.6;
			double a = Math.atan2(entityIn.field_70159_w, entityIn.field_70179_y);
			entityIn.field_70159_w += Math.sin(a) * boost * field_149765_K;
			entityIn.field_70179_y += Math.cos(a) * boost * field_149765_K;
		}
    }

	@Override
	public int func_180651_a(IBlockState state)
	{
		return func_176201_c(state);
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_149666_a(Item item, CreativeTabs creativetabs, NonNullList<ItemStack> list)
	{
		for(int i = 0; i < EnumColor.DYES.length; i++)
		{
			list.add(new ItemStack(item, 1, i));
		}
	}

	@Override
	public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos)
	{
		if(type == PlasticBlockType.GLOW)
		{
			return 10;
		}
		
		return 0;
	}
}
