package mekanism.common.block;

import mekanism.common.Mekanism;
import mekanism.common.block.states.BlockStateOre;
import mekanism.common.block.states.BlockStateOre.EnumOreType;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

/**
 * Block class for handling multiple ore block IDs.
 * 0: Osmium Ore
 * 1: Copper Ore
 * 2: Tin Ore
 * @author AidanBrady
 *
 */
public class BlockOre extends Block
{
	public BlockOre()
	{
		super(Material.field_151576_e);
		func_149711_c(3F);
		func_149752_b(5F);
		func_149647_a(Mekanism.tabMekanism);
	}

	@Override
	protected BlockStateContainer func_180661_e()
	{
		return new BlockStateOre(this);
	}

	@Override
	public IBlockState func_176203_a(int meta)
	{
		return func_176223_P().func_177226_a(BlockStateOre.typeProperty, EnumOreType.values()[meta]);
	}

	@Override
	public int func_176201_c(IBlockState state)
	{
		return state.func_177229_b(BlockStateOre.typeProperty).ordinal();
	}

	@Override
	public int func_180651_a(IBlockState state)
	{
		return func_176201_c(state);
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_149666_a(Item item, CreativeTabs creativetabs, NonNullList<ItemStack> list)
	{
		for(EnumOreType ore : EnumOreType.values())
		{
			list.add(new ItemStack(item, 1, ore.ordinal()));
		}
	}
}
