package mekanism.common.block;

import java.util.Random;

import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.block.property.PropertyColor;
import mekanism.common.block.states.BlockStateFacing;
import mekanism.common.block.states.BlockStateGlowPanel;
import mekanism.common.integration.multipart.MultipartMekanism;
import mekanism.common.tile.TileEntityGlowPanel;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MultipartUtils;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGlowPanel extends Block implements ITileEntityProvider
{
	private static Random rand = new Random();
	public static AxisAlignedBB[] bounds = new AxisAlignedBB[6];

	static
	{
		AxisAlignedBB cuboid = new AxisAlignedBB(0.25, 0, 0.25, 0.75, 0.125, 0.75);
		Vec3d fromOrigin = new Vec3d(-0.5, -0.5, -0.5);

		for(EnumFacing side : EnumFacing.field_82609_l)
		{
			bounds[side.ordinal()] = MultipartUtils.rotate(cuboid.func_72317_d(fromOrigin.field_72450_a, fromOrigin.field_72448_b, fromOrigin.field_72449_c), side).func_72317_d(-fromOrigin.field_72450_a, -fromOrigin.field_72449_c, -fromOrigin.field_72449_c);
		}
	}
	
	public BlockGlowPanel() 
	{
        super(Material.field_76233_E);
        func_149647_a(Mekanism.tabMekanism);
        func_149711_c(1F);
        func_149752_b(10F);
    }
	
	@Override
	public int func_176201_c(IBlockState state)
    {
		return 0;
    }
	
	@Override
	public BlockStateContainer func_180661_e()
	{
		return new BlockStateGlowPanel(this);
	}
	
	@Override
	public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos)
	{
		TileEntityGlowPanel tileEntity = getTileEntityGlowPanel(world, pos);
		return tileEntity != null ? state.func_177226_a(BlockStateFacing.facingProperty, tileEntity.side) : state;
	}

	@SideOnly(Side.CLIENT)
    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) 
	{
		TileEntityGlowPanel tileEntity = getTileEntityGlowPanel(world, pos);
		
		if(tileEntity != null)
		{
			state = state.func_177226_a(BlockStateFacing.facingProperty, tileEntity.side);
			
			if(state instanceof IExtendedBlockState)
			{
				return ((IExtendedBlockState)state).withProperty(PropertyColor.INSTANCE, new PropertyColor(tileEntity.colour));
			}
		}
		
		return state;
	}
	
	@Override
	public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos neighbor)
	{
		TileEntityGlowPanel tileEntity = getTileEntityGlowPanel(world, pos);
		
		if(tileEntity != null && !world.field_72995_K && !canStay(world, pos))
		{
			float motion = 0.7F;
			double motionX = (rand.nextFloat() * motion) + (1.0F - motion) * 0.5D;
			double motionY = (rand.nextFloat() * motion) + (1.0F - motion) * 0.5D;
			double motionZ = (rand.nextFloat() * motion) + (1.0F - motion) * 0.5D;

			ItemStack stack = new ItemStack(MekanismBlocks.GlowPanel, 1, tileEntity.colour.getMetaValue());
			EntityItem entityItem = new EntityItem(world, pos.func_177958_n() + motionX, pos.func_177956_o() + motionY, pos.func_177952_p() + motionZ, stack);

			world.func_72838_d(entityItem);
			world.func_175698_g(pos);
		}
	}
	
	@Override
	public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor)
	{
		TileEntityGlowPanel tileEntity = getTileEntityGlowPanel(world, pos);
		
		if(tileEntity != null && !tileEntity.func_145831_w().field_72995_K && !canStay(world, pos))
		{
			float motion = 0.7F;
			double motionX = (rand.nextFloat() * motion) + (1.0F - motion) * 0.5D;
			double motionY = (rand.nextFloat() * motion) + (1.0F - motion) * 0.5D;
			double motionZ = (rand.nextFloat() * motion) + (1.0F - motion) * 0.5D;

			ItemStack stack = new ItemStack(MekanismBlocks.GlowPanel, 1, tileEntity.colour.getMetaValue());
			EntityItem entityItem = new EntityItem(tileEntity.func_145831_w(), pos.func_177958_n() + motionX, pos.func_177956_o() + motionY, pos.func_177952_p() + motionZ, stack);

			tileEntity.func_145831_w().func_72838_d(entityItem);
			tileEntity.func_145831_w().func_175698_g(pos);
		}
	}
	
	@Override
	public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos)
	{
		TileEntityGlowPanel tileEntity = getTileEntityGlowPanel(world, pos);
		
		if(tileEntity != null)
		{
			return bounds[tileEntity.side.ordinal()];
		}
		
		return super.func_185496_a(state, world, pos);
	}
	
	@Override
	public boolean func_176198_a(World world, BlockPos pos, EnumFacing side)
    {
		return world.isSideSolid(pos.func_177972_a(side.func_176734_d()), side);
    }
	
	public static boolean canStay(IBlockAccess world, BlockPos pos)
	{
		boolean canStay = false;
		
		if(Mekanism.hooks.MCMPLoaded)
		{
			canStay = MultipartMekanism.hasCenterSlot(world, pos);
		}
		
		if(!canStay)
		{
			TileEntity tileEntity = world.func_175625_s(pos);
			if(tileEntity instanceof TileEntityGlowPanel)
			{
				TileEntityGlowPanel glowPanel = (TileEntityGlowPanel)tileEntity;
				Coord4D adj = new Coord4D(glowPanel.func_174877_v().func_177972_a(glowPanel.side), glowPanel.func_145831_w());
				canStay = glowPanel.func_145831_w().isSideSolid(adj.getPos(), glowPanel.side.func_176734_d());
			}
		}
		
		return canStay;
	}
	
	@Override
	public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos)
    {
		return 15;
    }
	
	@Override
	public int func_149745_a(Random random)
    {
		return 0;
    }
	
	@Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player)
	{
		TileEntityGlowPanel tileEntity = (TileEntityGlowPanel)world.func_175625_s(pos);
		return new ItemStack(MekanismBlocks.GlowPanel, 1, tileEntity.colour.getMetaValue());
	}

	@Override
	public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest)
	{
		if(!player.field_71075_bZ.field_75098_d && !world.field_72995_K && willHarvest)
		{
			float motion = 0.7F;
			double motionX = (world.field_73012_v.nextFloat() * motion) + (1.0F - motion) * 0.5D;
			double motionY = (world.field_73012_v.nextFloat() * motion) + (1.0F - motion) * 0.5D;
			double motionZ = (world.field_73012_v.nextFloat() * motion) + (1.0F - motion) * 0.5D;

			EntityItem entityItem = new EntityItem(world, pos.func_177958_n() + motionX, pos.func_177956_o() + motionY, pos.func_177952_p() + motionZ, getPickBlock(state, null, world, pos, player));

			world.func_72838_d(entityItem);
		}

		return super.removedByPlayer(state, world, pos, player, willHarvest);
	}
	
	@Override
	public TileEntity func_149915_a(World worldIn, int meta)
	{
		return new TileEntityGlowPanel();
	}
	
	@Override
	public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer)
	{
		return true;
	}
	
	@Override
    public EnumBlockRenderType func_149645_b(IBlockState state) 
	{
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public boolean func_149637_q(IBlockState state) 
    {
        return false;
    }

    @Override
    public boolean func_149662_c(IBlockState state) 
    {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state)
    {
        return false;
    }

    @Override
    public boolean func_149730_j(IBlockState state)
    {
        return false;
    }
    
    private static TileEntityGlowPanel getTileEntityGlowPanel(IBlockAccess world, BlockPos pos)
    {
    	TileEntity tileEntity = MekanismUtils.getTileEntitySafe(world, pos);
    	TileEntityGlowPanel glowPanel = null;
    	if(tileEntity instanceof TileEntityGlowPanel)
    	{
    		glowPanel = (TileEntityGlowPanel)tileEntity;
    	}
    	else if(Mekanism.hooks.MCMPLoaded)
    	{
    		TileEntity childEntity = MultipartMekanism.unwrapTileEntity(world);
    		if(childEntity instanceof TileEntityGlowPanel)
    		{
    			glowPanel = (TileEntityGlowPanel)childEntity;
    		}
    	}
    	
    	return glowPanel;
    }
}
