package mekanism.common.block;

import java.util.Random;

import mekanism.api.gas.IGasItem;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.base.ITierItem;
import mekanism.common.block.states.BlockStateFacing;
import mekanism.common.block.states.BlockStateGasTank;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.tile.prefab.TileEntityBasicBlock;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import buildcraft.api.tools.IToolWrench;

public class BlockGasTank extends BlockContainer
{
	private static final AxisAlignedBB TANK_BOUNDS = new AxisAlignedBB(0.1875F, 0.0F, 0.1875F, 0.8125F, 1.0F, 0.8125F);

	public BlockGasTank()
	{
		super(Material.field_151573_f);
		func_149711_c(3.5F);
		func_149752_b(8F);
		func_149647_a(Mekanism.tabMekanism);
	}

	@Override
	protected BlockStateContainer func_180661_e()
	{
		return new BlockStateGasTank(this);
	}

	@Override
	public IBlockState func_176203_a(int meta)
	{
		return func_176223_P();
	}

	@Override
	public int func_176201_c(IBlockState state)
	{
		return 0;
	}

	@Override
	public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos)
	{
		TileEntity tile = MekanismUtils.getTileEntitySafe(worldIn, pos);
		
		if(tile instanceof TileEntityGasTank)
		{
			TileEntityGasTank tank = (TileEntityGasTank)tile;
			
			if(tank.facing != null)
			{
				state = state.func_177226_a(BlockStateFacing.facingProperty, tank.facing);
			}

			if(tank.tier != null)
			{
				state = state.func_177226_a(BlockStateGasTank.typeProperty, tank.tier);
			}
		}
		
		return state;
	}

	@Override
	public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack)
	{
		TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_175625_s(pos);

		int side = MathHelper.func_76128_c((double)(placer.field_70177_z * 4.0F / 360.0F) + 0.5D) & 3;
		int change = 3;

		switch(side)
		{
			case 0: change = 2; break;
			case 1: change = 5; break;
			case 2: change = 3; break;
			case 3: change = 4; break;
		}

		tileEntity.setFacing((short)change);
		tileEntity.redstone = world.func_175687_A(pos) > 0;
	}

	@Override
	public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighborPos)
	{
		if(!world.field_72995_K)
		{
			TileEntity tileEntity = world.func_175625_s(pos);

			if(tileEntity instanceof TileEntityBasicBlock)
			{
				((TileEntityBasicBlock)tileEntity).onNeighborChange(neighborBlock);
			}
		}
	}
	
	@Override
	public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos)
	{
		TileEntity tile = world.func_175625_s(pos);
		
		return SecurityUtils.canAccess(player, tile) ? super.func_180647_a(state, player, world, pos) : 0.0F;
	}

	@Override
	public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ)
	{
		if(world.field_72995_K)
		{
			return true;
		}

		TileEntityGasTank tileEntity = (TileEntityGasTank)world.func_175625_s(pos);
		ItemStack stack = entityplayer.func_184586_b(hand);

		if(!stack.func_190926_b())
		{
			Item tool = stack.func_77973_b();

			if(MekanismUtils.hasUsableWrench(entityplayer, pos))
			{
				if(SecurityUtils.canAccess(entityplayer, tileEntity))
				{
					if(entityplayer.func_70093_af())
					{
						dismantleBlock(state, world, pos, false);
						
						return true;
					}
	
					if(MekanismUtils.isBCWrench(tool))
					{
						((IToolWrench)tool).wrenchUsed(entityplayer, hand, stack, new RayTraceResult(new Vec3d(hitX, hitY, hitZ), side, pos));
					}
	
					int change = tileEntity.facing.func_176746_e().ordinal();
	
					tileEntity.setFacing((short)change);
					world.func_175685_c(pos, this, true);
				}
				else {
					SecurityUtils.displayNoAccess(entityplayer);
				}
				
				return true;
			}
		}

		if(tileEntity != null)
		{
			if(!entityplayer.func_70093_af())
			{
				if(SecurityUtils.canAccess(entityplayer, tileEntity))
				{
					entityplayer.openGui(Mekanism.instance, 10, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
				}
				else {
					SecurityUtils.displayNoAccess(entityplayer);
				}
				
				return true;
			}
		}
		
		return false;
	}

	@Override
	public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest)
	{
		if(!player.field_71075_bZ.field_75098_d && !world.field_72995_K && willHarvest)
		{
			float motion = 0.7F;
			double motionX = (world.field_73012_v.nextFloat() * motion) + (1.0F - motion) * 0.5D;
			double motionY = (world.field_73012_v.nextFloat() * motion) + (1.0F - motion) * 0.5D;
			double motionZ = (world.field_73012_v.nextFloat() * motion) + (1.0F - motion) * 0.5D;

			EntityItem entityItem = new EntityItem(world, pos.func_177958_n() + motionX, pos.func_177956_o() + motionY, pos.func_177952_p() + motionZ, getPickBlock(state, null, world, pos, player));

			world.func_72838_d(entityItem);
		}

		return world.func_175698_g(pos);
	}

	public ItemStack dismantleBlock(IBlockState state, World world, BlockPos pos, boolean returnBlock)
	{
		ItemStack itemStack = getPickBlock(state, null, world, pos, null);

		world.func_175698_g(pos);

		if(!returnBlock)
		{
			float motion = 0.7F;
			double motionX = (world.field_73012_v.nextFloat() * motion) + (1.0F - motion) * 0.5D;
			double motionY = (world.field_73012_v.nextFloat() * motion) + (1.0F - motion) * 0.5D;
			double motionZ = (world.field_73012_v.nextFloat() * motion) + (1.0F - motion) * 0.5D;

			EntityItem entityItem = new EntityItem(world, pos.func_177958_n() + motionX, pos.func_177956_o() + motionY, pos.func_177952_p() + motionZ, itemStack);

			world.func_72838_d(entityItem);
		}

		return itemStack;
	}

	@Override
	public int func_149745_a(Random random)
	{
		return 0;
	}

	@Override
	public Item func_180660_a(IBlockState state, Random random, int fortune)
	{
		return null;
	}

	@Override
	public boolean func_149662_c(IBlockState state)
	{
		return false;
	}

	@Override
	public EnumBlockRenderType func_149645_b(IBlockState state)
	{
		return EnumBlockRenderType.MODEL;
	}
	
	@Override
	public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos)
	{
		return TANK_BOUNDS;
	}

	@Override
	public TileEntity func_149915_a(World world, int meta)
	{
		return new TileEntityGasTank();
	}

	@Override
	public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player)
	{
		TileEntityGasTank tileEntity = (TileEntityGasTank)world.func_175625_s(pos);
		ItemStack itemStack = new ItemStack(MekanismBlocks.GasTank);
		
		if(itemStack.func_77942_o())
		{
			itemStack.func_77982_d(new NBTTagCompound());
		}
		
		if(tileEntity instanceof ISecurityTile)
		{
			ISecurityItem securityItem = (ISecurityItem)itemStack.func_77973_b();
			
			if(securityItem.hasSecurity(itemStack))
			{
				securityItem.setOwnerUUID(itemStack, ((ISecurityTile)tileEntity).getSecurity().getOwnerUUID());
				securityItem.setSecurity(itemStack, ((ISecurityTile)tileEntity).getSecurity().getMode());
			}
		}
		
		if(tileEntity instanceof ISideConfiguration)
		{
			ISideConfiguration config = (ISideConfiguration)tileEntity;

			config.getConfig().write(ItemDataUtils.getDataMap(itemStack));
			config.getEjector().write(ItemDataUtils.getDataMap(itemStack));
		}
		
		ITierItem tierItem = (ITierItem)itemStack.func_77973_b();
		tierItem.setBaseTier(itemStack, tileEntity.tier.getBaseTier());

		IGasItem storageTank = (IGasItem)itemStack.func_77973_b();
		storageTank.setGas(itemStack, tileEntity.gasTank.getGas());

		ISustainedInventory inventory = (ISustainedInventory)itemStack.func_77973_b();
		inventory.setInventory(tileEntity.getInventory(), itemStack);

		return itemStack;
	}

	@Override
	public boolean func_149740_M(IBlockState state)
	{
		return true;
	}

	@Override
	public int func_180641_l(IBlockState state, World world, BlockPos pos)
	{
		TileEntityGasTank tileEntity = (TileEntityGasTank)world.func_175625_s(pos);
		return tileEntity.getRedstoneLevel();
	}
	
	@Override
	public EnumFacing[] getValidRotations(World world, BlockPos pos)
	{
		TileEntity tile = world.func_175625_s(pos);
		EnumFacing[] valid = new EnumFacing[6];
		
		if(tile instanceof TileEntityBasicBlock)
		{
			TileEntityBasicBlock basicTile = (TileEntityBasicBlock)tile;
			
			for(EnumFacing dir : EnumFacing.field_82609_l)
			{
				if(basicTile.canSetFacing(dir.ordinal()))
				{
					valid[dir.ordinal()] = dir;
				}
			}
		}
		
		return valid;
	}

	@Override
	public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis)
	{
		TileEntity tile = world.func_175625_s(pos);
		
		if(tile instanceof TileEntityBasicBlock)
		{
			TileEntityBasicBlock basicTile = (TileEntityBasicBlock)tile;
			
			if(basicTile.canSetFacing(axis.ordinal()))
			{
				basicTile.setFacing((short)axis.ordinal());
				return true;
			}
		}
		
		return false;
	}

	@Override
	public boolean func_149730_j(IBlockState state) 
	{
		return false;
	}

	@Override
	public boolean func_149686_d(IBlockState state) 
	{
		return false;
	}

	@Override
	public boolean func_176212_b(IBlockAccess worldIn, BlockPos pos, EnumFacing side)
	{
		return false;
	}
}
