package mekanism.common.block;

import static mekanism.common.block.states.BlockStateCardboardBox.storageProperty;

import java.util.Random;

import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.block.states.BlockStateCardboardBox;
import mekanism.common.item.ItemBlockCardboardBox;
import mekanism.common.tile.TileEntityCardboardBox;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCardboardBox extends BlockContainer
{
	private static boolean testingPlace = false;
	
	public BlockCardboardBox()
	{
		super(Material.field_151580_n);
		func_149647_a(Mekanism.tabMekanism);
		func_149711_c(0.5F);
		func_149752_b(1F);
	}
	
	@Override
	protected BlockStateContainer func_180661_e()
	{
		return new BlockStateCardboardBox(this);
	}

	@Override
	public IBlockState func_176203_a(int meta)
	{
		return func_176223_P().func_177226_a(storageProperty, meta == 1);
	}

	@Override
	public int func_176201_c(IBlockState state)
	{
		return state.func_177229_b(storageProperty) == true ? 1 : 0;
	}

	@Override
	public boolean func_176200_f(IBlockAccess world, BlockPos pos)
	{
		return testingPlace;
	}

	@Override
	public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ)
	{
		if(!world.field_72995_K && entityplayer.func_70093_af())
		{
			ItemStack itemStack = new ItemStack(MekanismBlocks.CardboardBox);
			TileEntityCardboardBox tileEntity = (TileEntityCardboardBox)world.func_175625_s(pos);

			if(tileEntity.storedData != null)
			{
				BlockData data = tileEntity.storedData;
				
				testingPlace = true;
				
				if(!data.block.func_176196_c(world, pos))
				{
					testingPlace = false;
					return true;
				}
				
				testingPlace = false;

				if(data.block != null)
				{
					IBlockState newstate = data.block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, data.meta, entityplayer, hand);
					data.meta = newstate.func_177230_c().func_176201_c(newstate);
				}

				world.func_180501_a(pos, data.block.func_176203_a(data.meta), 3);

				if(data.tileTag != null && world.func_175625_s(pos) != null)
				{
					data.updateLocation(pos);
					world.func_175625_s(pos).func_145839_a(data.tileTag);
				}

				if(data.block != null)
				{
					data.block.func_180633_a(world, pos, data.block.func_176203_a(data.meta), entityplayer, new ItemStack(data.block, 1, data.meta));
				}
				
				float motion = 0.7F;
				double motionX = (world.field_73012_v.nextFloat() * motion) + (1.0F - motion) * 0.5D;
				double motionY = (world.field_73012_v.nextFloat() * motion) + (1.0F - motion) * 0.5D;
				double motionZ = (world.field_73012_v.nextFloat() * motion) + (1.0F - motion) * 0.5D;

				EntityItem entityItem = new EntityItem(world, pos.func_177958_n() + motionX, pos.func_177956_o() + motionY, pos.func_177952_p() + motionZ, itemStack);

				world.func_72838_d(entityItem);
			}
		}

		return false;
	}
	
	@Override
	public EnumBlockRenderType func_149645_b(IBlockState state)
	{
		return EnumBlockRenderType.MODEL;
	}

	@Override
	public TileEntity func_149915_a(World world, int meta)
	{
		return new TileEntityCardboardBox();
	}

	public ItemStack dismantleBlock(IBlockState state, World world, BlockPos pos, boolean returnBlock)
	{
		ItemStack itemStack = getPickBlock(state, null, world, pos, null);

		world.func_175698_g(pos);

		if(!returnBlock)
		{
			float motion = 0.7F;
			double motionX = (world.field_73012_v.nextFloat() * motion) + (1.0F - motion) * 0.5D;
			double motionY = (world.field_73012_v.nextFloat() * motion) + (1.0F - motion) * 0.5D;
			double motionZ = (world.field_73012_v.nextFloat() * motion) + (1.0F - motion) * 0.5D;

			EntityItem entityItem = new EntityItem(world, pos.func_177958_n() + motionX, pos.func_177956_o() + motionY, pos.func_177952_p() + motionZ, itemStack);

			world.func_72838_d(entityItem);
		}

		return itemStack;
	}

	@Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player)
	{
		TileEntityCardboardBox tileEntity = (TileEntityCardboardBox)world.func_175625_s(pos);

		ItemStack itemStack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));

		if(itemStack.func_77952_i() == 1)
		{
			if(tileEntity.storedData != null)
			{
				((ItemBlockCardboardBox)itemStack.func_77973_b()).setBlockData(itemStack, tileEntity.storedData);
			}
		}

		return itemStack;
	}

	@Override
	public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest)
	{
		if(!player.field_71075_bZ.field_75098_d && !world.field_72995_K && willHarvest)
		{
			float motion = 0.7F;
			double motionX = (world.field_73012_v.nextFloat() * motion) + (1.0F - motion) * 0.5D;
			double motionY = (world.field_73012_v.nextFloat() * motion) + (1.0F - motion) * 0.5D;
			double motionZ = (world.field_73012_v.nextFloat() * motion) + (1.0F - motion) * 0.5D;

			EntityItem entityItem = new EntityItem(world, pos.func_177958_n() + motionX, pos.func_177956_o() + motionY, pos.func_177952_p() + motionZ, getPickBlock(state, null, world, pos, player));

			world.func_72838_d(entityItem);
		}

		return world.func_175698_g(pos);
	}

	@Override
	public int func_149745_a(Random random)
	{
		return 0;
	}

	@Override
	public Item func_180660_a(IBlockState state, Random random, int fortune)
	{
		return null;
	}

	public static class BlockData
	{
		public Block block;
		public int meta;
		public NBTTagCompound tileTag;

		public BlockData(Block b, int j, NBTTagCompound nbtTags)
		{
			block = b;
			meta = j;
			tileTag = nbtTags;
		}

		public BlockData() {}

		public void updateLocation(BlockPos pos)
		{
			if(tileTag != null)
			{
				tileTag.func_74768_a("x", pos.func_177958_n());
				tileTag.func_74768_a("y", pos.func_177956_o());
				tileTag.func_74768_a("z", pos.func_177952_p());
			}
		}

		public NBTTagCompound write(NBTTagCompound nbtTags)
		{
			nbtTags.func_74768_a("id", Block.func_149682_b(block));
			nbtTags.func_74768_a("meta", meta);

			if(tileTag != null)
			{
				nbtTags.func_74782_a("tileTag", tileTag);
			}

			return nbtTags;
		}

		public static BlockData read(NBTTagCompound nbtTags)
		{
			BlockData data = new BlockData();

			data.block = Block.func_149729_e(nbtTags.func_74762_e("id"));
			data.meta = nbtTags.func_74762_e("meta");

			if(nbtTags.func_74764_b("tileTag"))
			{
				data.tileTag = nbtTags.func_74775_l("tileTag");
			}

			return data;
		}
	}
}
