package mekanism.common;

import mekanism.api.gas.GasStack;
import mekanism.common.entity.EntityFlame;
import mekanism.common.item.ItemFlamethrower;
import mekanism.common.item.ItemFreeRunners;
import mekanism.common.item.ItemGasMask;
import mekanism.common.item.ItemJetpack;
import mekanism.common.item.ItemJetpack.JetpackMode;
import mekanism.common.item.ItemScubaTank;
import mekanism.common.util.ReflectionUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent.Phase;
import net.minecraftforge.fml.common.gameevent.TickEvent.PlayerTickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class CommonPlayerTickHandler
{
	@SubscribeEvent
	public void onTick(PlayerTickEvent event)
	{
		if(event.phase == Phase.END && event.side == Side.SERVER)
		{
			tickEnd(event.player);
		}
	}

	public void tickEnd(EntityPlayer player)
	{
		ItemStack feetStack = player.func_184582_a(EntityEquipmentSlot.FEET);
		
		if(!feetStack.func_190926_b() && feetStack.func_77973_b() instanceof ItemFreeRunners)
		{
			player.field_70138_W = 1.002F;
		}
		else {
			if(player.field_70138_W == 1.002F)
			{
				player.field_70138_W = 0.5F;
			}
		}
		
		if(isFlamethrowerOn(player))
		{
			player.field_70170_p.func_72838_d(new EntityFlame(player));
			
			if(!player.field_71075_bZ.field_75098_d)
			{
				((ItemFlamethrower)player.field_71071_by.func_70448_g().func_77973_b()).useGas(player.field_71071_by.func_70448_g());
			}
		}

		if(isJetpackOn(player))
		{
			ItemStack stack = player.func_184582_a(EntityEquipmentSlot.CHEST);
			ItemJetpack jetpack = (ItemJetpack)stack.func_77973_b();

			if(jetpack.getMode(stack) == JetpackMode.NORMAL)
			{
				player.field_70181_x = Math.min(player.field_70181_x + 0.15D, 0.5D);
			}
			else if(jetpack.getMode(stack) == JetpackMode.HOVER)
			{
				if((!Mekanism.keyMap.has(player, KeySync.ASCEND) && !Mekanism.keyMap.has(player, KeySync.DESCEND)) || (Mekanism.keyMap.has(player, KeySync.ASCEND) && Mekanism.keyMap.has(player, KeySync.DESCEND)))
				{
					if(player.field_70181_x > 0)
					{
						player.field_70181_x = Math.max(player.field_70181_x - 0.15D, 0);
					}
					else if(player.field_70181_x < 0)
					{
						if(!isOnGround(player))
						{
							player.field_70181_x = Math.min(player.field_70181_x + 0.15D, 0);
						}
					}
				}
				else {
					if(Mekanism.keyMap.has(player, KeySync.ASCEND))
					{
						player.field_70181_x = Math.min(player.field_70181_x + 0.15D, 0.2D);
					}
					else if(Mekanism.keyMap.has(player, KeySync.DESCEND))
					{
						if(!isOnGround(player))
						{
							player.field_70181_x = Math.max(player.field_70181_x - 0.15D, -0.2D);
						}
					}
				}
			}

			player.field_70143_R = 0.0F;

			if(player instanceof EntityPlayerMP)
			{
				ReflectionUtils.setPrivateValue(((EntityPlayerMP)player).field_71135_a, 0, NetHandlerPlayServer.class, ObfuscatedNames.NetHandlerPlayServer_floatingTickCount);
			}

			jetpack.useGas(stack);
		}

		if(isGasMaskOn(player))
		{
			ItemStack stack = player.func_184582_a(EntityEquipmentSlot.CHEST);
			ItemScubaTank tank = (ItemScubaTank)stack.func_77973_b();

			final int max = 300;
			
			tank.useGas(stack);
			GasStack received = tank.useGas(stack, max-player.func_70086_ai());
			
			if(received != null)
			{
				player.func_70050_g(player.func_70086_ai()+received.amount);
			}
			
			if(player.func_70086_ai() == max)
			{
				for(Object obj : player.func_70651_bq())
				{
					if(obj instanceof PotionEffect)
					{
						for(int i = 0; i < 9; i++)
						{
							((PotionEffect)obj).func_76455_a(player);
						}
					}
				}
			}
		}
	}
	
	public static boolean isOnGround(EntityPlayer player)
	{
		int x = MathHelper.func_76128_c(player.field_70165_t);
		int y = MathHelper.func_76128_c(player.field_70163_u-0.01);
		int z = MathHelper.func_76128_c(player.field_70161_v);
		
		BlockPos pos = new BlockPos(x, y, z);
		IBlockState s = player.field_70170_p.func_180495_p(pos);
		AxisAlignedBB box = s.func_185900_c(player.field_70170_p, pos).func_186670_a(pos);
		AxisAlignedBB playerBox = player.func_174813_aQ();
		
		if(!s.func_177230_c().isAir(s, player.field_70170_p, pos) && playerBox.func_72317_d(0, -0.01, 0).func_72326_a(box))
		{
			return true;
		}
		
		return false;
	}

	public boolean isJetpackOn(EntityPlayer player)
	{
		ItemStack stack = player.field_71071_by.field_70460_b.get(2);

		if(!stack.func_190926_b() && !player.field_71075_bZ.field_75098_d)
		{
			if(stack.func_77973_b() instanceof ItemJetpack)
			{
				ItemJetpack jetpack = (ItemJetpack)stack.func_77973_b();

				if(jetpack.getGas(stack) != null)
				{
					if((Mekanism.keyMap.has(player, KeySync.ASCEND) && jetpack.getMode(stack) == JetpackMode.NORMAL))
					{
						return true;
					}
					else if(jetpack.getMode(stack) == JetpackMode.HOVER)
					{
						if((!Mekanism.keyMap.has(player, KeySync.ASCEND) && !Mekanism.keyMap.has(player, KeySync.DESCEND)) || (Mekanism.keyMap.has(player, KeySync.ASCEND) && Mekanism.keyMap.has(player, KeySync.DESCEND)))
						{
							return !isOnGround(player);
						}
						else if(Mekanism.keyMap.has(player, KeySync.DESCEND))
						{
							return !isOnGround(player);
						}
						
						return true;
					}
				}
			}
		}

		return false;
	}

	public static boolean isGasMaskOn(EntityPlayer player)
	{
		ItemStack tank = player.field_71071_by.field_70460_b.get(2);
		ItemStack mask = player.field_71071_by.field_70460_b.get(3);

		if(!tank.func_190926_b() && !mask.func_190926_b())
		{
			if(tank.func_77973_b() instanceof ItemScubaTank && mask.func_77973_b() instanceof ItemGasMask)
			{
				ItemScubaTank scubaTank = (ItemScubaTank)tank.func_77973_b();

				if(scubaTank.getGas(tank) != null)
				{
					if(scubaTank.getFlowing(tank))
					{
						return true;
					}
				}
			}
		}

		return false;
	}
	
	public static boolean isFlamethrowerOn(EntityPlayer player)
	{
		if(Mekanism.flamethrowerActive.contains(player.func_70005_c_()))
		{
			if(!player.field_71071_by.func_70448_g().func_190926_b() && player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemFlamethrower)
			{
				return true;
			}
		}
		
		return false;
	}
}
