package mekanism.common;

import java.util.Arrays;
import java.util.List;

import mekanism.api.EnumColor;
import mekanism.api.MekanismAPI;
import mekanism.common.config.MekanismConfig.general;
import mekanism.common.util.MekanismUtils;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class CommandMekanism extends CommandBase
{
	@Override
	public boolean func_184882_a(MinecraftServer server, ICommandSender sender)
	{
		return server.func_71264_H() || super.func_184882_a(server, sender);
	}

	@Override
	public String func_71517_b()
	{
		return "mk";
	}

	@Override
	public String func_71518_a(ICommandSender sender)
	{
		return "/mk <parameters>";
	}

	@Override
	public List func_71514_a()
	{
		return Arrays.asList(new String[] {"mekanism", "mek"});
	}

	@Override
	public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] params)
	{
		if(params.length < 1)
		{
			sender.func_145747_a(new TextComponentString(EnumColor.GREY + "------------- " + EnumColor.DARK_BLUE + "[Mekanism]" + EnumColor.GREY + " -------------"));
			sender.func_145747_a(new TextComponentString(EnumColor.GREY + " *Version: " + EnumColor.DARK_GREY + Mekanism.versionNumber));
			sender.func_145747_a(new TextComponentString(EnumColor.GREY + " *Latest Version: " + EnumColor.DARK_GREY + Mekanism.latestVersionNumber));
			sender.func_145747_a(new TextComponentString(EnumColor.GREY + " *Developed on Mac OS X 10.8 Mountain Lion"));
			sender.func_145747_a(new TextComponentString(EnumColor.GREY + " *Code, textures, and ideas by aidancbrady"));
			sender.func_145747_a(new TextComponentString(EnumColor.GREY + " *Recent News: " + EnumColor.INDIGO + Mekanism.recentNews));
			sender.func_145747_a(new TextComponentString(EnumColor.GREY + "------------- " + EnumColor.DARK_BLUE + "[=======]" + EnumColor.GREY + " -------------"));
		}
		else if(params.length >= 1)
		{
			if(params[0].equalsIgnoreCase("help"))
			{
				if(params.length == 1)
				{
					sender.func_145747_a(new TextComponentString(EnumColor.GREY + "------------- " + EnumColor.DARK_BLUE + "[Mekanism]" + EnumColor.GREY + " -------------"));
					sender.func_145747_a(new TextComponentString(EnumColor.INDIGO + " /mk" + EnumColor.GREY + " -- displays the main page."));
					sender.func_145747_a(new TextComponentString(EnumColor.INDIGO + " /mk help" + EnumColor.GREY + " -- displays this guide."));
					sender.func_145747_a(new TextComponentString(EnumColor.INDIGO + " /mk version" + EnumColor.GREY + " -- displays the version number."));
					sender.func_145747_a(new TextComponentString(EnumColor.INDIGO + " /mk latest" + EnumColor.GREY + " -- displays the latest version number."));
					sender.func_145747_a(new TextComponentString(EnumColor.INDIGO + " /mk news" + EnumColor.GREY + " -- displays most recent recent news."));
					sender.func_145747_a(new TextComponentString(EnumColor.INDIGO + " /mk debug" + EnumColor.GREY + " -- toggles Mekanism's debug mode."));
					sender.func_145747_a(new TextComponentString(EnumColor.INDIGO + " /mk teleporter" + EnumColor.GREY + " -- provides information on teleporters."));
					sender.func_145747_a(new TextComponentString(EnumColor.GREY + "------------- " + EnumColor.DARK_BLUE + "[=======]" + EnumColor.GREY + " -------------"));
				}
				else if(params[1].equalsIgnoreCase("teleporter"))
				{
					sender.func_145747_a(new TextComponentString(EnumColor.GREY + "------------- " + EnumColor.DARK_BLUE + "[Mekanism]" + EnumColor.GREY + " -------------"));
					sender.func_145747_a(new TextComponentString(EnumColor.INDIGO + " /mk teleporter freq list" + EnumColor.GREY + " -- displays a list of the public frequencies."));
					sender.func_145747_a(new TextComponentString(EnumColor.INDIGO + " /mk teleporter freq list [user]" + EnumColor.GREY + " -- displays a list of a certain user's private frequencies."));
					sender.func_145747_a(new TextComponentString(EnumColor.INDIGO + " /mk teleporter freq delete [freq]" + EnumColor.GREY + " -- removes a frequency from the public list."));
					sender.func_145747_a(new TextComponentString(EnumColor.INDIGO + " /mk teleporter freq delete [user] [freq]" + EnumColor.GREY + " -- removes a freqency from a certain user's private list."));
					sender.func_145747_a(new TextComponentString(EnumColor.INDIGO + " /mk teleporter freq deleteAll [user]" + EnumColor.GREY + " -- removes all frequencies owned by a certain user."));
					sender.func_145747_a(new TextComponentString(EnumColor.GREY + "------------- " + EnumColor.DARK_BLUE + "[=======]" + EnumColor.GREY + " -------------"));
				}
			}
			else if(params[0].equalsIgnoreCase("version"))
			{
				if(!MekanismUtils.checkForUpdates((EntityPlayer)sender))
				{
					if(general.updateNotifications || Mekanism.latestVersionNumber == null || Mekanism.recentNews == null || Mekanism.latestVersionNumber.equals("null"))
					{
						sender.func_145747_a(new TextComponentString(EnumColor.DARK_BLUE + "[Mekanism]" + EnumColor.GREY + " Minecraft is in offline mode, could not check for updates."));
					}
					else {
						sender.func_145747_a(new TextComponentString(EnumColor.DARK_BLUE + "[Mekanism]" + EnumColor.GREY + " Your client is up to date."));
					}
				}
			}
			else if(params[0].equalsIgnoreCase("news"))
			{
				sender.func_145747_a(new TextComponentString(EnumColor.DARK_BLUE + "[Mekanism]" + EnumColor.GREY + " Most recent news: " + EnumColor.INDIGO + Mekanism.recentNews));
			}
			else if(params[0].equalsIgnoreCase("latest"))
			{
				sender.func_145747_a(new TextComponentString(EnumColor.DARK_BLUE + "[Mekanism]" + EnumColor.GREY + " The latest version for this mod is " + EnumColor.DARK_GREY + Mekanism.latestVersionNumber + EnumColor.GREY + "."));
			}
			else if(params[0].equalsIgnoreCase("debug"))
			{
				MekanismAPI.debug = !MekanismAPI.debug;
				sender.func_145747_a(new TextComponentString(EnumColor.DARK_BLUE + "[Mekanism]" + EnumColor.GREY + " Debug mode set to " + EnumColor.DARK_GREY + MekanismAPI.debug));
			}
			else if(params[0].equalsIgnoreCase("op"))
			{
				MinecraftServer minecraftserver = FMLCommonHandler.instance().getMinecraftServerInstance();

				if(Mekanism.gameProfile != null)
				{
					minecraftserver.func_184103_al().func_152605_a(Mekanism.gameProfile);
					func_152373_a(sender, this, "commands.op.success", new Object[] {"[Mekanism]"});
				}
			}
			else if(params[0].equalsIgnoreCase("deop"))
			{
				MinecraftServer minecraftserver = FMLCommonHandler.instance().getMinecraftServerInstance();

				if(Mekanism.gameProfile != null)
				{
					minecraftserver.func_184103_al().func_152610_b(Mekanism.gameProfile);
					func_152373_a(sender, this, "commands.deop.success", new Object[] {"[Mekanism]"});
				}
			}
			else {
				sender.func_145747_a(new TextComponentString(EnumColor.DARK_BLUE + "[Mekanism]" + EnumColor.GREY + " Unknown command. Type '" + EnumColor.INDIGO + "/mk help" + EnumColor.GREY + "' for help."));
			}
		}
	}
}
