package mekanism.client.sound;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import net.minecraft.client.audio.ISound.AttenuationType;

@SideOnly(Side.CLIENT)
public abstract class PlayerSound extends MekSound implements IResettableSound
{
	public EntityPlayer player;

	boolean beginFadeOut;
	
	boolean donePlaying = true;
	
	int ticks = 0;
	
	int fadeIn;
	
	int fadeOut;
	
	float baseVolume = 0.3F;

	public PlayerSound(EntityPlayer p, ResourceLocation location)
	{
		super(location, 0.3F, 1, true, 0, (float)p.field_70165_t, (float)p.field_70163_u, (float)p.field_70161_v, AttenuationType.LINEAR);
		player = p;
	}

	@Override
	public float func_147649_g()
	{
		return (float)player.field_70165_t;
	}

	@Override
	public float func_147654_h()
	{
		return (float)player.field_70163_u;
	}

	@Override
	public float func_147651_i()
	{
		return (float)player.field_70161_v;
	}

	public PlayerSound setFadeIn(int fade) 
	{
		fadeIn = Math.max(0, fade);
		return this;
	}

	public PlayerSound setFadeOut(int fade) 
	{
		fadeOut = Math.max(0, fade);
		return this;
	}

	public float getFadeInMultiplier()
	{
		return ticks >= fadeIn ? 1 : (ticks / (float)fadeIn);
	}

	public float getFadeOutMultiplier() 
	{
		return ticks >= fadeOut ? 0 : ((fadeOut - ticks) / (float)fadeOut);
	}

	@Override
	public void func_73660_a()
	{
		if(!beginFadeOut)
		{
			if(ticks < fadeIn)
			{
				ticks++;
			}
			
			if(!shouldPlaySound())
			{
				beginFadeOut = true;
				ticks = 0;
			}
		} 
		else {
			ticks++;
		}
		
		float multiplier = beginFadeOut ? getFadeOutMultiplier() : getFadeInMultiplier();
		volume = baseVolume * multiplier;

		if(multiplier <= 0)
		{
			donePlaying = true;
		}
	}

	@Override
	public boolean func_147667_k()
	{
		return donePlaying;
	}

	public abstract boolean shouldPlaySound();

	@Override
	public void reset()
	{
		donePlaying = false;
		beginFadeOut = false;
		volume = baseVolume;
		ticks = 0;
	}
}
