package mekanism.client.sound;

import mekanism.client.ClientTickHandler;
import mekanism.common.item.ItemJetpack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class JetpackSound extends PlayerSound
{
	public JetpackSound(EntityPlayer player)
	{
		super(player, new ResourceLocation("mekanism", "item.jetpack"));
		
		setFadeIn(10);
		setFadeOut(5);
	}

	@Override
	public boolean func_147667_k()
	{
		return donePlaying;
	}

	@Override
	public boolean shouldPlaySound()
	{
		return hasJetpack(player) && ClientTickHandler.isJetpackOn(player);
	}

	private boolean hasJetpack(EntityPlayer player)
	{
		return !player.field_71071_by.field_70460_b.get(2).func_190926_b() && player.field_71071_by.field_70460_b.get(2).func_77973_b() instanceof ItemJetpack;
	}
}
