package mekanism.client.sound;

import mekanism.client.ClientTickHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class FlamethrowerSound extends PlayerSound
{
	public boolean inUse;

	public ResourceLocation onSound;
	public ResourceLocation offSound;

	public FlamethrowerSound(EntityPlayer player)
	{
		super(player, new ResourceLocation("mekanism", "item.flamethrower.idle"));
		
		onSound = new ResourceLocation("mekanism", "item.flamethrower.active");
		offSound = new ResourceLocation("mekanism", "item.flamethrower.idle");
		inUse = ClientTickHandler.isFlamethrowerOn(player);
		soundLocation = inUse ? onSound : offSound;
		
		setFadeIn(0);
		setFadeOut(0);
	}

	@Override
	public boolean func_147667_k()
	{
		return donePlaying;
	}

	@Override
	public boolean shouldPlaySound()
	{
		return true;
	}

	@Override
	public float func_147653_e()
	{
		return super.func_147653_e() * (inUse ? 2 : 1);
	}

	@Override
	public void func_73660_a()
	{
		if(!ClientTickHandler.hasFlamethrower(player))
		{
			donePlaying = true;
			return;
		}
		
		if(inUse != ClientTickHandler.isFlamethrowerOn(player))
		{
			inUse = ClientTickHandler.isFlamethrowerOn(player);
			soundLocation = inUse ? onSound : offSound;
			donePlaying = true;
		}
	}
}
