package mekanism.client.render.transmitter;

import mekanism.client.render.ColourTemperature;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.config.MekanismConfig.client;
import mekanism.common.tile.transmitter.TileEntityThermodynamicConductor;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.util.EnumFacing;

import org.lwjgl.opengl.GL11;

public class RenderThermodynamicConductor extends RenderTransmitterBase<TileEntityThermodynamicConductor>
{
	public RenderThermodynamicConductor()
	{
		super();
	}
	
	@Override
	public void func_180535_a(TileEntityThermodynamicConductor transmitter, double x, double y, double z, float partialTick, int destroyStage)
	{
		if(client.opaqueTransmitters)
		{
			return;
		}
		
		push();
		Tessellator tessellator = Tessellator.func_178181_a();
		VertexBuffer worldRenderer = tessellator.func_178180_c();
		GL11.glTranslated(x + 0.5, y + 0.5, z + 0.5);

		for(EnumFacing side : EnumFacing.field_82609_l)
		{
			renderHeatSide(worldRenderer, side, transmitter);
		}

		MekanismRenderer.glowOn();
		
		tessellator.func_78381_a();

		MekanismRenderer.glowOff();
		pop();
	}
	
	public void renderHeatSide(VertexBuffer renderer, EnumFacing side, TileEntityThermodynamicConductor cable)
	{
		func_147499_a(MekanismRenderer.getBlocksTexture());
		renderTransparency(renderer, MekanismRenderer.heatIcon, getModelForSide(cable, side), ColourTemperature.fromTemperature(cable.temperature, cable.getBaseColour()));
	}
}
