package mekanism.client.render.tileentity;

import mekanism.common.tile.TileEntityPersonalChest;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class RenderPersonalChest extends TileEntitySpecialRenderer<TileEntityPersonalChest>
{
	private ModelChest model = new ModelChest();

	@Override
	public void func_180535_a(TileEntityPersonalChest tileEntity, double x, double y, double z, float partialTick, int destroyStage)
	{
		GlStateManager.func_179094_E();
		GlStateManager.func_179109_b((float)x, (float)y + 1.0F, (float)z);
		GlStateManager.func_179114_b(90, 0.0F, 1.0F, 0.0F);
		func_147499_a(MekanismUtils.getResource(ResourceType.RENDER, "PersonalChest.png"));

		switch(tileEntity.facing.ordinal())
		{
			case 2:
				GlStateManager.func_179114_b(270, 0.0F, 1.0F, 0.0F);
				GlStateManager.func_179109_b(1.0F, 0.0F, 0.0F);
				break;
			case 3:
				GlStateManager.func_179114_b(90, 0.0F, 1.0F, 0.0F);
				GlStateManager.func_179109_b(0.0F, 0.0F, -1.0F);
				break;
			case 4:
				GlStateManager.func_179114_b(0, 0.0F, 1.0F, 0.0F);
				break;
			case 5:
				GlStateManager.func_179114_b(180, 0.0F, 1.0F, 0.0F);
				GlStateManager.func_179109_b(1.0F, 0.0F, -1.0F);
				break;
		}

		float lidangle = tileEntity.prevLidAngle + (tileEntity.lidAngle - tileEntity.prevLidAngle) * partialTick;
		lidangle = 1.0F - lidangle;
		lidangle = 1.0F - lidangle * lidangle * lidangle;
		model.field_78234_a.field_78795_f = -((lidangle * 3.141593F) / 2.0F);
		GlStateManager.func_179114_b(180F, 0.0F, 0.0F, 1.0F);
		model.func_78231_a();
		GlStateManager.func_179121_F();
	}
}
