package mekanism.client.render.tileentity;

import java.util.HashMap;
import java.util.Map;

import mekanism.api.transmitters.TransmissionType;
import mekanism.client.MekanismClient;
import mekanism.client.model.ModelEnergyCube;
import mekanism.client.model.ModelEnergyCube.ModelEnergyCore;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Tier.EnergyCubeTier;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class RenderEnergyCube extends TileEntitySpecialRenderer<TileEntityEnergyCube>
{
	public static int[][] COLORS = new int[][] {new int[] {100, 210, 125}, new int[] {215, 85, 70}, new int[] {80, 125, 230},
												new int[] {154, 120, 200}, new int[] {0, 0, 0}};
	
	private ModelEnergyCube model = new ModelEnergyCube();
	private ModelEnergyCore core = new ModelEnergyCore();
	
	public static Map<EnergyCubeTier, ResourceLocation> resources = new HashMap<EnergyCubeTier, ResourceLocation>();
	public static ResourceLocation baseTexture = MekanismUtils.getResource(ResourceType.RENDER, "EnergyCube.png");
	public static ResourceLocation coreTexture = MekanismUtils.getResource(ResourceType.RENDER, "EnergyCore.png");

	static {
		if(resources.isEmpty())
		{
			for(EnergyCubeTier tier : EnergyCubeTier.values())
			{
				resources.put(tier, MekanismUtils.getResource(ResourceType.RENDER, "EnergyCube" + tier.getBaseTier().getSimpleName() + ".png"));
			}
		}
	}
	
	@Override
	public void func_180535_a(TileEntityEnergyCube tileEntity, double x, double y, double z, float partialTick, int destroyStage)
	{
		GlStateManager.func_179094_E();
		GlStateManager.func_179109_b((float)x + 0.5F, (float)y + 1.5F, (float)z + 0.5F);

		func_147499_a(baseTexture);

		switch(tileEntity.facing.ordinal())
		{
			case 0:
			{
				GlStateManager.func_179114_b(90F, -1.0F, 0.0F, 0.0F);
				GlStateManager.func_179109_b(0.0F, 1.0F, -1.0F);
				break;
			}
			case 1:
			{
				GlStateManager.func_179114_b(90F, 1.0F, 0.0F, 0.0F);
				GlStateManager.func_179109_b(0.0F, 1.0F, 1.0F);
				break;
			}
			case 2: GlStateManager.func_179114_b(0, 0.0F, 1.0F, 0.0F); break;
			case 3: GlStateManager.func_179114_b(180, 0.0F, 1.0F, 0.0F); break;
			case 4: GlStateManager.func_179114_b(90, 0.0F, 1.0F, 0.0F); break;
			case 5: GlStateManager.func_179114_b(270, 0.0F, 1.0F, 0.0F); break;
		}

		GlStateManager.func_179114_b(180F, 0.0F, 0.0F, 1.0F);
		model.render(0.0625F, tileEntity.tier, field_147501_a.field_147553_e, false);
		
		for(EnumFacing side : EnumFacing.values())
		{
			func_147499_a(baseTexture);
			model.renderSide(0.0625F, side, tileEntity.configComponent.getOutput(TransmissionType.ENERGY, side).ioState, tileEntity.tier, field_147501_a.field_147553_e);
		}
		
		GlStateManager.func_179121_F();


		if(tileEntity.getEnergy()/tileEntity.getMaxEnergy() > 0.1)
		{
			GlStateManager.func_179094_E();
			GL11.glTranslated(x + 0.5, y + 0.5, z + 0.5);
			func_147499_a(coreTexture);

			MekanismRenderer.blendOn();
			MekanismRenderer.glowOn();

			int[] c = COLORS[tileEntity.tier.getBaseTier().ordinal()];

			GlStateManager.func_179094_E();
			GlStateManager.func_179152_a(0.4F, 0.4F, 0.4F);
			GL11.glColor4f((float)c[0]/255F, (float)c[1]/255F, (float)c[2]/255F, (float)(tileEntity.getEnergy() / tileEntity.getMaxEnergy()));
			GlStateManager.func_179109_b(0, (float)Math.sin(Math.toRadians((MekanismClient.ticksPassed + partialTick) * 3)) / 7, 0);
			GlStateManager.func_179114_b((MekanismClient.ticksPassed + partialTick) * 4, 0, 1, 0);
			GlStateManager.func_179114_b(36F + (MekanismClient.ticksPassed + partialTick) * 4, 0, 1, 1);
			core.render(0.0625F);
			MekanismRenderer.resetColor();
			GlStateManager.func_179121_F();

			MekanismRenderer.glowOff();
			MekanismRenderer.blendOff();

			GlStateManager.func_179121_F();
		}
		
		MekanismRenderer.machineRenderer.func_180535_a(tileEntity, x, y, z, partialTick, destroyStage);
	}
}
