package mekanism.client.render.tileentity;

import mekanism.api.Coord4D;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.util.LangUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class RenderBin extends TileEntitySpecialRenderer<TileEntityBin>
{
	private final RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();

	@Override
	public void func_180535_a(TileEntityBin tileEntity, double x, double y, double z, float partialTick, int destroyStage)
	{
		Coord4D obj = Coord4D.get(tileEntity).offset(tileEntity.facing);

		if(obj.getBlockState(tileEntity.func_145831_w()).isSideSolid(tileEntity.func_145831_w(), obj.getPos(), tileEntity.facing.func_176734_d()))
		{
			return;
		}
		
		render(tileEntity.facing, tileEntity.itemType, tileEntity.clientAmount, true, x, y, z);
	}
	
	public void render(EnumFacing facing, ItemStack itemType, int clientAmount, boolean text, double x, double y, double z)
	{
		String amount = "";
		
		if(!itemType.func_190926_b())
		{
			amount = Integer.toString(clientAmount);
			
			if(clientAmount == Integer.MAX_VALUE)
			{
				amount = LangUtils.localize("gui.infinite");
			}
			
			GlStateManager.func_179094_E();

			switch(facing)
			{
				case NORTH:
					GL11.glTranslated(x + 0.73, y + 0.83, z - 0.0001);
					break;
				case SOUTH:
					GL11.glTranslated(x + 0.27, y + 0.83, z + 1.0001);
					GlStateManager.func_179114_b(180, 0, 1, 0);
					break;
				case WEST:
					GL11.glTranslated(x - 0.0001, y + 0.83, z + 0.27);
					GlStateManager.func_179114_b(90, 0, 1, 0);
					break;
				case EAST:
					GL11.glTranslated(x + 1.0001, y + 0.83, z + 0.73);
					GlStateManager.func_179114_b(-90, 0, 1, 0);
					break;
				default:
					break;
			}

			float scale = 0.03125F;
			float scaler = 0.9F;

			GlStateManager.func_179152_a(scale*scaler, scale*scaler, -0.0001F);
			GlStateManager.func_179114_b(180, 0, 0, 1);

			renderItem.func_180450_b(itemType, 0, 0);
			
			GlStateManager.func_179121_F();
		}

		if(text && !amount.equals(""))
		{
			renderText(amount, facing, 0.02F, x, y - 0.3725F, z);
		}
	}

	@SuppressWarnings("incomplete-switch")
	private void renderText(String text, EnumFacing side, float maxScale, double x, double y, double z)
	{
		GlStateManager.func_179094_E();

		GlStateManager.func_179136_a(-10, -10);
		GlStateManager.func_179088_q();

		float displayWidth = 1 - (2 / 16);
		float displayHeight = 1 - (2 / 16);
		GlStateManager.func_179137_b(x, y, z);

		switch(side)
		{
			case SOUTH:
				GlStateManager.func_179109_b(0, 1, 0);
				GlStateManager.func_179114_b(0, 0, 1, 0);
				GlStateManager.func_179114_b(90, 1, 0, 0);
				break;
			case NORTH:
				GlStateManager.func_179109_b(1, 1, 1);
				GlStateManager.func_179114_b(180, 0, 1, 0);
				GlStateManager.func_179114_b(90, 1, 0, 0);
				break;
			case EAST:
				GlStateManager.func_179109_b(0, 1, 1);
				GlStateManager.func_179114_b(90, 0, 1, 0);
				GlStateManager.func_179114_b(90, 1, 0, 0);
				break;
			case WEST:
				GlStateManager.func_179109_b(1, 1, 0);
				GlStateManager.func_179114_b(-90, 0, 1, 0);
				GlStateManager.func_179114_b(90, 1, 0, 0);
				break;
		}

		GlStateManager.func_179109_b(displayWidth / 2, 1F, displayHeight / 2);
		GlStateManager.func_179114_b(-90, 1, 0, 0);

		FontRenderer fontRenderer = func_147498_b();

		int requiredWidth = Math.max(fontRenderer.func_78256_a(text), 1);
		int lineHeight = fontRenderer.field_78288_b + 2;
		int requiredHeight = lineHeight * 1;
		float scaler = 0.4F;
		float scaleX = (displayWidth / requiredWidth);
		float scale = scaleX * scaler;

		if(maxScale > 0)
		{
			scale = Math.min(scale, maxScale);
		}

		GlStateManager.func_179152_a(scale, -scale, scale);
		GlStateManager.func_179132_a(false);

		int realHeight = (int)Math.floor(displayHeight / scale);
		int realWidth = (int)Math.floor(displayWidth / scale);

		int offsetX = (realWidth - requiredWidth) / 2;
		int offsetY = (realHeight - requiredHeight) / 2;

		GlStateManager.func_179140_f();
		fontRenderer.func_78276_b("\u00a7f" + text, offsetX - (realWidth / 2), 1 + offsetY - (realHeight / 2), 1);
		GlStateManager.func_179145_e();
		GlStateManager.func_179132_a(true);
		GlStateManager.func_179113_r();

		GlStateManager.func_179121_F();
	}
}
