package mekanism.client.render.obj;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;

import mekanism.api.EnumColor;
import mekanism.common.block.property.PropertyColor;
import mekanism.common.tile.TileEntityGlowPanel;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms.TransformType;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.client.model.obj.OBJModel.Face;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;

import org.apache.commons.lang3.tuple.Pair;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;

public class GlowPanelModel extends OBJBakedModelBase
{
	private static Map<Integer, List<BakedQuad>> glowPanelCache = new HashMap<>();
	private static Map<Integer, GlowPanelModel> glowPanelItemCache = new HashMap<>();
	
	private IBlockState tempState;
	private ItemStack tempStack;
	
	private GlowPanelOverride override = new GlowPanelOverride();
	
	public GlowPanelModel(IBakedModel base, OBJModel model, IModelState state, VertexFormat format, ImmutableMap<String, TextureAtlasSprite> textures, HashMap<TransformType, Matrix4f> transform)
	{
		super(base, model, state, format, textures, transform);
	}

	public static void forceRebake()
	{
		glowPanelCache.clear();
		glowPanelItemCache.clear();
	}
	
	public EnumColor getColor()
	{
		if(tempStack != null && !tempStack.func_190926_b())
		{
			return EnumColor.DYES[tempStack.func_77952_i()];
		}
		
		if(tempState != null)
		{
			return ((IExtendedBlockState)tempState).getValue(PropertyColor.INSTANCE).color;
		}
		
		return EnumColor.WHITE;
	}
	
    private class GlowPanelOverride extends ItemOverrideList 
    {
		public GlowPanelOverride() 
		{
			super(Lists.newArrayList());
		}

	    @Override
	    public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) 
	    {
			if(glowPanelItemCache.containsKey(stack.func_77952_i()))
			{
				return glowPanelItemCache.get(stack.func_77952_i());
			}

			ImmutableMap.Builder<String, TextureAtlasSprite> builder = ImmutableMap.builder();
			builder.put(ModelLoader.White.LOCATION.toString(), ModelLoader.White.INSTANCE);
			TextureAtlasSprite missing = Minecraft.func_71410_x().func_147117_R().func_110572_b(new ResourceLocation("missingno").toString());

			for(String s : getModel().getMatLib().getMaterialNames())
			{
				TextureAtlasSprite sprite = null;
				
				if(sprite == null)
				{
					sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(getModel().getMatLib().getMaterial(s).getTexture().getTextureLocation().toString());
				}
				
				if(sprite == null)
				{
					sprite = missing;
				}
				
				builder.put(s, sprite);
			}
			
			builder.put("missingno", missing);
			GlowPanelModel bakedModel = new GlowPanelModel(baseModel, getModel(), getState(), vertexFormat, builder.build(), transformationMap);
			bakedModel.tempStack = stack;
			glowPanelItemCache.put(stack.func_77952_i(), bakedModel);
			
			return bakedModel;
	    }
	}
	
	@Override
	public ItemOverrideList func_188617_f()
	{
		return override;
	}
	
	@Override
	public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand)
	{
    	if(side != null) 
    	{
    		return ImmutableList.of();
    	}
    	
    	if(state != null && tempState == null)
    	{
	    	int hash = TileEntityGlowPanel.hash((IExtendedBlockState)state);
			EnumColor color = ((IExtendedBlockState)state).getValue(PropertyColor.INSTANCE).color;
			
			if(!glowPanelCache.containsKey(hash))
			{
				GlowPanelModel model = new GlowPanelModel(baseModel, getModel(), getState(), vertexFormat, textureMap, transformationMap);
				model.tempState = state;
				glowPanelCache.put(hash, model.func_188616_a(state, side, rand));
			}
			
			return glowPanelCache.get(hash);
    	}
    	
    	return super.func_188616_a(state, side, rand);
	}
	
	@Override
	public float[] getOverrideColor(Face f, String groupName)
	{
		if(groupName.equals("light"))
		{
			EnumColor c = getColor();
			return new float[] {c.getColor(0), c.getColor(1), c.getColor(2), 1};
		}
		
		return null;
	}
    
    @Override
    public Pair<? extends IPerspectiveAwareModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType transformType) 
    {
    	if(transformType == TransformType.GUI)
    	{
    		GlStateManager.func_179114_b(180, 1, 0, 0);
    		ForgeHooksClient.multiplyCurrentGlMatrix(transforms.get(transformType).getMatrix());
    		GlStateManager.func_179109_b(0.65F, 0.45F, 0.0F);
    		GlStateManager.func_179114_b(90, 1, 0, 0);
    		GlStateManager.func_179152_a(1.6F, 1.6F, 1.6F);
    		
    		return Pair.of(this, null);
    	}
    	else if(transformType == TransformType.FIRST_PERSON_RIGHT_HAND || transformType == TransformType.FIRST_PERSON_LEFT_HAND)
    	{
    		GlStateManager.func_179109_b(0.0F, 0.2F, 0.0F);
    	}
    	else if(transformType == TransformType.THIRD_PERSON_RIGHT_HAND || transformType == TransformType.THIRD_PERSON_LEFT_HAND) 
        {
    		ForgeHooksClient.multiplyCurrentGlMatrix(transforms.get(transformType).getMatrix());
        	GlStateManager.func_179109_b(0.0F, 0.3F, 0.2F);
        	
        	return Pair.of(this, null);
        }
        
        return Pair.of(this, transforms.get(transformType).getMatrix());
    }

	// Copy from old CTM
	public static Map<TransformType, TRSRTransformation> transforms = ImmutableMap.<TransformType, TRSRTransformation>builder()
			.put(TransformType.GUI,                         get(0, 0, 0, 30, 225, 0, 0.625f))
			.put(TransformType.THIRD_PERSON_RIGHT_HAND,     get(0, 2.5f, 0, 75, 45, 0, 0.375f))
			.put(TransformType.THIRD_PERSON_LEFT_HAND,      get(0, 2.5f, 0, 75, 45, 0, 0.375f))
			.put(TransformType.FIRST_PERSON_RIGHT_HAND,     get(0, 0, 0, 0, 45, 0, 0.4f))
			.put(TransformType.FIRST_PERSON_LEFT_HAND,      get(0, 0, 0, 0, 225, 0, 0.4f))
			.put(TransformType.GROUND,                      get(0, 2, 0, 0, 0, 0, 0.25f))
			.put(TransformType.HEAD,                        get(0, 0, 0, 0, 0, 0, 1))
			.put(TransformType.FIXED,                       get(0, 0, 0, 0, 0, 0, 1))
			.put(TransformType.NONE,                        get(0, 0, 0, 0, 0, 0, 0))
			.build();

	private static TRSRTransformation get(float tx, float ty, float tz, float ax, float ay, float az, float s)
	{
		return new TRSRTransformation(
				new Vector3f(tx / 16, ty / 16, tz / 16),
				TRSRTransformation.quatFromXYZDegrees(new Vector3f(ax, ay, az)),
				new Vector3f(s, s, s),
				null);
	}
}
