package mekanism.client.render.item;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;

import com.google.common.collect.ImmutableMap;
import mekanism.api.energy.IEnergizedItem;
import mekanism.client.model.ModelArmoredJetpack;
import mekanism.client.model.ModelAtomicDisassembler;
import mekanism.client.model.ModelChemicalCrystallizer;
import mekanism.client.model.ModelChemicalDissolutionChamber;
import mekanism.client.model.ModelDigitalMiner;
import mekanism.client.model.ModelEnergyCube;
import mekanism.client.model.ModelFlamethrower;
import mekanism.client.model.ModelFreeRunners;
import mekanism.client.model.ModelGasMask;
import mekanism.client.model.ModelJetpack;
import mekanism.client.model.ModelQuantumEntangloporter;
import mekanism.client.model.ModelResistiveHeater;
import mekanism.client.model.ModelScubaTank;
import mekanism.client.model.ModelSecurityDesk;
import mekanism.client.model.ModelSeismicVibrator;
import mekanism.client.model.ModelSolarNeutronActivator;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.tileentity.RenderBin;
import mekanism.client.render.tileentity.RenderEnergyCube;
import mekanism.client.render.tileentity.RenderFluidTank;
import mekanism.common.Mekanism;
import mekanism.common.MekanismItems;
import mekanism.common.SideData.IOState;
import mekanism.common.Tier.EnergyCubeTier;
import mekanism.common.Tier.FluidTankTier;
import mekanism.common.base.ITierItem;
import mekanism.common.block.states.BlockStateBasic.BasicBlockType;
import mekanism.common.block.states.BlockStateMachine.MachineType;
import mekanism.common.item.ItemAtomicDisassembler;
import mekanism.common.item.ItemBlockEnergyCube;
import mekanism.common.item.ItemBlockMachine;
import mekanism.common.item.ItemFlamethrower;
import mekanism.common.item.ItemFreeRunners;
import mekanism.common.item.ItemGasMask;
import mekanism.common.item.ItemScubaTank;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms.TransformType;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.Fluid;

import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class BakedCustomItemModel implements IBakedModel, IPerspectiveAwareModel
{
	private IBakedModel baseModel;
	private ItemStack stack;
	
	private TransformType prevTransform;
	
	private Minecraft mc = Minecraft.func_71410_x();
	
	private static final RenderFluidTank fluidTankRenderer = (RenderFluidTank)TileEntityRendererDispatcher.field_147556_a.field_147559_m.get(TileEntityFluidTank.class);
	private final RenderBin binRenderer = (RenderBin)TileEntityRendererDispatcher.field_147556_a.field_147559_m.get(TileEntityBin.class);
	
	public static ModelJetpack jetpack = new ModelJetpack();
	public static ModelArmoredJetpack armoredJetpack = new ModelArmoredJetpack();
	public static ModelGasMask gasMask = new ModelGasMask();
	public static ModelScubaTank scubaTank = new ModelScubaTank();
	public static ModelFreeRunners freeRunners = new ModelFreeRunners();
	public static ModelAtomicDisassembler atomicDisassembler = new ModelAtomicDisassembler();
	public static ModelFlamethrower flamethrower = new ModelFlamethrower();
	public static ModelChest personalChest = new ModelChest();
	public static ModelSolarNeutronActivator solarNeutronActivator = new ModelSolarNeutronActivator();
	public static ModelSeismicVibrator seismicVibrator = new ModelSeismicVibrator();
	public static ModelChemicalDissolutionChamber chemicalDissolutionChamber = new ModelChemicalDissolutionChamber();
	public static ModelChemicalCrystallizer chemicalCrystallizer = new ModelChemicalCrystallizer();
	public static ModelSecurityDesk securityDesk = new ModelSecurityDesk();
	public static ModelResistiveHeater resistiveHeater = new ModelResistiveHeater();
	public static ModelQuantumEntangloporter quantumEntangloporter = new ModelQuantumEntangloporter();
	public static ModelEnergyCube energyCube = new ModelEnergyCube();
	public static ModelDigitalMiner digitalMiner = new ModelDigitalMiner();
	
	public BakedCustomItemModel(IBakedModel model, ItemStack s)
	{
		baseModel = model;
		stack = s;
	}
	
	private void doRender(TransformType type)
	{
		BasicBlockType basicType = BasicBlockType.get(stack);
		
		if(type == TransformType.GUI)
		{
			GlStateManager.func_179114_b(180F, 0.0F, 1.0F, 0.0F);
		}
		
		if(basicType != null)
		{
			if(basicType == BasicBlockType.BIN)
			{
				/*GlStateManager.pushMatrix();
				ItemBlockBasic itemBasic = (ItemBlockBasic)stack.getItem();
				InventoryBin inv = new InventoryBin(stack);
				binRenderer.render(EnumFacing.NORTH, inv.getItemType(), inv.getItemCount(), false, -0.5, -0.5, -0.5);
				Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
				GlStateManager.enableRescaleNormal();
		        GlStateManager.enableAlpha();
		        GlStateManager.alphaFunc(516, 0.1F);
		        GlStateManager.enableBlend();
		        GlStateManager.blendFunc(770, 771);
		        GlStateManager.color(1.0F, 1.0F, 1.0F, 1.0F);
				GlStateManager.popMatrix(); TODO get this working*/
			}
			else if(basicType == BasicBlockType.SECURITY_DESK)
			{
				GlStateManager.func_179114_b(180, 1.0F, 0.0F, 0.0F);
				GlStateManager.func_179114_b(180, 0.0F, 1.0F, 0.0F);
				GlStateManager.func_179152_a(0.8F, 0.8F, 0.8F);
				GlStateManager.func_179109_b(0.0F, -0.8F, 0.0F);
				mc.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.RENDER, "SecurityDesk.png"));
				securityDesk.render(0.0625F, mc.field_71446_o);
			}
			
			return;
		}
		
		MachineType machineType = MachineType.get(stack);
		
		if(machineType != null)
		{
			if(machineType == MachineType.FLUID_TANK)
			{
				GlStateManager.func_179094_E();
				ItemBlockMachine itemMachine = (ItemBlockMachine)stack.func_77973_b();
				float targetScale = (float)(itemMachine.getFluidStack(stack) != null ? itemMachine.getFluidStack(stack).amount : 0)/itemMachine.getCapacity(stack);
				FluidTankTier tier = FluidTankTier.values()[itemMachine.getBaseTier(stack).ordinal()];
				Fluid fluid = itemMachine.getFluidStack(stack) != null ? itemMachine.getFluidStack(stack).getFluid() : null;
				fluidTankRenderer.render(tier, fluid, targetScale, false, null, -0.5, -0.5, -0.5);
				GlStateManager.func_179121_F();
			}
			else if(machineType == MachineType.PERSONAL_CHEST)
			{
				GlStateManager.func_179094_E();

				GlStateManager.func_179114_b(180F, 0.0F, 1.0F, 0.0F);
				GlStateManager.func_179109_b(-0.5F, -0.5F, -0.5F);
				GlStateManager.func_179109_b(0, 1.0F, 1.0F);
				GlStateManager.func_179152_a(1.0F, -1F, -1F);

				mc.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.RENDER, "PersonalChest.png"));

				personalChest.func_78231_a();
				GlStateManager.func_179121_F();
			}
			else if(machineType == MachineType.SOLAR_NEUTRON_ACTIVATOR)
			{
				GlStateManager.func_179114_b(180F, 0.0F, 0.0F, 1.0F);
				GlStateManager.func_179152_a(0.6F, 0.6F, 0.6F);
				GlStateManager.func_179109_b(0.0F, -0.55F, 0.0F);
				mc.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.RENDER, "SolarNeutronActivator.png"));
				solarNeutronActivator.render(0.0625F);
			}
			else if(machineType == MachineType.SEISMIC_VIBRATOR)
			{
				GlStateManager.func_179114_b(180F, 0.0F, 0.0F, 1.0F);
				GlStateManager.func_179152_a(0.6F, 0.6F, 0.6F);
				GlStateManager.func_179109_b(0.0F, -0.55F, 0.0F);
				mc.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.RENDER, "SeismicVibrator.png"));
				seismicVibrator.render(0.0625F);
			}
			else if(machineType == MachineType.CHEMICAL_CRYSTALLIZER)
			{
				GlStateManager.func_179114_b(180F, 0.0F, 0.0F, 1.0F);
				GlStateManager.func_179109_b(0.05F, -1.001F, 0.05F);
				mc.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.RENDER, "ChemicalCrystallizer.png"));
				chemicalCrystallizer.render(0.0625F);
			}
			else if(machineType == MachineType.CHEMICAL_DISSOLUTION_CHAMBER)
			{
				GlStateManager.func_179114_b(180F, 0.0F, 0.0F, 1.0F);
				GlStateManager.func_179109_b(0.05F, -1.001F, 0.05F);
				mc.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.RENDER, "ChemicalDissolutionChamber.png"));
				chemicalDissolutionChamber.render(0.0625F);
			}
			else if(machineType == MachineType.QUANTUM_ENTANGLOPORTER)
			{
				GlStateManager.func_179114_b(180F, 0.0F, 0.0F, 1.0F);
				GlStateManager.func_179109_b(0.0F, -1.0F, 0.0F);
				mc.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.RENDER, "QuantumEntangloporter.png"));
				quantumEntangloporter.render(0.0625F, mc.field_71446_o, true);
			}
			else if(machineType == MachineType.RESISTIVE_HEATER)
			{
				GlStateManager.func_179114_b(180F, 0.0F, 0.0F, 1.0F);
				GlStateManager.func_179109_b(0.05F, -0.96F, 0.05F);
				mc.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.RENDER, "ResistiveHeater.png"));
				resistiveHeater.render(0.0625F, false, mc.field_71446_o, true);
			}
			else if(machineType == MachineType.DIGITAL_MINER)
			{
				GL11.glRotatef(180F, 0.0F, 0.0F, 1.0F);
				GL11.glTranslatef(0.35F, 0.1F, 0.0F);
				mc.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.RENDER, "DigitalMiner.png"));
				digitalMiner.render(0.022F, false, mc.field_71446_o, true);
			}
			
			return;
		}
		
		if(stack.func_77973_b() instanceof ItemBlockEnergyCube)
		{
			GlStateManager.func_179094_E();
			EnergyCubeTier tier = EnergyCubeTier.values()[((ITierItem)stack.func_77973_b()).getBaseTier(stack).ordinal()];
			IEnergizedItem energized = (IEnergizedItem)stack.func_77973_b();
			mc.field_71446_o.func_110577_a(RenderEnergyCube.baseTexture);

			GlStateManager.func_179114_b(180F, 0.0F, 0.0F, 1.0F);
			GlStateManager.func_179114_b(180F, 0.0F, 1.0F, 0.0F);
			GlStateManager.func_179109_b(0.0F, -1.0F, 0.0F);

			MekanismRenderer.blendOn();
			
			energyCube.render(0.0625F, tier, mc.field_71446_o, true);
			
			for(EnumFacing side : EnumFacing.field_82609_l)
			{
				mc.field_71446_o.func_110577_a(RenderEnergyCube.baseTexture);
				energyCube.renderSide(0.0625F, side, side == EnumFacing.NORTH ? IOState.OUTPUT : IOState.INPUT, tier, mc.field_71446_o);
			}
			
			MekanismRenderer.blendOff();
			GlStateManager.func_179121_F();
		}
		
		if(type == TransformType.GUI)
		{
			GlStateManager.func_179114_b(90.0F, 0.0F, 1.0F, 0.0F);
		}
		else {
			GlStateManager.func_179114_b(180.0F, 0.0F, 1.0F, 0.0F);
		}
		
		if(stack.func_77973_b() == MekanismItems.Jetpack)
		{
			GlStateManager.func_179094_E();
			GlStateManager.func_179114_b(180, 0.0F, 0.0F, 1.0F);
			GlStateManager.func_179114_b(90, 0.0F, -1.0F, 0.0F);
			GlStateManager.func_179109_b(0.2F, -0.35F, 0.0F);
			mc.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.RENDER, "Jetpack.png"));
			jetpack.render(0.0625F);
			GlStateManager.func_179121_F();
		}
		else if(stack.func_77973_b() == MekanismItems.ArmoredJetpack)
		{
			GlStateManager.func_179094_E();
			GlStateManager.func_179114_b(180, 0.0F, 0.0F, 1.0F);
			GlStateManager.func_179114_b(90, 0.0F, -1.0F, 0.0F);
			GlStateManager.func_179109_b(0.2F, -0.35F, 0.0F);
			mc.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.RENDER, "Jetpack.png"));
			armoredJetpack.render(0.0625F);
			GlStateManager.func_179121_F();
		}
		else if(stack.func_77973_b() instanceof ItemGasMask)
		{
			GlStateManager.func_179094_E();
			GlStateManager.func_179114_b(180, 0.0F, 0.0F, 1.0F);
			GlStateManager.func_179114_b(90, 0.0F, -1.0F, 0.0F);
			GlStateManager.func_179109_b(0.1F, 0.2F, 0.0F);
			mc.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.RENDER, "ScubaSet.png"));
			gasMask.render(0.0625F);
			GlStateManager.func_179121_F();
		}
		else if(stack.func_77973_b() instanceof ItemScubaTank)
		{
			GlStateManager.func_179094_E();
			GlStateManager.func_179114_b(180, 0.0F, 0.0F, 1.0F);
			GlStateManager.func_179114_b(90, 0.0F, -1.0F, 0.0F);
			GlStateManager.func_179152_a(1.6F, 1.6F, 1.6F);
			GlStateManager.func_179109_b(0.2F, -0.5F, 0.0F);
			mc.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.RENDER, "ScubaSet.png"));
			scubaTank.render(0.0625F);
			GlStateManager.func_179121_F();
		}
		else if(stack.func_77973_b() instanceof ItemFreeRunners)
		{
			GlStateManager.func_179094_E();
			GlStateManager.func_179114_b(180, 0.0F, 0.0F, 1.0F);
			GlStateManager.func_179114_b(90, 0.0F, -1.0F, 0.0F);
			GlStateManager.func_179152_a(2.0F, 2.0F, 2.0F);
			GlStateManager.func_179109_b(0.2F, -1.43F, 0.12F);
			mc.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.RENDER, "FreeRunners.png"));
			freeRunners.render(0.0625F);
			GlStateManager.func_179121_F();
		}
		else if(stack.func_77973_b() instanceof ItemAtomicDisassembler)
		{
			GlStateManager.func_179094_E();
			GlStateManager.func_179152_a(1.4F, 1.4F, 1.4F);
			GlStateManager.func_179114_b(180, 0.0F, 0.0F, 1.0F);

			if(type == TransformType.THIRD_PERSON_RIGHT_HAND || type == TransformType.THIRD_PERSON_LEFT_HAND)
			{
				if(type == TransformType.THIRD_PERSON_LEFT_HAND)
				{
					GlStateManager.func_179114_b(-90, 0.0F, 1.0F, 0.0F);
				}
				
				GlStateManager.func_179114_b(45, 0.0F, 1.0F, 0.0F);
				GlStateManager.func_179114_b(50, 1.0F, 0.0F, 0.0F);
				GlStateManager.func_179152_a(2.0F, 2.0F, 2.0F);
				GlStateManager.func_179109_b(0.0F, -0.4F, 0.4F);
			}
			else if(type == TransformType.GUI)
			{
				GlStateManager.func_179114_b(225, 0.0F, 1.0F, 0.0F);
				GlStateManager.func_179114_b(45, -1.0F, 0.0F, -1.0F);
				GlStateManager.func_179152_a(0.6F, 0.6F, 0.6F);
				GlStateManager.func_179109_b(0.0F, -0.2F, 0.0F);
			}
			else {
				if(type == TransformType.FIRST_PERSON_LEFT_HAND)
				{
					GlStateManager.func_179114_b(90, 0.0F, 1.0F, 0.0F);
				}
				
				GlStateManager.func_179114_b(45, 0.0F, 1.0F, 0.0F);
				GlStateManager.func_179109_b(0.0F, -0.7F, 0.0F);
			}

			mc.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.RENDER, "AtomicDisassembler.png"));
			atomicDisassembler.render(0.0625F);
			GlStateManager.func_179121_F();
		}
		else if(stack.func_77973_b() instanceof ItemFlamethrower)
		{
			GlStateManager.func_179094_E();
			GlStateManager.func_179114_b(160, 0.0F, 0.0F, 1.0F);
			mc.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.RENDER, "Flamethrower.png"));
			
			GlStateManager.func_179109_b(0.0F, -1.0F, 0.0F);
			GlStateManager.func_179114_b(135, 0.0F, 1.0F, 0.0F);
			GlStateManager.func_179114_b(-20, 0.0F, 0.0F, 1.0F);
			
			if(type == TransformType.FIRST_PERSON_RIGHT_HAND || type == TransformType.THIRD_PERSON_RIGHT_HAND
					|| type == TransformType.FIRST_PERSON_LEFT_HAND || type == TransformType.THIRD_PERSON_LEFT_HAND)
			{
				if(type == TransformType.FIRST_PERSON_RIGHT_HAND)
				{
					GlStateManager.func_179114_b(55, 0.0F, 1.0F, 0.0F);
				}
				else if(type == TransformType.FIRST_PERSON_LEFT_HAND)
				{
					GlStateManager.func_179114_b(-160, 0.0F, 1.0F, 0.0F);
					GlStateManager.func_179114_b(30F, 1.0F, 0.0F, 0.0F);
				}
				else if(type == TransformType.THIRD_PERSON_RIGHT_HAND)
				{
					GlStateManager.func_179109_b(0.0F, 0.7F, 0.0F);
					GlStateManager.func_179114_b(75, 0.0F, 1.0F, 0.0F);
				}
				else if(type == TransformType.THIRD_PERSON_LEFT_HAND)
				{
					GlStateManager.func_179109_b(0.0F, 0.7F, 0.0F);
					GlStateManager.func_179114_b(-75, 0.0F, 1.0F, 0.0F);
				}
				
				GlStateManager.func_179152_a(2.5F, 2.5F, 2.5F);
				GlStateManager.func_179109_b(0.0F, -1.0F, -0.5F);
			}
			else if(type == TransformType.GUI)
			{
				GlStateManager.func_179109_b(-0.6F, 0.0F, 0.0F);
				GlStateManager.func_179114_b(45, 0.0F, 1.0F, 0.0F);
			}
			
			flamethrower.render(0.0625F);
			GlStateManager.func_179121_F();
		}
	}

	@Override
	public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand)
	{
		if(side != null)
		{
			List<BakedQuad> faceQuads = new LinkedList<BakedQuad>();
			
			if(Block.func_149634_a(stack.func_77973_b()) != null)
			{
				MachineType machineType = MachineType.get(stack);
				
				if(machineType != MachineType.QUANTUM_ENTANGLOPORTER && machineType != MachineType.RESISTIVE_HEATER)
				{
					if(!(stack.func_77973_b() instanceof ItemBlockEnergyCube))
					{
						faceQuads.addAll(baseModel.func_188616_a(state, side, rand));
					}
				}
			}
			
			return faceQuads;
		}
		
		Tessellator tessellator = Tessellator.func_178181_a();
		List<BakedQuad> generalQuads = new LinkedList<BakedQuad>();

		//Test if the current thread has a Context loaded (we don't use it so no need to import its type)
		Object contextCapabilities;
		try {
			contextCapabilities = GLContext.getCapabilities();
		} catch (RuntimeException e){
			contextCapabilities = null;
		}

		if (contextCapabilities != null && MekanismRenderer.isDrawing(tessellator)) {
			try {
				VertexFormat prevFormat = null;
				int prevMode = -1;

				MekanismRenderer.pauseRenderer(tessellator);

				GlStateManager.func_179094_E();
				GlStateManager.func_179109_b(0.5F, 0.5F, 0.5F);
				GlStateManager.func_179114_b(180, 0.0F, 1.0F, 0.0F);
				doRender(prevTransform);
				GlStateManager.func_179145_e();
				GlStateManager.func_179085_a(0);
				GlStateManager.func_179085_a(1);
				GlStateManager.func_179142_g();
				GlStateManager.func_179104_a(1032, 5634);
				GlStateManager.func_179089_o();
				Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
				GlStateManager.func_179121_F();

				MekanismRenderer.resumeRenderer(tessellator);
			} catch (Throwable t) {
				Mekanism.logger.error("Error caught in CustomItemModel", t);
			}
		}
    	
		if(Block.func_149634_a(stack.func_77973_b()) != null)
		{
			MachineType machineType = MachineType.get(stack);
			
			if(machineType != MachineType.DIGITAL_MINER)
			{
				if(!(stack.func_77973_b() instanceof ItemBlockEnergyCube))
				{
					generalQuads.addAll(baseModel.func_188616_a(state, side, rand));
				}
			}
		}
		
		return generalQuads;
	}

	@Override
	public boolean func_177555_b()
	{
		return baseModel.func_177555_b();
	}

	@Override
	public boolean func_177556_c()
	{
		return baseModel.func_177556_c();
	}

	@Override
	public boolean func_188618_c()
	{
		return baseModel.func_188618_c();
	}

	@Override
	public TextureAtlasSprite func_177554_e()
	{
		return baseModel.func_177554_e();
	}

	@Override
	public ItemCameraTransforms func_177552_f()
	{
		return baseModel.func_177552_f();
	}

    @Override
    public Pair<? extends IPerspectiveAwareModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType)
    {
    	prevTransform = cameraTransformType;

        return Pair.of(this, transforms.get(cameraTransformType).getMatrix());
    }

    // Copy from old CTM
	public static Map<TransformType, TRSRTransformation> transforms = ImmutableMap.<TransformType, TRSRTransformation>builder()
			.put(TransformType.GUI,                         get(0, 0, 0, 30, 225, 0, 0.625f))
			.put(TransformType.THIRD_PERSON_RIGHT_HAND,     get(0, 2.5f, 0, 75, 45, 0, 0.375f))
			.put(TransformType.THIRD_PERSON_LEFT_HAND,      get(0, 2.5f, 0, 75, 45, 0, 0.375f))
			.put(TransformType.FIRST_PERSON_RIGHT_HAND,     get(0, 0, 0, 0, 45, 0, 0.4f))
			.put(TransformType.FIRST_PERSON_LEFT_HAND,      get(0, 0, 0, 0, 225, 0, 0.4f))
			.put(TransformType.GROUND,                      get(0, 2, 0, 0, 0, 0, 0.25f))
			.put(TransformType.HEAD,                        get(0, 0, 0, 0, 0, 0, 1))
			.put(TransformType.FIXED,                       get(0, 0, 0, 0, 0, 0, 1))
			.put(TransformType.NONE,                        get(0, 0, 0, 0, 0, 0, 0))
			.build();

	private static TRSRTransformation get(float tx, float ty, float tz, float ax, float ay, float az, float s)
	{
		return new TRSRTransformation(
				new Vector3f(tx / 16, ty / 16, tz / 16),
				TRSRTransformation.quatFromXYZDegrees(new Vector3f(ax, ay, az)),
				new Vector3f(s, s, s),
				null);
	}

	@Override
	public ItemOverrideList func_188617_f() 
	{
		return ItemOverrideList.field_188022_a;
	}
}
