package mekanism.client.render.entity;

import mekanism.client.render.MekanismRenderer;
import mekanism.common.entity.EntityFlame;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;

@SideOnly(Side.CLIENT)
public class RenderFlame extends Render<EntityFlame>
{
    public RenderFlame(RenderManager renderManager)
    {
        super(renderManager);
    }

    @Override
    public void func_76986_a(EntityFlame entity, double x, double y, double z, float f, float partialTick)
    {
    	if(entity.field_70173_aa < 1)
    	{
    		return;
    	}
    	
    	float alpha = (entity.field_70173_aa+partialTick)/(float)EntityFlame.LIFESPAN;
    	float size = (float)Math.pow(2*alpha, 2);
    	
        GlStateManager.func_179094_E();
        MekanismRenderer.glowOn();
        MekanismRenderer.blendOn();
        GL11.glColor4f(1, 1, 1, 1-alpha);
        
        func_110776_a(func_110775_a(entity));
        
        GlStateManager.func_179109_b((float)x, (float)y, (float)z);
        GlStateManager.func_179114_b((entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTick) - 90F, 0.0F, 1.0F, 0.0F);
        GlStateManager.func_179114_b(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTick, 0.0F, 0.0F, 1.0F);
        
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer worldrenderer = tessellator.func_178180_c();
        
        int i = 0;
        float f2 = 0.0F;
        float f3 = 0.5F;
        float f4 = (float)(0 + i * 10) / 32F;
        float f5 = (float)(5 + i * 10) / 32F;
        float scale = 0.05625F*(0.8F+size);
        
        GL11.glEnable(GL12.GL_RESCALE_NORMAL);
        GlStateManager.func_179114_b(45F, 1.0F, 0.0F, 0.0F);
        GlStateManager.func_179152_a(scale, scale, scale);
        GlStateManager.func_179109_b(-4F, 0.0F, 0.0F);

        for(int j = 0; j < 4; j++)
        {
            GlStateManager.func_179114_b(90.0F, 1.0F, 0.0F, 0.0F);
            GL11.glNormal3f(0.0F, 0.0F, scale);
            
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldrenderer.func_181662_b(-8.0D, -2.0D, 0.0D).func_187315_a((double)f2, (double)f4).func_181675_d();
            worldrenderer.func_181662_b(8.0D, -2.0D, 0.0D).func_187315_a((double)f3, (double)f4).func_181675_d();
            worldrenderer.func_181662_b(8.0D, 2.0D, 0.0D).func_187315_a((double)f3, (double)f5).func_181675_d();
            worldrenderer.func_181662_b(-8.0D, 2.0D, 0.0D).func_187315_a((double)f2, (double)f5).func_181675_d();
            tessellator.func_78381_a();
        }

        GL11.glDisable(GL12.GL_RESCALE_NORMAL);
        MekanismRenderer.resetColor();
        MekanismRenderer.glowOff();
        MekanismRenderer.blendOff();
        GlStateManager.func_179121_F();
    }
    
    @Override
    protected ResourceLocation func_110775_a(EntityFlame entity)
    {
        return new ResourceLocation("mekanism:render/Flame.png");
    }
}
